/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.output.adapter.core;

import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.output.adapter.core.TenantConfigHolder;
import org.wso2.carbon.event.output.adapter.core.exception.OutputEventAdapterRuntimeException;
import org.wso2.carbon.event.output.adapter.core.internal.config.AdapterConfig;
import org.wso2.carbon.event.output.adapter.core.internal.config.AdapterConfigs;
import org.wso2.carbon.event.output.adapter.core.internal.ds.OutputEventAdapterServiceValueHolder;

public class EventAdapterUtil {
    public static AxisConfiguration getAxisConfiguration() {
        AxisConfiguration axisConfiguration = null;
        if (CarbonContext.getThreadLocalCarbonContext().getTenantId() == -1234) {
            axisConfiguration = OutputEventAdapterServiceValueHolder.getConfigurationContextService().getServerConfigContext().getAxisConfiguration();
        } else {
            ConfigurationContext configurationContext = TenantConfigHolder.getTenantConfig(PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            if (configurationContext != null) {
                axisConfiguration = configurationContext.getAxisConfiguration();
            } else {
                throw new OutputEventAdapterRuntimeException("Tenant configuration not found");
            }
        }
        return axisConfiguration;
    }

    public static void logAndDrop(String adapterName, Object event, String message, Throwable e, Log log, int tenantId) {
        message = message != null ? message + ", " : "";
        log.error((Object)("Event dropped at Output Adapter '" + adapterName + "' for tenant id '" + tenantId + "', " + message + e.getMessage()), e);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Error at Output Adapter '" + adapterName + "' for tenant id '" + tenantId + "', dropping event: \n" + event), e);
        }
    }

    public static void logAndDrop(String adapterName, Object event, String message, Log log, int tenantId) {
        log.error((Object)("Event dropped at Output Adapter '" + adapterName + "' for tenant id '" + tenantId + "', " + message));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Error at Output Adapter '" + adapterName + "' for tenant id '" + tenantId + "', dropping event: \n" + event));
        }
    }

    public static Map<String, String> getGlobalProperties(String type) {
        AdapterConfig adapterConfig;
        AdapterConfigs adapterConfigs = OutputEventAdapterServiceValueHolder.getGlobalAdapterConfigs();
        if (adapterConfigs != null && (adapterConfig = adapterConfigs.getAdapterConfig(type)) != null) {
            return adapterConfig.getGlobalPropertiesAsMap();
        }
        return null;
    }
}

