/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.status;

import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.status.StatusBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class StatusCommand
extends BasicCommand {
    private EventManager eventManager;
    private boolean includeTags;

    public Builder createBuilder(EventManager eventManager) {
        return new StatusBuilder(eventManager, this);
    }

    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        this.eventManager = eventManager;
        super.execute(clientServices, eventManager);
        try {
            if (this.includeTags) {
                this.requests.add(1, new ArgumentRequest("-v"));
            }
            this.addRequestForWorkingDirectory(clientServices);
            this.addArgumentRequests();
            this.addRequest(CommandRequest.STATUS);
            clientServices.processRequests(this.requests);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    public boolean isIncludeTags() {
        return this.includeTags;
    }

    public void setIncludeTags(boolean bl) {
        this.includeTags = bl;
    }

    public void commandTerminated(TerminationEvent terminationEvent) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("status ");
        stringBuffer.append(this.getCVSArguments());
        File[] fileArray = this.getFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                stringBuffer.append(fileArray[i].getName());
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'v') {
            this.setIncludeTags(true);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rlv";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setIncludeTags(false);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isIncludeTags()) {
            stringBuffer.append("-v ");
        }
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        return stringBuffer.toString();
    }
}

