/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BuildableCommand;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.RootRequest;

public abstract class RepositoryCommand
extends BuildableCommand {
    protected List requests = new LinkedList();
    protected ClientServices clientServices;
    private boolean recursive = true;
    protected final List modules = new LinkedList();
    protected final List expandedModules = new LinkedList();

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public void addModule(String string) {
        this.modules.add(string);
    }

    public void setModules(String[] stringArray) {
        this.clearModules();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.modules.add(string);
        }
    }

    public String[] getModules() {
        String[] stringArray = new String[this.modules.size()];
        stringArray = this.modules.toArray(stringArray);
        return stringArray;
    }

    public void clearModules() {
        this.modules.clear();
    }

    protected final void addArgumentRequests() {
        if (this.expandedModules.size() == 0) {
            return;
        }
        Iterator iterator = this.expandedModules.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.addRequest(new ArgumentRequest(string));
        }
    }

    public final void moduleExpanded(ModuleExpansionEvent moduleExpansionEvent) {
        this.expandedModules.add(moduleExpansionEvent.getModule());
    }

    public final void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        this.requests.clear();
        super.execute(clientServices, eventManager);
        this.clientServices = clientServices;
        if (clientServices.isFirstCommand()) {
            this.requests.add(new RootRequest(clientServices.getRepository()));
        }
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.requests.add(new ArgumentRequest(string));
        }
        this.expandedModules.clear();
        this.requests.add(new DirectoryRequest(".", clientServices.getRepository()));
        this.requests.add(new ExpandModulesRequest());
        try {
            clientServices.processRequests(this.requests);
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
        this.requests.clear();
        this.postExpansionExecute(clientServices, eventManager);
    }

    protected abstract void postExpansionExecute(ClientServices var1, EventManager var2) throws CommandException, AuthenticationException;

    protected final void addRequest(Request request) {
        this.requests.add(request);
    }

    protected final void addRequestForWorkingDirectory(ClientServices clientServices) throws IOException {
        this.addRequest(new DirectoryRequest(".", clientServices.getRepositoryForDirectory(this.getLocalDirectory())));
    }

    protected final void addArgumentRequest(boolean bl, String string) {
        if (!bl) {
            return;
        }
        this.addRequest(new ArgumentRequest(string));
    }

    protected final void appendModuleArguments(StringBuffer stringBuffer) {
        if (this.expandedModules.size() == 0) {
            return;
        }
        Iterator iterator = this.expandedModules.iterator();
        stringBuffer.append((String)iterator.next());
        while (iterator.hasNext()) {
            stringBuffer.append(' ');
            stringBuffer.append((String)iterator.next());
        }
    }
}

