/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.vss.commands;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.vss.repository.VssScmProviderRepository;
import org.apache.maven.scm.providers.vss.settings.Settings;
import org.apache.maven.scm.providers.vss.settings.io.xpp3.VssXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public final class VssCommandLineUtils {
    private static File scmConfDir = new File(System.getProperty("user.home"), ".scm");
    private static Settings settings;

    private VssCommandLineUtils() {
    }

    public static void addFiles(Commandline cl, ScmFileSet fileSet) {
        for (File file : fileSet.getFileList()) {
            cl.createArg().setValue(file.getPath().replace('\\', '/'));
        }
    }

    public static Commandline getBaseVssCommandLine(File workingDirectory, String cmd, VssScmProviderRepository repository) {
        Commandline cl = new Commandline();
        cl.setExecutable("ss");
        cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        if (!StringUtils.isEmpty(repository.getUser())) {
            cl.createArg().setValue("-Y");
            StringBuilder sb = new StringBuilder(repository.getUser());
            if (!StringUtils.isEmpty(repository.getPassword())) {
                sb.append(",").append(repository.getPassword());
            }
            cl.createArg().setValue(sb.toString());
        }
        return cl;
    }

    public static int executeCommandline(Commandline cl, StreamConsumer consumer, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws ScmException {
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Executing: " + cl);
                logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
            }
            int exitcode = CommandLineUtils.executeCommandLine(cl, consumer, stderr);
            if (logger.isDebugEnabled()) {
                logger.debug("VSS Command Exit_Code: " + exitcode);
            }
            return exitcode;
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", ex);
        }
    }

    public static final Settings getSettings() {
        if (settings == null) {
            settings = VssCommandLineUtils.readSettings();
        }
        return settings;
    }

    public static Settings readSettings() {
        String vssDirectory;
        Settings settings = null;
        File settingsFile = VssCommandLineUtils.getScmConfFile();
        if (settingsFile.exists()) {
            VssXpp3Reader reader = new VssXpp3Reader();
            try {
                settings = reader.read(ReaderFactory.newXmlReader(settingsFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            catch (XmlPullParserException e) {
                String message = settingsFile.getAbsolutePath() + " isn't well formed. SKIPPED." + e.getMessage();
                System.err.println(message);
            }
        }
        if (StringUtils.isNotEmpty(vssDirectory = System.getProperty("vssDirectory"))) {
            if (settings == null) {
                settings = new Settings();
            }
            settings.setVssDirectory(vssDirectory);
        }
        return settings;
    }

    protected static final File getScmConfDir() {
        return scmConfDir;
    }

    protected static final void setScmConfDir(File directory) {
        scmConfDir = directory;
        settings = VssCommandLineUtils.readSettings();
    }

    public static final String getSsDir() {
        String ssDir2;
        String ssDir = "";
        if (VssCommandLineUtils.getSettings() != null && (ssDir2 = VssCommandLineUtils.getSettings().getVssDirectory()) != null && !(ssDir = StringUtils.replace(ssDir2, "\\", "/")).endsWith("/")) {
            ssDir = ssDir + "/";
        }
        return ssDir;
    }

    public static File getScmConfFile() {
        return new File(scmConfDir, "vss-settings.xml");
    }
}

