/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.tfs.command;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.list.AbstractListCommand;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.tfs.command.TfsCommand;
import org.apache.maven.scm.provider.tfs.command.consumer.ErrorStreamConsumer;
import org.apache.maven.scm.provider.tfs.command.consumer.ServerFileListConsumer;

public class TfsListCommand
extends AbstractListCommand {
    protected ListScmResult executeListCommand(ScmProviderRepository r, ScmFileSet f, boolean recursive, ScmVersion v) throws ScmException {
        ServerFileListConsumer out = new ServerFileListConsumer();
        ErrorStreamConsumer err = new ErrorStreamConsumer();
        TfsCommand command = this.createCommand(r, f, recursive);
        int status2 = command.execute(out, err);
        if (status2 != 0 || err.hasBeenFed()) {
            return new ListScmResult(command.getCommandString(), "Error code for TFS list command - " + status2, err.getOutput(), false);
        }
        return new ListScmResult(command.getCommandString(), out.getFiles());
    }

    public TfsCommand createCommand(ScmProviderRepository r, ScmFileSet f, boolean recursive) {
        TfsCommand command = new TfsCommand("dir", r, f, this.getLogger());
        if (recursive) {
            command.addArgument("-recursive");
        }
        command.addArgument(f);
        return command;
    }
}

