/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.status;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnStatusConsumer
implements StreamConsumer {
    private ScmLogger logger;
    private File workingDirectory;
    private List<ScmFile> changedFiles = new ArrayList<ScmFile>();

    public SvnStatusConsumer(ScmLogger logger, File workingDirectory) {
        this.logger = logger;
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void consumeLine(String line) {
        ScmFileStatus status2;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        if (StringUtils.isEmpty(line.trim())) {
            return;
        }
        if (line.length() <= 7) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unexpected input, the line must be at least seven characters long. Line: '" + line + "'.");
            }
            return;
        }
        String statusString = line.substring(0, 1);
        String file = line.substring(7).trim();
        if (statusString.equals("A")) {
            status2 = ScmFileStatus.ADDED;
        } else if (statusString.equals("M") || statusString.equals("R") || statusString.equals("~")) {
            status2 = ScmFileStatus.MODIFIED;
        } else if (statusString.equals("D")) {
            status2 = ScmFileStatus.DELETED;
        } else if (statusString.equals("?")) {
            status2 = ScmFileStatus.UNKNOWN;
        } else if (statusString.equals("!")) {
            status2 = ScmFileStatus.MISSING;
        } else if (statusString.equals("C")) {
            status2 = ScmFileStatus.CONFLICT;
        } else if (statusString.equals("L")) {
            status2 = ScmFileStatus.LOCKED;
        } else {
            if (statusString.equals("X")) {
                return;
            }
            if (statusString.equals("I")) {
                return;
            }
            statusString = line.substring(1, 1);
            if (statusString.equals("M")) {
                status2 = ScmFileStatus.MODIFIED;
            } else if (statusString.equals("C")) {
                status2 = ScmFileStatus.CONFLICT;
            } else {
                return;
            }
        }
        if (!(status2.equals(ScmFileStatus.DELETED) || status2.equals(ScmFileStatus.MISSING) || new File(this.workingDirectory, file).isFile() || new File(this.workingDirectory, file).isDirectory())) {
            return;
        }
        this.changedFiles.add(new ScmFile(file, status2));
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }
}

