/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.starteam;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.unedit.UnEditScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.starteam.command.add.StarteamAddCommand;
import org.apache.maven.scm.provider.starteam.command.changelog.StarteamChangeLogCommand;
import org.apache.maven.scm.provider.starteam.command.checkin.StarteamCheckInCommand;
import org.apache.maven.scm.provider.starteam.command.checkout.StarteamCheckOutCommand;
import org.apache.maven.scm.provider.starteam.command.diff.StarteamDiffCommand;
import org.apache.maven.scm.provider.starteam.command.edit.StarteamEditCommand;
import org.apache.maven.scm.provider.starteam.command.remove.StarteamRemoveCommand;
import org.apache.maven.scm.provider.starteam.command.status.StarteamStatusCommand;
import org.apache.maven.scm.provider.starteam.command.tag.StarteamTagCommand;
import org.apache.maven.scm.provider.starteam.command.unedit.StarteamUnEditCommand;
import org.apache.maven.scm.provider.starteam.command.update.StarteamUpdateCommand;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;

public class StarteamScmProvider
extends AbstractScmProvider {
    public static final String STARTEAM_URL_FORMAT = "[username[:password]@]hostname:port:/projectName/[viewName/][folderHiearchy/]";

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        String path;
        int port;
        String host;
        String[] tokens;
        String user = null;
        String password = null;
        int index = scmSpecificUrl.indexOf(64);
        String rest = scmSpecificUrl;
        if (index != -1) {
            String userAndPassword = scmSpecificUrl.substring(0, index);
            rest = scmSpecificUrl.substring(index + 1);
            index = userAndPassword.indexOf(58);
            if (index != -1) {
                user = userAndPassword.substring(0, index);
                password = userAndPassword.substring(index + 1);
            } else {
                user = userAndPassword;
            }
        }
        if ((tokens = StringUtils.split(rest, Character.toString(delimiter))).length == 3) {
            host = tokens[0];
            port = new Integer(tokens[1]);
            path = tokens[2];
        } else if (tokens.length == 2) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Your scm URL use a deprecated format. The new format is :[username[:password]@]hostname:port:/projectName/[viewName/][folderHiearchy/]");
            }
            host = tokens[0];
            if (tokens[1].indexOf(47) == -1) {
                throw new ScmRepositoryException("Invalid SCM URL: The url has to be on the form: [username[:password]@]hostname:port:/projectName/[viewName/][folderHiearchy/]");
            }
            int at = tokens[1].indexOf(47);
            port = new Integer(tokens[1].substring(0, at));
            path = tokens[1].substring(at);
        } else {
            throw new ScmRepositoryException("Invalid SCM URL: The url has to be on the form: [username[:password]@]hostname:port:/projectName/[viewName/][folderHiearchy/]");
        }
        try {
            return new StarteamScmProviderRepository(user, password, host, port, path);
        }
        catch (Exception e) {
            throw new ScmRepositoryException("Invalid SCM URL: The url has to be on the form: [username[:password]@]hostname:port:/projectName/[viewName/][folderHiearchy/]");
        }
    }

    public String getScmType() {
        return "starteam";
    }

    public AddScmResult add(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        fileSet = StarteamScmProvider.fixUpScmFileSetAbsoluteFilePath(fileSet);
        StarteamAddCommand command = new StarteamAddCommand();
        command.setLogger(this.getLogger());
        return (AddScmResult)command.execute(repository, fileSet, parameters);
    }

    public ChangeLogScmResult changelog(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        fileSet = StarteamScmProvider.fixUpScmFileSetAbsoluteFilePath(fileSet);
        StarteamChangeLogCommand command = new StarteamChangeLogCommand();
        command.setLogger(this.getLogger());
        return (ChangeLogScmResult)command.execute(repository, fileSet, parameters);
    }

    public CheckInScmResult checkin(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        fileSet = StarteamScmProvider.fixUpScmFileSetAbsoluteFilePath(fileSet);
        StarteamCheckInCommand command = new StarteamCheckInCommand();
        command.setLogger(this.getLogger());
        return (CheckInScmResult)command.execute(repository, fileSet, parameters);
    }

    public CheckOutScmResult checkout(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        fileSet = StarteamScmProvider.fixUpScmFileSetAbsoluteFilePath(fileSet);
        StarteamCheckOutCommand command = new StarteamCheckOutCommand();
        command.setLogger(this.getLogger());
        return (CheckOutScmResult)command.execute(repository, fileSet, parameters);
    }

    public DiffScmResult diff(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        fileSet = StarteamScmProvider.fixUpScmFileSetAbsoluteFilePath(fileSet);
        StarteamDiffCommand command = new StarteamDiffCommand();
        command.setLogger(this.getLogger());
        return (DiffScmResult)command.execute(repository, fileSet, parameters);
    }

    public StatusScmResult status(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        fileSet = StarteamScmProvider.fixUpScmFileSetAbsoluteFilePath(fileSet);
        StarteamStatusCommand command = new StarteamStatusCommand();
        command.setLogger(this.getLogger());
        return (StatusScmResult)command.execute(repository, fileSet, parameters);
    }

    public TagScmResult tag(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        fileSet = StarteamScmProvider.fixUpScmFileSetAbsoluteFilePath(fileSet);
        StarteamTagCommand command = new StarteamTagCommand();
        command.setLogger(this.getLogger());
        return (TagScmResult)command.execute(repository, fileSet, parameters);
    }

    public UpdateScmResult update(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        fileSet = StarteamScmProvider.fixUpScmFileSetAbsoluteFilePath(fileSet);
        StarteamUpdateCommand command = new StarteamUpdateCommand();
        command.setLogger(this.getLogger());
        return (UpdateScmResult)command.execute(repository, fileSet, parameters);
    }

    protected EditScmResult edit(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        fileSet = StarteamScmProvider.fixUpScmFileSetAbsoluteFilePath(fileSet);
        StarteamEditCommand command = new StarteamEditCommand();
        command.setLogger(this.getLogger());
        return (EditScmResult)command.execute(repository, fileSet, parameters);
    }

    protected UnEditScmResult unedit(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        fileSet = StarteamScmProvider.fixUpScmFileSetAbsoluteFilePath(fileSet);
        StarteamUnEditCommand command = new StarteamUnEditCommand();
        command.setLogger(this.getLogger());
        return (UnEditScmResult)command.execute(repository, fileSet, parameters);
    }

    public RemoveScmResult remove(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        fileSet = StarteamScmProvider.fixUpScmFileSetAbsoluteFilePath(fileSet);
        StarteamRemoveCommand command = new StarteamRemoveCommand();
        command.setLogger(this.getLogger());
        return (RemoveScmResult)command.execute(repository, fileSet, parameters);
    }

    private static ScmFileSet fixUpScmFileSetAbsoluteFilePath(ScmFileSet currentFileSet) throws ScmException {
        ScmFileSet newFileSet = null;
        try {
            File basedir = StarteamScmProvider.getAbsoluteFilePath(currentFileSet.getBasedir());
            List<File> files = currentFileSet.getFileList();
            ArrayList<File> relPathFiles = new ArrayList<File>(files.size());
            for (File file : files) {
                if (file.isAbsolute()) {
                    relPathFiles.add(new File(StarteamScmProvider.getRelativePath(basedir, file)));
                    continue;
                }
                relPathFiles.add(file);
            }
            newFileSet = new ScmFileSet(basedir, relPathFiles);
        }
        catch (IOException e) {
            throw new ScmException("Invalid file set.", e);
        }
        return newFileSet;
    }

    public static String getRelativePath(File basedir, File f) throws ScmException, IOException {
        File fileOrDir = StarteamScmProvider.getAbsoluteFilePath(f);
        if (!fileOrDir.getCanonicalPath().startsWith(basedir.getCanonicalPath())) {
            throw new ScmException(fileOrDir.getPath() + " was not contained in " + basedir.getPath());
        }
        if (basedir.getCanonicalFile().equals(basedir.getAbsoluteFile())) {
            return fileOrDir.getPath().substring(basedir.getPath().length() + 1, fileOrDir.getPath().length());
        }
        return fileOrDir.getPath().substring(basedir.getCanonicalPath().length() + 1, fileOrDir.getPath().length());
    }

    private static File getAbsoluteFilePath(File fileOrDir) throws IOException {
        String javaPathString = fileOrDir.getCanonicalPath().replace('\\', '/');
        if (javaPathString.endsWith("/")) {
            javaPathString = javaPathString.substring(0, javaPathString.length() - 1);
        }
        return new File(javaPathString);
    }
}

