/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.status;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.status.AbstractStatusCommand;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.PerforceVerbMapper;
import org.apache.maven.scm.provider.perforce.command.status.PerforceStatusConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.apache.regexp.RE;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceStatusCommand
extends AbstractStatusCommand
implements PerforceCommand {
    private String actualLocation;

    @Override
    protected StatusScmResult executeStatusCommand(ScmProviderRepository repo, ScmFileSet files) throws ScmException {
        PerforceScmProviderRepository prepo = (PerforceScmProviderRepository)repo;
        this.actualLocation = PerforceScmProvider.getRepoPath(this.getLogger(), prepo, files.getBasedir());
        PerforceStatusConsumer consumer = new PerforceStatusConsumer();
        Commandline command = this.readOpened(prepo, files, consumer);
        if (consumer.isSuccess()) {
            List<ScmFile> scmfiles = PerforceStatusCommand.createResults(this.actualLocation, consumer);
            return new StatusScmResult(command.toString(), scmfiles);
        }
        return new StatusScmResult(command.toString(), "Unable to get status", consumer.getOutput(), consumer.isSuccess());
    }

    public static List<ScmFile> createResults(String repoPath, PerforceStatusConsumer consumer) {
        ArrayList<ScmFile> results = new ArrayList<ScmFile>();
        List<String> files = consumer.getDepotfiles();
        RE re = new RE("([^#]+)#\\d+ - ([^ ]+) .*");
        for (String filepath : files) {
            if (!re.match(filepath)) {
                System.err.println("Skipping " + filepath);
                continue;
            }
            String path = re.getParen(1);
            String verb = re.getParen(2);
            ScmFile scmfile = new ScmFile(path.substring(repoPath.length() + 1).trim(), PerforceVerbMapper.toStatus(verb));
            results.add(scmfile);
        }
        return results;
    }

    private Commandline readOpened(PerforceScmProviderRepository prepo, ScmFileSet files, PerforceStatusConsumer consumer) {
        Commandline cl;
        block4: {
            cl = PerforceStatusCommand.createOpenedCommandLine(prepo, files.getBasedir(), this.actualLocation);
            try {
                CommandLineUtils.StringStreamConsumer err;
                int exitCode;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(PerforceScmProvider.clean("Executing " + cl.toString()));
                }
                if ((exitCode = CommandLineUtils.executeCommandLine(cl, consumer, err = new CommandLineUtils.StringStreamConsumer())) != 0) {
                    String cmdLine = CommandLineUtils.toString(cl.getCommandline());
                    StringBuilder msg = new StringBuilder("Exit code: " + exitCode + " - " + err.getOutput());
                    msg.append('\n');
                    msg.append("Command line was:" + cmdLine);
                    throw new CommandLineException(msg.toString());
                }
            }
            catch (CommandLineException e) {
                if (!this.getLogger().isErrorEnabled()) break block4;
                this.getLogger().error("CommandLineException " + e.getMessage(), e);
            }
        }
        return cl;
    }

    public static Commandline createOpenedCommandLine(PerforceScmProviderRepository repo, File workingDirectory, String location) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArg().setValue("opened");
        command.createArg().setValue(PerforceScmProvider.getCanonicalRepoPath(location));
        return command;
    }
}

