/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.add;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceAddConsumer
implements StreamConsumer {
    private static final String PATTERN = "^([^#]+)#(\\d+) - (.*)";
    private static final String FILE_BEGIN_TOKEN = "//";
    private List<ScmFile> additions = new ArrayList<ScmFile>();
    private RE revisionRegexp;

    public PerforceAddConsumer() {
        try {
            this.revisionRegexp = new RE(PATTERN);
        }
        catch (RESyntaxException ignored) {
            ignored.printStackTrace();
        }
    }

    public List<ScmFile> getAdditions() {
        return this.additions;
    }

    @Override
    public void consumeLine(String line) {
        if (line.startsWith("... ")) {
            return;
        }
        if (!line.startsWith(FILE_BEGIN_TOKEN)) {
            throw new IllegalStateException("Unknown error: " + line);
        }
        if (!this.revisionRegexp.match(line)) {
            throw new IllegalStateException("Unknown input: " + line);
        }
        this.additions.add(new ScmFile(this.revisionRegexp.getParen(1), ScmFileStatus.ADDED));
    }
}

