/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.local.metadata;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.local.metadata.LocalScmMetadata;
import org.apache.maven.scm.provider.local.metadata.io.xpp3.LocalScmMetadataXpp3Reader;
import org.apache.maven.scm.provider.local.metadata.io.xpp3.LocalScmMetadataXpp3Writer;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class LocalScmMetadataUtils {
    public static final String FILENAME = ".maven-scm-local";
    protected final ScmLogger logger;

    public LocalScmMetadataUtils(ScmLogger logger) {
        this.logger = logger;
    }

    public LocalScmMetadata buildMetadata(File repository) throws IOException {
        List repoFilenames = FileUtils.getFileNames(repository.getAbsoluteFile(), "**", null, false);
        LocalScmMetadata metadata = new LocalScmMetadata();
        metadata.setRepositoryFileNames(repoFilenames);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMetadata(File destinationDir, LocalScmMetadata metadata) throws IOException {
        File metadataFile = new File(destinationDir, FILENAME);
        metadataFile.createNewFile();
        XmlStreamWriter writer = WriterFactory.newXmlWriter(metadataFile);
        try {
            new LocalScmMetadataXpp3Writer().write(writer, metadata);
        }
        finally {
            IOUtil.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalScmMetadata readMetadata(File dir) {
        File metadataFile = new File(dir, FILENAME);
        if (!metadataFile.exists()) {
            return null;
        }
        LocalScmMetadata result = null;
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader(metadataFile);
            result = new LocalScmMetadataXpp3Reader().read(reader);
        }
        catch (XmlPullParserException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Could not interpret .maven-scm-local - ignoring", e);
            }
            LocalScmMetadata localScmMetadata = null;
            return localScmMetadata;
        }
        catch (IOException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Could not Read .maven-scm-local - ignoring", e);
            }
        }
        finally {
            IOUtil.close(reader);
        }
        return result;
    }
}

