/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.local.command.mkdir;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.mkdir.AbstractMkdirCommand;
import org.apache.maven.scm.command.mkdir.MkdirScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.local.command.add.LocalAddCommand;
import org.apache.maven.scm.provider.local.repository.LocalScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;

public class LocalMkdirCommand
extends AbstractMkdirCommand {
    protected MkdirScmResult executeMkdirCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message, boolean createInLocal) throws ScmException {
        LocalScmProviderRepository repo = (LocalScmProviderRepository)repository;
        ArrayList<ScmFile> createdDirs = new ArrayList<ScmFile>();
        if (!createInLocal) {
            File file = fileSet.getFileList().get(0);
            File modulePath = new File(repo.getRoot(), repo.getModule());
            File dir = new File(modulePath, file.getName());
            if (dir.exists()) {
                return new MkdirScmResult(null, "Directory already exists!", "Directory already exists.", false);
            }
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Creating directory in '" + modulePath.getAbsolutePath() + "'");
            }
            FileUtils.mkdir(dir.getAbsolutePath());
            createdDirs.add(new ScmFile(dir.getPath(), ScmFileStatus.ADDED));
        } else {
            LocalAddCommand addCmd = new LocalAddCommand();
            addCmd.setLogger(this.getLogger());
            CommandParameters parameters = new CommandParameters();
            parameters.setString(CommandParameter.MESSAGE, message);
            parameters.setString(CommandParameter.BINARY, "false");
            String path = fileSet.getFileList().get(0).getPath();
            if (repo.isFileAdded(path)) {
                return new MkdirScmResult(null, "Directory already exists!", "Directory already exists.", false);
            }
            AddScmResult result = (AddScmResult)addCmd.execute(repository, fileSet, parameters);
            createdDirs.addAll(result.getAddedFiles());
        }
        return new MkdirScmResult(null, createdDirs);
    }
}

