/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command.update;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.consumer.AbstractRepositoryConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JazzUpdateConsumer
extends AbstractRepositoryConsumer {
    public static final String UPDATE_CMD_ADD_FLAG = "-a-";
    public static final String UPDATE_CMD_CHANGE_FLAG = "--c";
    public static final String UPDATE_CMD_DELETE_FLAG = "-d-";
    public static final String UPDATE_CMD_MOVED_FLAG = "-m-";
    private List<ScmFile> fUpdatedFiles = new ArrayList<ScmFile>();

    public JazzUpdateConsumer(ScmProviderRepository repository, ScmLogger logger) {
        super(repository, logger);
    }

    @Override
    public void consumeLine(String line) {
        super.consumeLine(line);
        if (this.containsStatusFlag(line)) {
            this.extractUpdatedFile(line);
        }
    }

    private boolean containsStatusFlag(String line) {
        String flag;
        boolean containsStatusFlag = false;
        if (line.trim().length() > 3 && (UPDATE_CMD_ADD_FLAG.equals(flag = line.trim().substring(0, 3)) || UPDATE_CMD_CHANGE_FLAG.equals(flag) || UPDATE_CMD_DELETE_FLAG.equals(flag) || UPDATE_CMD_MOVED_FLAG.equals(flag))) {
            containsStatusFlag = true;
        }
        return containsStatusFlag;
    }

    private void extractUpdatedFile(String line) {
        String filePath = "";
        String flag = line.trim().substring(0, 3);
        ScmFileStatus status2 = ScmFileStatus.UNKNOWN;
        if (UPDATE_CMD_ADD_FLAG.equals(flag)) {
            status2 = ScmFileStatus.ADDED;
            filePath = line.trim().substring(4);
        }
        if (UPDATE_CMD_CHANGE_FLAG.equals(flag)) {
            status2 = ScmFileStatus.UPDATED;
            filePath = line.trim().substring(4);
        }
        if (UPDATE_CMD_DELETE_FLAG.equals(flag)) {
            status2 = ScmFileStatus.DELETED;
            filePath = line.trim().substring(4);
        }
        if (UPDATE_CMD_MOVED_FLAG.equals(flag)) {
            status2 = ScmFileStatus.ADDED;
            String pattern = "^-m-\\s(.*)\\s\\(moved\\sfrom\\s.*$";
            Pattern r = Pattern.compile(pattern);
            Matcher m = r.matcher(line.trim());
            if (m.find()) {
                filePath = m.group(1);
            }
        }
        this.fUpdatedFiles.add(new ScmFile(filePath, status2));
    }

    public List<ScmFile> getUpdatedFiles() {
        return this.fUpdatedFiles;
    }
}

