/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command;

import java.io.File;
import java.util.Iterator;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.consumer.ErrorConsumer;
import org.apache.maven.scm.provider.jazz.repository.JazzScmProviderRepository;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JazzScmCommand {
    private ScmLogger fLogger;
    private Commandline fCommand;

    public JazzScmCommand(String cmd, ScmProviderRepository repo, ScmFileSet fileSet, ScmLogger logger) {
        this(cmd, null, repo, true, fileSet, logger);
    }

    public JazzScmCommand(String cmd, String subCmd, ScmProviderRepository repo, ScmFileSet fileSet, ScmLogger logger) {
        this(cmd, subCmd, repo, true, fileSet, logger);
    }

    public JazzScmCommand(String cmd, String subCmd, ScmProviderRepository repo, boolean addRepositoryWorkspaceArg, ScmFileSet fileSet, ScmLogger logger) {
        String password;
        String user;
        String repositoryWorkspace;
        this.fLogger = logger;
        this.fCommand = new Commandline();
        this.fCommand.setExecutable("scm");
        if (fileSet != null) {
            boolean success;
            this.fCommand.setWorkingDirectory(fileSet.getBasedir().getAbsolutePath());
            if (!this.fCommand.getWorkingDirectory().exists() && !(success = this.fCommand.getWorkingDirectory().mkdirs())) {
                this.logErrorMessage("Working directory did not exist and it couldn't be created: " + this.fCommand.getWorkingDirectory());
            }
        }
        if (!StringUtils.isEmpty(cmd)) {
            this.addArgument(cmd);
        }
        if (!StringUtils.isEmpty(subCmd)) {
            this.addArgument(subCmd);
        }
        JazzScmProviderRepository jazzRepo = (JazzScmProviderRepository)repo;
        if (addRepositoryWorkspaceArg && !StringUtils.isEmpty(repositoryWorkspace = jazzRepo.getRepositoryURI())) {
            this.addArgument("--repository-uri");
            this.addArgument(jazzRepo.getRepositoryURI());
        }
        if (!StringUtils.isEmpty(user = jazzRepo.getUser())) {
            this.addArgument("--username");
            this.addArgument(jazzRepo.getUser());
        }
        if (!StringUtils.isEmpty(password = jazzRepo.getPassword())) {
            this.addArgument("--password");
            this.addArgument(jazzRepo.getPassword());
        }
    }

    public void addArgument(ScmFileSet fileSet) {
        this.logInfoMessage("files: " + fileSet.getBasedir().getAbsolutePath());
        Iterator<File> iter = fileSet.getFileList().iterator();
        while (iter.hasNext()) {
            this.fCommand.createArg().setValue(iter.next().getPath());
        }
    }

    public void addArgument(String arg) {
        this.fCommand.createArg().setValue(arg);
    }

    public int execute(StreamConsumer out, ErrorConsumer err) throws ScmException {
        this.logInfoMessage("Executing: " + JazzScmCommand.cryptPassword(this.fCommand));
        if (this.fCommand.getWorkingDirectory() != null) {
            this.logInfoMessage("Working directory: " + this.fCommand.getWorkingDirectory().getAbsolutePath());
        }
        int status2 = 0;
        try {
            status2 = CommandLineUtils.executeCommandLine(this.fCommand, out, err);
        }
        catch (CommandLineException e) {
            String errorOutput = err.getOutput();
            if (errorOutput.length() > 0) {
                this.logErrorMessage("Error: " + err.getOutput());
            }
            throw new ScmException("Error while executing Jazz SCM command line - " + this.getCommandString(), e);
        }
        String errorOutput = err.getOutput();
        if (errorOutput.length() > 0) {
            this.logErrorMessage("Error: " + err.getOutput());
        }
        return status2;
    }

    public String getCommandString() {
        return this.fCommand.toString();
    }

    public Commandline getCommandline() {
        return this.fCommand;
    }

    private void logErrorMessage(String message) {
        if (this.fLogger != null) {
            this.fLogger.error(message);
        }
    }

    private void logInfoMessage(String message) {
        if (this.fLogger != null) {
            this.fLogger.info(message);
        }
    }

    private void logDebugMessage(String message) {
        if (this.fLogger != null) {
            this.fLogger.debug(message);
        }
    }

    public static String cryptPassword(Commandline cl) {
        String clString = cl.toString();
        int pos = clString.indexOf("--password");
        if (pos > 0) {
            String beforePassword = clString.substring(0, pos + "--password ".length());
            String afterPassword = clString.substring(pos + "--password ".length());
            afterPassword = (pos = afterPassword.indexOf(32)) > 0 ? afterPassword.substring(pos) : "\"";
            clString = Os.isFamily("windows") ? beforePassword + "*****" + afterPassword : beforePassword + "'*****'";
        }
        return clString;
    }
}

