/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.changelog;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.Command;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.changelog.HgChangeLogConsumer;

public class HgChangeLogCommand
extends AbstractChangeLogCommand
implements Command {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder dateInterval = new StringBuilder();
        dateInterval.append(dateFormat.format(startDate == null ? new Date(86400000L) : startDate));
        dateInterval.append(" to ");
        dateInterval.append(dateFormat.format(endDate == null ? new Date() : endDate));
        String[] cmd = new String[]{"log", "--verbose", "--no-merges", "--date", dateInterval.toString()};
        HgChangeLogConsumer consumer = new HgChangeLogConsumer(this.getLogger(), datePattern);
        ScmResult result = HgUtils.execute(consumer, this.getLogger(), fileSet.getBasedir(), cmd);
        List<ChangeSet> logEntries = consumer.getModifications();
        ChangeLogSet changeLogSet = new ChangeLogSet(logEntries, startDate, endDate);
        return new ChangeLogScmResult(changeLogSet, result);
    }

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion, String datePattern) throws ScmException {
        StringBuilder revisionInterval = new StringBuilder();
        if (startVersion != null) {
            revisionInterval.append(startVersion.getName());
        }
        revisionInterval.append(":");
        if (endVersion != null) {
            revisionInterval.append(endVersion.getName());
        }
        String[] cmd = new String[]{"log", "--verbose", "--no-merges", "-r", revisionInterval.toString()};
        HgChangeLogConsumer consumer = new HgChangeLogConsumer(this.getLogger(), datePattern);
        ScmResult result = HgUtils.execute(consumer, this.getLogger(), fileSet.getBasedir(), cmd);
        List<ChangeSet> logEntries = consumer.getModifications();
        Date startDate = null;
        Date endDate = null;
        if (!logEntries.isEmpty()) {
            startDate = logEntries.get(0).getDate();
            endDate = logEntries.get(logEntries.size() - 1).getDate();
        }
        ChangeLogSet changeLogSet = new ChangeLogSet(logEntries, startDate, endDate);
        changeLogSet.setStartVersion(startVersion);
        changeLogSet.setEndVersion(endVersion);
        return new ChangeLogScmResult(changeLogSet, result);
    }
}

