/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.update;

import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.StringUtils;

public class GitLatestRevisionCommandConsumer
extends AbstractConsumer {
    private static final String LATESTREV_PATTERN = "^commit \\s*(.*)";
    private RE latestRevRegexp;
    private String latestRevision;

    public GitLatestRevisionCommandConsumer(ScmLogger logger) {
        super(logger);
        try {
            this.latestRevRegexp = new RE(LATESTREV_PATTERN);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse git log file. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    public void consumeLine(String line) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("GitLatestRevisionCommandConsumer consumeLine : " + line);
        }
        if (line == null || StringUtils.isEmpty(line)) {
            return;
        }
        this.processGetLatestRevision(line);
    }

    public String getLatestRevision() {
        return this.latestRevision;
    }

    private void processGetLatestRevision(String line) {
        if (!this.latestRevRegexp.match(line)) {
            return;
        }
        this.latestRevision = this.latestRevRegexp.getParen(1);
    }
}

