/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.diff;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitDiffRawConsumer
implements StreamConsumer {
    private ScmLogger logger;
    private List<ScmFile> changedFiles = new ArrayList<ScmFile>();

    public GitDiffRawConsumer(ScmLogger logger) {
        this.logger = logger;
    }

    @Override
    public void consumeLine(String line) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        if (StringUtils.isEmpty(line)) {
            return;
        }
        ScmFileStatus status2 = null;
        String[] parts = line.split("\\s", 6);
        if (parts.length != 6) {
            this.logger.warn("Skipping line because it doesn't contain the right status parameters: " + line);
            return;
        }
        String modus = parts[4];
        String file = parts[5];
        if ("A".equals(modus)) {
            status2 = ScmFileStatus.ADDED;
        } else if ("M".equals(modus)) {
            status2 = ScmFileStatus.UPDATED;
        } else if ("D".equals(modus)) {
            status2 = ScmFileStatus.DELETED;
        } else {
            this.logger.warn("unknown status detected in line: " + line);
            return;
        }
        this.changedFiles.add(new ScmFile(file, status2));
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }
}

