/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.command.remoteinfo.RemoteInfoScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGitScmProvider
extends AbstractScmProvider {
    @Override
    public String getScmSpecificFilename() {
        return ".git";
    }

    @Override
    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        try {
            ScmUrlParserResult result = this.parseScmUrl(scmSpecificUrl, delimiter);
            if (result.messages.size() > 0) {
                throw new ScmRepositoryException("The scm url is invalid.", result.messages);
            }
            return result.repository;
        }
        catch (ScmException e) {
            throw new ScmRepositoryException("Error creating the scm repository", e);
        }
    }

    @Override
    public ScmProviderRepository makeProviderScmRepository(File path) throws ScmRepositoryException, UnknownRepositoryStructure {
        if (path == null) {
            throw new NullPointerException("Path argument is null");
        }
        if (!path.isDirectory()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a valid directory.");
        }
        if (!new File(path, ".git").exists()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a git checkout directory.");
        }
        try {
            return this.makeProviderScmRepository(this.getRepositoryURL(path), ':');
        }
        catch (ScmException e) {
            throw new ScmRepositoryException("Error creating the scm repository", e);
        }
    }

    protected abstract String getRepositoryURL(File var1) throws ScmException;

    @Override
    public List<String> validateScmUrl(String scmSpecificUrl, char delimiter) {
        ArrayList<String> messages = new ArrayList();
        try {
            this.makeProviderScmRepository(scmSpecificUrl, delimiter);
        }
        catch (ScmRepositoryException e) {
            messages = e.getValidationMessages();
        }
        return messages;
    }

    @Override
    public String getScmType() {
        return "git";
    }

    private ScmUrlParserResult parseScmUrl(String scmSpecificUrl, char delimiter) throws ScmException {
        ScmUrlParserResult result = new ScmUrlParserResult();
        result.repository = new GitScmProviderRepository(scmSpecificUrl);
        return result;
    }

    protected abstract GitCommand getAddCommand();

    @Override
    public AddScmResult add(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (AddScmResult)this.executeCommand(this.getAddCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getBranchCommand();

    @Override
    protected BranchScmResult branch(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (BranchScmResult)this.executeCommand(this.getBranchCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getChangeLogCommand();

    @Override
    public ChangeLogScmResult changelog(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (ChangeLogScmResult)this.executeCommand(this.getChangeLogCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getCheckInCommand();

    @Override
    public CheckInScmResult checkin(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (CheckInScmResult)this.executeCommand(this.getCheckInCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getCheckOutCommand();

    @Override
    public CheckOutScmResult checkout(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (CheckOutScmResult)this.executeCommand(this.getCheckOutCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getDiffCommand();

    @Override
    public DiffScmResult diff(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (DiffScmResult)this.executeCommand(this.getDiffCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getExportCommand();

    @Override
    protected ExportScmResult export(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (ExportScmResult)this.executeCommand(this.getExportCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getRemoveCommand();

    @Override
    public RemoveScmResult remove(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (RemoveScmResult)this.executeCommand(this.getRemoveCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getStatusCommand();

    @Override
    public StatusScmResult status(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (StatusScmResult)this.executeCommand(this.getStatusCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getTagCommand();

    @Override
    public TagScmResult tag(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (TagScmResult)this.executeCommand(this.getTagCommand(), repository, fileSet, parameters);
    }

    protected abstract GitCommand getUpdateCommand();

    @Override
    public UpdateScmResult update(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return (UpdateScmResult)this.executeCommand(this.getUpdateCommand(), repository, fileSet, parameters);
    }

    protected ScmResult executeCommand(GitCommand command, ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        command.setLogger(this.getLogger());
        return command.execute(repository, fileSet, parameters);
    }

    protected abstract GitCommand getListCommand();

    @Override
    public ListScmResult list(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        GitCommand cmd = this.getListCommand();
        return (ListScmResult)this.executeCommand(cmd, repository, fileSet, parameters);
    }

    protected abstract GitCommand getInfoCommand();

    @Override
    public InfoScmResult info(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        GitCommand cmd = this.getInfoCommand();
        return (InfoScmResult)this.executeCommand(cmd, repository, fileSet, parameters);
    }

    @Override
    protected BlameScmResult blame(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        GitCommand cmd = this.getBlameCommand();
        return (BlameScmResult)this.executeCommand(cmd, repository, fileSet, parameters);
    }

    protected abstract GitCommand getBlameCommand();

    @Override
    public RemoteInfoScmResult remoteInfo(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        GitCommand cmd = this.getRemoteInfoCommand();
        return (RemoteInfoScmResult)this.executeCommand(cmd, repository, fileSet, parameters);
    }

    protected abstract GitCommand getRemoteInfoCommand();

    private static class ScmUrlParserResult {
        private List<String> messages = new ArrayList<String>();
        private ScmProviderRepository repository;

        private ScmUrlParserResult() {
        }
    }
}

