/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.cvsjava.command.export;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.command.export.ExportScmResult;
import org.apache.maven.scm.provider.cvslib.command.export.AbstractCvsExportCommand;
import org.apache.maven.scm.provider.cvslib.command.update.CvsUpdateConsumer;
import org.apache.maven.scm.provider.cvslib.cvsjava.util.CvsConnection;
import org.apache.maven.scm.provider.cvslib.cvsjava.util.CvsLogListener;
import org.codehaus.plexus.util.cli.Commandline;

public class CvsJavaExportCommand
extends AbstractCvsExportCommand {
    protected ExportScmResult executeCvsCommand(Commandline cl) throws ScmException {
        CvsLogListener logListener = new CvsLogListener();
        CvsUpdateConsumer consumer = new CvsUpdateConsumer(this.getLogger());
        try {
            String line;
            boolean isSuccess = CvsConnection.processCommand(cl.getArguments(), cl.getWorkingDirectory().getAbsolutePath(), logListener, this.getLogger());
            if (!isSuccess) {
                return new ExportScmResult(cl.toString(), "The cvs command failed.", logListener.getStderr().toString(), false);
            }
            BufferedReader stream = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(logListener.getStdout().toString().getBytes())));
            while ((line = stream.readLine()) != null) {
                consumer.consumeLine(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ExportScmResult(cl.toString(), "The cvs command failed.", logListener.getStderr().toString(), false);
        }
        return new ExportScmResult(cl.toString(), consumer.getUpdatedFiles());
    }
}

