/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.tag;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.CvsCommandUtils;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.util.CvsUtil;
import org.apache.maven.scm.providers.cvslib.settings.Settings;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractCvsTagCommand
extends AbstractTagCommand
implements CvsCommand {
    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag2, String message) throws ScmException {
        return this.executeTagCommand(repo, fileSet, tag2, new ScmTagParameters(message));
    }

    public ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag2, ScmTagParameters scmTagParameters) throws ScmException {
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = CvsCommandUtils.getBaseCommand("tag", repository, fileSet, false);
        Settings settings = CvsUtil.getSettings();
        if (settings.isUseForceTag()) {
            cl.createArg().setValue("-F");
        }
        cl.createArg().setValue("-c");
        cl.createArg().setValue(tag2);
        if (fileSet.getFileList() != null && !fileSet.getFileList().isEmpty()) {
            for (File fileName : fileSet.getFileList()) {
                cl.createArg().setValue(fileName.toString());
            }
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Executing: " + cl);
            this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        return this.executeCvsCommand(cl);
    }

    protected abstract TagScmResult executeCvsCommand(Commandline var1) throws ScmException;
}

