/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar.command.remove;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.bazaar.command.BazaarConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BazaarRemoveConsumer
extends BazaarConsumer {
    private final File workingDir;
    private final List<ScmFile> removedFiles = new ArrayList<ScmFile>();

    public BazaarRemoveConsumer(ScmLogger logger, File workingDir) {
        super(logger);
        this.workingDir = workingDir;
    }

    @Override
    public void doConsume(ScmFileStatus status2, String trimmedLine) {
        if (status2 != null && status2 == ScmFileStatus.DELETED) {
            File tmpFile = new File(this.workingDir, trimmedLine);
            if (!tmpFile.exists()) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Not a file: " + tmpFile + ". Ignored");
                }
            } else {
                ScmFile scmFile = new ScmFile(trimmedLine, ScmFileStatus.DELETED);
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info(scmFile.toString());
                }
                this.removedFiles.add(scmFile);
            }
        }
    }

    public List<ScmFile> getRemovedFiles() {
        return this.removedFiles;
    }
}

