/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.accurev.command.changelog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmRevision;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.accurev.AccuRev;
import org.apache.maven.scm.provider.accurev.AccuRevCapability;
import org.apache.maven.scm.provider.accurev.AccuRevException;
import org.apache.maven.scm.provider.accurev.AccuRevScmProviderRepository;
import org.apache.maven.scm.provider.accurev.AccuRevVersion;
import org.apache.maven.scm.provider.accurev.FileDifference;
import org.apache.maven.scm.provider.accurev.Stream;
import org.apache.maven.scm.provider.accurev.Transaction;
import org.apache.maven.scm.provider.accurev.command.AbstractAccuRevCommand;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccuRevChangeLogCommand
extends AbstractAccuRevCommand {
    public AccuRevChangeLogCommand(ScmLogger logger) {
        super(logger);
    }

    @Override
    protected ScmResult executeAccurevCommand(AccuRevScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException, AccuRevException {
        ScmBranch branch = (ScmBranch)parameters.getScmVersion(CommandParameter.BRANCH, null);
        AccuRevVersion branchVersion = repository.getAccuRevVersion(branch);
        String stream = branchVersion.getBasisStream();
        String fromSpec = branchVersion.getTimeSpec();
        String toSpec = "highest";
        ScmVersion startVersion = parameters.getScmVersion(CommandParameter.START_SCM_VERSION, null);
        ScmVersion endVersion = parameters.getScmVersion(CommandParameter.END_SCM_VERSION, null);
        if (startVersion != null && StringUtils.isNotEmpty(startVersion.getName())) {
            AccuRevVersion toVersion;
            AccuRevVersion fromVersion = repository.getAccuRevVersion(startVersion);
            AccuRevVersion accuRevVersion = toVersion = endVersion == null ? new AccuRevVersion(fromVersion.getBasisStream(), "now") : repository.getAccuRevVersion(endVersion);
            if (!StringUtils.equals(fromVersion.getBasisStream(), toVersion.getBasisStream())) {
                throw new AccuRevException("Not able to provide change log between different streams " + fromVersion + "," + toVersion);
            }
            stream = fromVersion.getBasisStream();
            fromSpec = fromVersion.getTimeSpec();
            toSpec = toVersion.getTimeSpec();
        }
        Date startDate = parameters.getDate(CommandParameter.START_DATE, null);
        Date endDate = parameters.getDate(CommandParameter.END_DATE, null);
        int numDays = parameters.getInt(CommandParameter.NUM_DAYS, 0);
        if (numDays > 0) {
            if (startDate != null || endDate != null) {
                throw new ScmException("Start or end date cannot be set if num days is set.");
            }
            int day = 86400000;
            startDate = new Date(System.currentTimeMillis() - (long)numDays * (long)day);
            endDate = new Date(System.currentTimeMillis() + (long)day);
        }
        if (endDate != null && startDate == null) {
            throw new ScmException("The end date is set but the start date isn't.");
        }
        if (startDate != null) {
            fromSpec = AccuRevScmProviderRepository.formatTimeSpec(startDate);
        } else if (fromSpec == null) {
            fromSpec = "1";
        }
        Transaction fromTransaction = this.getDepotTransaction(repository, stream, fromSpec);
        long fromTranId = 1L;
        if (fromTransaction != null) {
            fromTranId = fromTransaction.getTranId();
            if (startDate == null) {
                startDate = fromTransaction.getWhen();
            }
        }
        if (endDate != null) {
            toSpec = AccuRevScmProviderRepository.formatTimeSpec(endDate);
        } else if (toSpec == null) {
            toSpec = "highest";
        }
        Transaction toTransaction = this.getDepotTransaction(repository, stream, toSpec);
        long toTranId = 1L;
        if (toTransaction != null) {
            toTranId = toTransaction.getTranId();
            if (endDate == null) {
                endDate = toTransaction.getWhen();
            }
        }
        startVersion = new ScmRevision(repository.getRevision(stream, fromTranId));
        endVersion = new ScmRevision(repository.getRevision(stream, toTranId));
        List<Transaction> streamHistory = Collections.emptyList();
        List<Transaction> workspaceHistory = Collections.emptyList();
        List<FileDifference> streamDifferences = Collections.emptyList();
        StringBuilder errorMessage = new StringBuilder();
        AccuRev accurev = repository.getAccuRev();
        Stream changelogStream = accurev.showStream(stream);
        if (changelogStream == null) {
            errorMessage.append("Unknown accurev stream -").append(stream).append(".");
        } else {
            String message = "Changelog on stream " + stream + "(" + changelogStream.getStreamType() + ") from " + fromTranId + " (" + startDate + "), to " + toTranId + " (" + endDate + ")";
            if (startDate != null && startDate.after(endDate) || fromTranId >= toTranId) {
                this.getLogger().warn("Skipping out of range " + message);
            } else {
                this.getLogger().info(message);
                Stream diffStream = changelogStream;
                if (changelogStream.isWorkspace().booleanValue()) {
                    workspaceHistory = accurev.history(stream, Long.toString(fromTranId + 1L), Long.toString(toTranId), 0, false, false);
                    if (workspaceHistory == null) {
                        errorMessage.append("history on workspace " + stream + " from " + fromTranId + 1 + " to " + toTranId + " failed.");
                    }
                    stream = changelogStream.getBasis();
                    diffStream = accurev.showStream(stream);
                }
                if (AccuRevCapability.DIFF_BETWEEN_STREAMS.isSupported(accurev.getClientVersion())) {
                    if (startDate.before(diffStream.getStartDate())) {
                        this.getLogger().warn("Skipping diff of " + stream + " due to start date out of range");
                    } else {
                        streamDifferences = accurev.diff(stream, Long.toString(fromTranId), Long.toString(toTranId));
                        if (streamDifferences == null) {
                            errorMessage.append("Diff " + stream + "- " + fromTranId + " to " + toTranId + "failed.");
                        }
                    }
                }
                if ((streamHistory = accurev.history(stream, Long.toString(fromTranId + 1L), Long.toString(toTranId), 0, false, false)) == null) {
                    errorMessage.append("history on stream " + stream + " from " + fromTranId + 1 + " to " + toTranId + " failed.");
                }
            }
        }
        String errorString = errorMessage.toString();
        if (StringUtils.isBlank(errorString)) {
            ChangeLogSet changeLog = this.getChangeLog(changelogStream, streamDifferences, streamHistory, workspaceHistory, startDate, endDate);
            changeLog.setEndVersion(endVersion);
            changeLog.setStartVersion(startVersion);
            return new ChangeLogScmResult(accurev.getCommandLines(), changeLog);
        }
        return new ChangeLogScmResult(accurev.getCommandLines(), "AccuRev errors: " + errorMessage, accurev.getErrorOutput(), false);
    }

    private Transaction getDepotTransaction(AccuRevScmProviderRepository repo, String stream, String tranSpec) throws AccuRevException {
        return repo.getDepotTransaction(stream, tranSpec);
    }

    private ChangeLogSet getChangeLog(Stream stream, List<FileDifference> streamDifferences, List<Transaction> streamHistory, List<Transaction> workspaceHistory, Date startDate, Date endDate) {
        HashMap<Long, FileDifference> differencesMap = new HashMap<Long, FileDifference>();
        for (FileDifference fileDifference : streamDifferences) {
            differencesMap.put(fileDifference.getElementId(), fileDifference);
        }
        ArrayList<Transaction> mergedHistory = new ArrayList<Transaction>(streamHistory);
        String streamPrefix = "/";
        mergedHistory.addAll(workspaceHistory);
        streamPrefix = stream.getId() + "/";
        ArrayList<ChangeSet> entries = new ArrayList<ChangeSet>(streamHistory.size());
        for (Transaction t : mergedHistory) {
            if (startDate != null && t.getWhen().before(startDate) || endDate != null && t.getWhen().after(endDate) || "mkstream".equals(t.getTranType())) continue;
            Collection<Transaction.Version> versions = t.getVersions();
            ArrayList<ChangeFile> files = new ArrayList<ChangeFile>(versions.size());
            for (Transaction.Version v : versions) {
                String newVersionSpec;
                FileDifference difference = (FileDifference)differencesMap.get(v.getElementId());
                if (difference != null && (newVersionSpec = difference.getNewVersionSpec()) != null && newVersionSpec.equals(v.getRealSpec())) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Removing difference for " + v);
                    }
                    differencesMap.remove(v.getElementId());
                }
                if (v.getRealSpec().startsWith(streamPrefix) && !v.getVirtualSpec().startsWith(streamPrefix)) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("Skipping workspace to basis stream promote " + v);
                    continue;
                }
                ChangeFile f = new ChangeFile(v.getElementName(), v.getVirtualSpec() + " (" + v.getRealSpec() + ")");
                files.add(f);
            }
            if (versions.isEmpty() || !files.isEmpty()) {
                ChangeSet changeSet = new ChangeSet(t.getWhen(), t.getComment(), t.getAuthor(), files);
                entries.add(changeSet);
                continue;
            }
            if (!this.getLogger().isDebugEnabled()) continue;
            this.getLogger().debug("All versions removed for " + t);
        }
        if (!differencesMap.isEmpty()) {
            ArrayList<ChangeFile> upstreamFiles = new ArrayList<ChangeFile>();
            for (FileDifference difference : differencesMap.values()) {
                if (difference.getNewVersionSpec() != null) {
                    upstreamFiles.add(new ChangeFile(difference.getNewFile().getPath(), difference.getNewVersionSpec()));
                    continue;
                }
                upstreamFiles.add(new ChangeFile(difference.getOldFile().getPath(), null));
            }
            entries.add(new ChangeSet(endDate, "Upstream changes", "various", upstreamFiles));
        }
        return new ChangeLogSet(entries, startDate, endDate);
    }

    public ChangeLogScmResult changelog(ScmProviderRepository repo, ScmFileSet testFileSet, CommandParameters params) throws ScmException {
        return (ChangeLogScmResult)this.execute(repo, testFileSet, params);
    }
}

