/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.jms.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSUtils
extends BaseUtils {
    private static final Log log = LogFactory.getLog(JMSUtils.class);
    private static final String MASKING_STRING = "***";

    public static String getProperty(Message message, String property) {
        try {
            return message.getStringProperty(property);
        }
        catch (JMSException e) {
            return null;
        }
    }

    public static Destination setReplyDestination(Destination replyDestination, Session session, Message message) {
        if (replyDestination == null) {
            try {
                replyDestination = JMSUtils.createTemporaryDestination(session);
            }
            catch (JMSException e) {
                BaseUtils.handleException((String)"Error creating temporary queue for response", (Exception)((Object)e));
            }
        }
        try {
            message.setJMSReplyTo(replyDestination);
        }
        catch (JMSException e) {
            log.warn((Object)("Error setting JMS ReplyTo destination to : " + replyDestination), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            try {
                assert (replyDestination != null);
                log.debug((Object)("Expecting a response to JMS Destination : " + (replyDestination instanceof Queue ? ((Queue)replyDestination).getQueueName() : ((Topic)replyDestination).getTopicName())));
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        return replyDestination;
    }

    public static void setTransportHeaders(Map<String, String> messageConfiguration, Message message) throws JMSException {
        if (messageConfiguration == null) {
            return;
        }
        for (String name : messageConfiguration.keySet()) {
            if (name.startsWith("JMSX") && !name.equals("JMSXGroupID") && !name.equals("JMSXGroupSeq")) continue;
            if ("JMS_COORELATION_ID".equals(name)) {
                message.setJMSCorrelationID(messageConfiguration.get("JMS_COORELATION_ID"));
                continue;
            }
            if ("JMS_DELIVERY_MODE".equals(name)) {
                String mode = messageConfiguration.get("JMS_DELIVERY_MODE");
                try {
                    message.setJMSDeliveryMode(Integer.parseInt(mode));
                }
                catch (NumberFormatException nfe) {
                    log.warn((Object)("Invalid delivery mode ignored : " + mode), (Throwable)nfe);
                }
                continue;
            }
            if ("JMS_EXPIRATION".equals(name)) {
                message.setJMSExpiration(Long.parseLong(messageConfiguration.get("JMS_EXPIRATION")));
                continue;
            }
            if ("JMS_MESSAGE_ID".equals(name)) {
                message.setJMSMessageID(messageConfiguration.get("JMS_MESSAGE_ID"));
                continue;
            }
            if ("JMS_PRIORITY".equals(name)) {
                message.setJMSPriority(Integer.parseInt(messageConfiguration.get("JMS_PRIORITY")));
                continue;
            }
            if ("JMS_TIMESTAMP".equals(name)) {
                message.setJMSTimestamp(Long.parseLong(messageConfiguration.get("JMS_TIMESTAMP")));
                continue;
            }
            if ("JMS_MESSAGE_TYPE".equals(name)) {
                message.setJMSType(messageConfiguration.get("JMS_MESSAGE_TYPE"));
                continue;
            }
            String value = messageConfiguration.get(name);
            if (value instanceof String) {
                message.setStringProperty(name, value);
                continue;
            }
            if (value instanceof Boolean) {
                message.setBooleanProperty(name, ((Boolean)((Object)value)).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                message.setIntProperty(name, ((Integer)((Object)value)).intValue());
                continue;
            }
            if (value instanceof Long) {
                message.setLongProperty(name, ((Long)((Object)value)).longValue());
                continue;
            }
            if (value instanceof Double) {
                message.setDoubleProperty(name, ((Double)((Object)value)).doubleValue());
                continue;
            }
            if (!(value instanceof Float)) continue;
            message.setFloatProperty(name, ((Float)((Object)value)).floatValue());
        }
    }

    public static Map<String, Object> getTransportHeaders(Message message) {
        Destination dest2;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (message.getJMSCorrelationID() != null) {
                map.put("JMS_COORELATION_ID", message.getJMSCorrelationID());
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            map.put("JMS_DELIVERY_MODE", Integer.toString(message.getJMSDeliveryMode()));
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        try {
            if (message.getJMSDestination() != null) {
                dest2 = message.getJMSDestination();
                map.put("JMS_DESTINATION", dest2 instanceof Queue ? ((Queue)dest2).getQueueName() : ((Topic)dest2).getTopicName());
            }
        }
        catch (JMSException dest2) {
            // empty catch block
        }
        try {
            map.put("JMS_EXPIRATION", Long.toString(message.getJMSExpiration()));
        }
        catch (JMSException dest2) {
            // empty catch block
        }
        try {
            if (message.getJMSMessageID() != null) {
                map.put("JMS_MESSAGE_ID", message.getJMSMessageID());
            }
        }
        catch (JMSException dest2) {
            // empty catch block
        }
        try {
            map.put("JMS_PRIORITY", Long.toString(message.getJMSPriority()));
        }
        catch (JMSException dest2) {
            // empty catch block
        }
        try {
            map.put("JMS_REDELIVERED", Boolean.toString(message.getJMSRedelivered()));
        }
        catch (JMSException dest2) {
            // empty catch block
        }
        try {
            if (message.getJMSReplyTo() != null) {
                dest2 = message.getJMSReplyTo();
                map.put("JMS_REPLY_TO", dest2 instanceof Queue ? ((Queue)dest2).getQueueName() : ((Topic)dest2).getTopicName());
            }
        }
        catch (JMSException dest3) {
            // empty catch block
        }
        try {
            map.put("JMS_TIMESTAMP", Long.toString(message.getJMSTimestamp()));
        }
        catch (JMSException dest3) {
            // empty catch block
        }
        try {
            if (message.getJMSType() != null) {
                map.put("JMS_TYPE", message.getJMSType());
            }
        }
        catch (JMSException dest3) {
            // empty catch block
        }
        Enumeration e = null;
        try {
            e = message.getPropertyNames();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                try {
                    map.put(headerName, message.getStringProperty(headerName));
                }
                catch (JMSException jMSException) {
                    try {
                        map.put(headerName, message.getBooleanProperty(headerName));
                    }
                    catch (JMSException jMSException2) {
                        try {
                            map.put(headerName, message.getIntProperty(headerName));
                        }
                        catch (JMSException jMSException3) {
                            try {
                                map.put(headerName, message.getLongProperty(headerName));
                            }
                            catch (JMSException jMSException4) {
                                try {
                                    map.put(headerName, message.getDoubleProperty(headerName));
                                }
                                catch (JMSException jMSException5) {
                                    try {
                                        map.put(headerName, Float.valueOf(message.getFloatProperty(headerName)));
                                    }
                                    catch (JMSException jMSException6) {}
                                }
                            }
                        }
                    }
                }
            }
        }
        return map;
    }

    public static MessageConsumer createConsumer(Session session, Destination dest, String messageSelector) throws JMSException {
        if (dest instanceof Queue) {
            return ((QueueSession)session).createReceiver((Queue)dest, messageSelector);
        }
        return ((TopicSession)session).createSubscriber((Topic)dest, messageSelector, false);
    }

    public static Destination createTemporaryDestination(Session session) throws JMSException {
        if (session instanceof QueueSession) {
            return session.createTemporaryQueue();
        }
        return session.createTemporaryTopic();
    }

    public static <T> T lookup(Context context, Class<T> clazz, String name) throws NamingException {
        Object object = context.lookup(name);
        try {
            return clazz.cast(object);
        }
        catch (ClassCastException ex) {
            if (object instanceof Reference) {
                Reference ref = (Reference)object;
                BaseUtils.handleException((String)("JNDI failed to de-reference Reference with name " + name + "; is the factory " + ref.getFactoryClassName() + " in your classpath?"));
                return null;
            }
            BaseUtils.handleException((String)("JNDI lookup of name " + name + " returned a " + object.getClass().getName() + " while a " + clazz + " was expected"));
            return null;
        }
    }

    public static Connection createConnection(ConnectionFactory conFac, String user, String pass, boolean jmsSpec11, Boolean isQueue, boolean isDurable, String clientID) throws JMSException {
        Connection connection = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating a " + (isQueue != false ? "Queue" : "Topic") + "Connection using credentials : (" + user + "/" + pass + ")"));
        }
        if (jmsSpec11 || isQueue == null) {
            connection = user != null && pass != null ? conFac.createConnection(user, pass) : conFac.createConnection();
            if (isDurable) {
                connection.setClientID(clientID);
            }
        } else {
            QueueConnectionFactory qConFac = null;
            TopicConnectionFactory tConFac = null;
            if (isQueue.booleanValue()) {
                qConFac = (QueueConnectionFactory)conFac;
            } else {
                tConFac = (TopicConnectionFactory)conFac;
            }
            if (user != null && pass != null) {
                if (qConFac != null) {
                    connection = qConFac.createQueueConnection(user, pass);
                } else if (tConFac != null) {
                    connection = tConFac.createTopicConnection(user, pass);
                }
            } else if (qConFac != null) {
                connection = qConFac.createQueueConnection();
            } else if (tConFac != null) {
                connection = tConFac.createTopicConnection();
            }
            if (isDurable) {
                connection.setClientID(clientID);
            }
        }
        return connection;
    }

    public static Session createSession(Connection connection, boolean transacted, int ackMode, boolean jmsSpec11, Boolean isQueue) throws JMSException {
        if (jmsSpec11 || isQueue == null) {
            return connection.createSession(transacted, ackMode);
        }
        if (isQueue.booleanValue()) {
            return ((QueueConnection)connection).createQueueSession(transacted, ackMode);
        }
        return ((TopicConnection)connection).createTopicSession(transacted, ackMode);
    }

    public static MessageConsumer createConsumer(Session session, Destination destination, Boolean isQueue, String subscriberName, String messageSelector, boolean pubSubNoLocal, boolean isDurable, boolean jmsSpec11) throws JMSException {
        if (jmsSpec11 || isQueue == null) {
            if (isDurable) {
                return session.createDurableSubscriber((Topic)destination, subscriberName, messageSelector, pubSubNoLocal);
            }
            return session.createConsumer(destination, messageSelector, pubSubNoLocal);
        }
        if (isQueue.booleanValue()) {
            return ((QueueSession)session).createReceiver((Queue)destination, messageSelector);
        }
        if (isDurable) {
            return ((TopicSession)session).createDurableSubscriber((Topic)destination, subscriberName, messageSelector, pubSubNoLocal);
        }
        return ((TopicSession)session).createSubscriber((Topic)destination, messageSelector, pubSubNoLocal);
    }

    public static MessageProducer createProducer(Session session, Destination destination, Boolean isQueue, boolean jmsSpec11) throws JMSException {
        if (jmsSpec11 || isQueue == null) {
            return session.createProducer(destination);
        }
        if (isQueue.booleanValue()) {
            return ((QueueSession)session).createSender((Queue)destination);
        }
        return ((TopicSession)session).createPublisher((Topic)destination);
    }

    public static String getDestinationTypeAsString(int destType) {
        if (destType == 1) {
            return "queue";
        }
        if (destType == 2) {
            return "topic";
        }
        return "generic";
    }

    public static Destination lookupDestination(Context context, String destinationName, String destinationType) throws NamingException {
        if (destinationName == null) {
            return null;
        }
        try {
            return JMSUtils.lookup(context, Destination.class, destinationName);
        }
        catch (NameNotFoundException e) {
            try {
                return JMSUtils.lookup(context, Destination.class, ("topic".equalsIgnoreCase(destinationType) ? "dynamicTopics/" : "dynamicQueues/") + destinationName);
            }
            catch (NamingException x) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot locate destination : " + destinationName));
                }
                throw x;
            }
        }
        catch (NamingException e) {
            log.warn((Object)("Cannot locate destination : " + destinationName), (Throwable)e);
            throw e;
        }
    }

    public static Hashtable<String, String> maskAxis2ConfigSensitiveParameters(Hashtable<String, String> sensitiveParamsTable) {
        Hashtable<String, String> maskedParamsTable = new Hashtable<String, String>(sensitiveParamsTable);
        if (maskedParamsTable.get("transport.jms.Password") != null) {
            maskedParamsTable.put("transport.jms.Password", MASKING_STRING);
        }
        if (sensitiveParamsTable.get("java.naming.security.credentials") != null) {
            maskedParamsTable.put("java.naming.security.credentials", MASKING_STRING);
        }
        if (sensitiveParamsTable.get("connectionfactory.QueueConnectionFactory") != null) {
            maskedParamsTable.put("connectionfactory.QueueConnectionFactory", JMSUtils.getMaskedConnectionString(sensitiveParamsTable.get("connectionfactory.QueueConnectionFactory"), MASKING_STRING));
        }
        if (sensitiveParamsTable.get("connectionfactory.TopicConnectionFactory") != null) {
            maskedParamsTable.put("connectionfactory.TopicConnectionFactory", JMSUtils.getMaskedConnectionString(sensitiveParamsTable.get("connectionfactory.TopicConnectionFactory"), MASKING_STRING));
        }
        return maskedParamsTable;
    }

    private static String getMaskedConnectionString(String connectionString, String maskString) {
        try {
            URI url = new URI(connectionString);
            String userInfo = url.getUserInfo();
            if (userInfo == null && (userInfo = url.getAuthority()) != null) {
                int atIndex = userInfo.indexOf(64);
                userInfo = atIndex != -1 ? userInfo.substring(0, atIndex) : null;
            }
            if (userInfo == null) {
                return connectionString;
            }
            int colonIndex = userInfo.indexOf(58);
            if (colonIndex == -1) {
                return connectionString.replace(userInfo, maskString);
            }
            return connectionString.replace(userInfo, maskString + ":" + maskString);
        }
        catch (URISyntaxException ignore) {
            log.error((Object)"Error while parsing the JMS connection url");
            String maskedConnectionString = "Invalid connection url";
            return maskedConnectionString;
        }
    }
}

