/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.jms.factory;

import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.jms.JmsRunTimeException;
import org.wso2.carbon.apimgt.common.jms.utils.JMSUtils;

public class JMSConnectionFactory {
    private static final Log log = LogFactory.getLog(JMSConnectionFactory.class);
    private Hashtable<String, String> parameters = new Hashtable();
    private String name;
    private Context context = null;
    private ConnectionFactory conFactory = null;
    private Connection sharedConnection = null;
    private Session sharedSession = null;
    private MessageProducer sharedProducer = null;
    private Destination sharedDestination = null;
    private int cacheLevel = 1;

    public JMSConnectionFactory(Hashtable<String, String> parameters, String name) {
        this.parameters = parameters;
        this.name = name;
        this.digestCacheLevel();
        try {
            this.context = new InitialContext(parameters);
            this.conFactory = JMSUtils.lookup(this.context, ConnectionFactory.class, parameters.get("transport.jms.ConnectionFactoryJNDIName"));
            log.info((Object)("JMS ConnectionFactory : " + name + " initialized"));
        }
        catch (NamingException e) {
            throw new JmsRunTimeException("Cannot acquire JNDI context, JMS Connection factory : " + parameters.get("transport.jms.ConnectionFactoryJNDIName") + " or default destination : " + parameters.get("transport.jms.Destination") + " for JMS CF : " + name + " using : " + parameters, e);
        }
    }

    private void digestCacheLevel() {
        String key = "transport.jms.CacheLevel";
        String val = this.parameters.get(key);
        if ("none".equalsIgnoreCase(val)) {
            this.cacheLevel = 0;
        } else if ("connection".equalsIgnoreCase(val)) {
            this.cacheLevel = 1;
        } else if ("session".equals(val)) {
            this.cacheLevel = 2;
        } else if ("producer".equals(val)) {
            this.cacheLevel = 4;
        } else if (val != null) {
            throw new JmsRunTimeException("Invalid cache level : " + val + " for JMS CF : " + this.name);
        }
    }

    public synchronized void stop() {
        if (this.sharedConnection != null) {
            try {
                this.sharedConnection.close();
            }
            catch (JMSException e) {
                log.warn((Object)("Error shutting down connection factory : " + this.name), (Throwable)e);
            }
        }
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException e) {
                log.warn((Object)("Error while closing the InitialContext of factory : " + this.name), (Throwable)e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Hashtable<String, String> getParameters() {
        return this.parameters;
    }

    public Context getContext() {
        return this.context;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public Destination getSharedDestination() {
        return this.sharedDestination;
    }

    public Destination getDestination(String destinationName) {
        try {
            return JMSUtils.lookupDestination(this.context, destinationName, this.parameters.get("transport.jms.DestinationType"));
        }
        catch (NamingException e) {
            this.handleException("Error looking up the JMS destination with name " + destinationName + " of type " + this.parameters.get("transport.jms.DestinationType"), e);
            return null;
        }
    }

    public String getReplyToDestination() {
        return this.parameters.get("transport.jms.ReplyDestination");
    }

    public String getReplyDestinationType() {
        return this.parameters.get("transport.jms.ReplyDestinationType") != null ? this.parameters.get("transport.jms.ReplyDestinationType") : "generic";
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new JmsRunTimeException(msg, e);
    }

    public boolean isJmsSpec11() {
        return this.parameters.get("transport.jms.JMSSpecVersion") == null || "1.1".equals(this.parameters.get("transport.jms.JMSSpecVersion"));
    }

    public Boolean isQueue() {
        if (this.parameters.get("transport.jms.ConnectionFactoryType") == null && this.parameters.get("transport.jms.DestinationType") == null) {
            return null;
        }
        if (this.parameters.get("transport.jms.ConnectionFactoryType") != null) {
            if ("queue".equalsIgnoreCase(this.parameters.get("transport.jms.ConnectionFactoryType"))) {
                return true;
            }
            if ("topic".equalsIgnoreCase(this.parameters.get("transport.jms.ConnectionFactoryType"))) {
                return false;
            }
            throw new JmsRunTimeException("Invalid transport.jms.ConnectionFactoryType : " + this.parameters.get("transport.jms.ConnectionFactoryType") + " for JMS CF : " + this.name);
        }
        if ("queue".equalsIgnoreCase(this.parameters.get("transport.jms.DestinationType"))) {
            return true;
        }
        if ("topic".equalsIgnoreCase(this.parameters.get("transport.jms.DestinationType"))) {
            return false;
        }
        throw new JmsRunTimeException("Invalid transport.jms.DestinationType : " + this.parameters.get("transport.jms.DestinationType") + " for JMS CF : " + this.name);
    }

    private boolean isSessionTransacted() {
        return this.parameters.get("transport.jms.SessionTransacted") != null && Boolean.valueOf(this.parameters.get("transport.jms.SessionTransacted")) != false;
    }

    private boolean isDurable() {
        if (this.parameters.get("transport.jms.SubscriptionDurable") != null) {
            return Boolean.valueOf(this.parameters.get("transport.jms.SubscriptionDurable"));
        }
        return false;
    }

    private String getClientId() {
        return this.parameters.get("transport.jms.DurableSubscriberClientID");
    }

    private Connection createConnection() {
        Connection connection = null;
        try {
            connection = JMSUtils.createConnection(this.conFactory, this.parameters.get("transport.jms.UserName"), this.parameters.get("transport.jms.Password"), this.isJmsSpec11(), this.isQueue(), this.isDurable(), this.getClientId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("New JMS Connection from JMS CF : " + this.name + " created"));
            }
        }
        catch (JMSException e) {
            this.handleException("Error acquiring a Connection from the JMS CF : " + this.name + " using properties : " + this.parameters, (Exception)((Object)e));
        }
        return connection;
    }

    private Session createSession(Connection connection) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating a new JMS Session from JMS CF : " + this.name));
            }
            return JMSUtils.createSession(connection, this.isSessionTransacted(), 1, this.isJmsSpec11(), this.isQueue());
        }
        catch (JMSException e) {
            this.handleException("Error creating JMS session from JMS CF : " + this.name, (Exception)((Object)e));
            return null;
        }
    }

    private MessageProducer createProducer(Session session, Destination destination) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating a new JMS MessageProducer from JMS CF : " + this.name));
            }
            return JMSUtils.createProducer(session, destination, this.isQueue(), this.isJmsSpec11());
        }
        catch (JMSException e) {
            this.handleException("Error creating JMS producer from JMS CF : " + this.name, (Exception)((Object)e));
            return null;
        }
    }

    public Connection getConnection() {
        if (this.cacheLevel > 0) {
            return this.getSharedConnection();
        }
        return this.createConnection();
    }

    public Session getSession(Connection connection) {
        if (this.cacheLevel > 1) {
            return this.getSharedSession();
        }
        return this.createSession(connection == null ? this.getConnection() : connection);
    }

    public MessageProducer getMessageProducer(Connection connection, Session session, Destination destination) {
        if (this.cacheLevel > 2) {
            return this.getSharedProducer();
        }
        return this.createProducer(session == null ? this.getSession(connection) : session, destination);
    }

    private synchronized Connection getSharedConnection() {
        if (this.sharedConnection == null) {
            this.sharedConnection = this.createConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created shared JMS Connection for JMS CF : " + this.name));
            }
        }
        return this.sharedConnection;
    }

    private synchronized Session getSharedSession() {
        if (this.sharedSession == null) {
            this.sharedSession = this.createSession(this.getSharedConnection());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created shared JMS Session for JMS CF : " + this.name));
            }
        }
        return this.sharedSession;
    }

    private synchronized MessageProducer getSharedProducer() {
        if (this.sharedProducer == null) {
            this.sharedProducer = this.createProducer(this.getSharedSession(), this.sharedDestination);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Created shared JMS MessageConsumer for JMS CF : " + this.name));
            }
        }
        return this.sharedProducer;
    }
}

