/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.jms;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.jms.MessageListener;
import org.apache.axis2.transport.base.threads.NativeWorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.jms.JMSListener;
import org.wso2.carbon.apimgt.common.jms.JMSTaskManager;
import org.wso2.carbon.apimgt.common.jms.factory.JMSConnectionFactory;
import org.wso2.carbon.apimgt.common.jms.factory.JMSTaskManagerFactory;

public class JMSTransportHandler {
    private static final Log log = LogFactory.getLog(JMSTransportHandler.class);
    private JMSConnectionFactory jmsConnectionFactory;
    private List<JMSListener> jmsListenerList = new ArrayList<JMSListener>();
    private int minThreadPoolSize = 20;
    private int maxThreadPoolSize = 100;
    private int keepAliveTimeInMillis = 1000;
    private int jobQueueSize = 10;
    private boolean stopIssued = false;
    private static final Object lock = new Object();

    public JMSTransportHandler(Properties jmsConnectionProperties) {
        Properties properties;
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        if (jmsConnectionProperties.isEmpty()) {
            properties = new Properties();
            ClassLoader classLoader = this.getClass().getClassLoader();
            try (InputStream resourceStream = classLoader.getResourceAsStream("mb.properties");){
                properties.load(resourceStream);
            }
            catch (IOException e) {
                log.error((Object)("Cannot read properties file from resources. " + e.getMessage()), (Throwable)e);
            }
        } else {
            properties = jmsConnectionProperties;
        }
        for (String name : properties.stringPropertyNames()) {
            parameters.put(name, properties.getProperty(name));
        }
        this.jmsConnectionFactory = new JMSConnectionFactory(parameters, "Siddhi-JMS-Consumer");
    }

    public void subscribeForJmsEvents(String topicName, MessageListener messageListener) {
        JMSListener jmsMessageListener = this.createJMSMessageListener(topicName, this.minThreadPoolSize, this.maxThreadPoolSize, this.keepAliveTimeInMillis, this.jobQueueSize, messageListener);
        jmsMessageListener.startListener();
        this.jmsListenerList.add(jmsMessageListener);
        log.info((Object)("Starting jms topic consumer thread for the " + topicName + " topic..."));
    }

    private JMSListener createJMSMessageListener(String topicName, int minThreadPoolSize, int maxThreadPoolSize, int keepAliveTimeInMillis, int jobQueueSize, MessageListener messageListener) {
        HashMap<String, String> messageConfig = new HashMap<String, String>();
        messageConfig.put("transport.jms.Destination", topicName);
        JMSTaskManager jmsTaskManager = JMSTaskManagerFactory.createTaskManagerForService(this.jmsConnectionFactory, "Siddhi-JMS-Consumer", (WorkerPool)new NativeWorkerPool(minThreadPoolSize, maxThreadPoolSize, keepAliveTimeInMillis, jobQueueSize, "JMS Threads", "JMSThreads" + UUID.randomUUID().toString()), messageConfig);
        jmsTaskManager.setMessageListener(messageListener);
        JMSListener jmsListener = new JMSListener("Siddhi-JMS-Consumer#" + topicName, jmsTaskManager);
        return jmsListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribeFromEvents() {
        log.info((Object)"Starting to Shutdown the Listener...");
        if (!this.stopIssued && this.jmsConnectionFactory != null) {
            Object object = lock;
            synchronized (object) {
                if (!this.stopIssued) {
                    this.stopIssued = true;
                    log.debug((Object)"Stopping JMS Listeners");
                    for (JMSListener jmsListener : this.jmsListenerList) {
                        jmsListener.stopListener();
                    }
                    log.debug((Object)"JMS Listeners Stopped");
                    this.jmsConnectionFactory.stop();
                    log.debug((Object)"JMS Connection Factory Stopped");
                }
            }
        }
    }
}

