/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.jms;

import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.jms.JMSTaskManager;
import org.wso2.carbon.apimgt.common.jms.utils.JMSUtils;

public class JMSListener
implements Runnable {
    private static final Log log = LogFactory.getLog(JMSListener.class);
    private final String listenerName;
    private final JMSTaskManager jmsTaskManager;

    public JMSListener(String listenerName, JMSTaskManager jmsTaskManager) {
        this.listenerName = listenerName;
        this.jmsTaskManager = jmsTaskManager;
    }

    private void start() {
        JMSTaskManager stm = this.jmsTaskManager;
        boolean connected = false;
        int r = 1;
        long retryDuration = 10000L;
        double reconnectionProgressionFactor = 2.0;
        long maxReconnectDuration = 3600000L;
        while (!connected) {
            boolean jmsProviderStarted = this.checkJMSConnection(stm);
            if (jmsProviderStarted) {
                log.info((Object)("Connection attempt: " + r + " for JMS Provider for listener: " + this.listenerName + " was successful!"));
                connected = true;
                stm.start();
                for (int i = 0; i < 3; ++i) {
                    if (stm.getConsumerCount() > 0) {
                        log.info((Object)("Started to listen on destination : " + stm.getDestinationJNDIName() + " of type " + JMSUtils.getDestinationTypeAsString(stm.getDestinationType()) + " for listener " + this.listenerName));
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                log.warn((Object)("Polling tasks on destination : " + stm.getDestinationJNDIName() + " of type " + JMSUtils.getDestinationTypeAsString(stm.getDestinationType()) + " for listener " + this.listenerName + " have not yet started after 3 seconds .."));
                continue;
            }
            log.error((Object)"JMS Provider is not yet started. Please start the JMS provider now.");
            retryDuration = (long)((double)retryDuration * reconnectionProgressionFactor);
            log.error((Object)("Connection attempt : " + r++ + " for JMS Provider failed. Next retry in " + retryDuration / 1000L + " seconds"));
            if (retryDuration > maxReconnectDuration) {
                retryDuration = maxReconnectDuration;
            }
            try {
                Thread.sleep(retryDuration);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkJMSConnection(JMSTaskManager stm) {
        Connection connection = null;
        Hashtable<String, String> jmsProperties = stm.getJmsProperties();
        try {
            ConnectionFactory jmsConFactory = null;
            try {
                jmsConFactory = JMSUtils.lookup(new InitialContext(stm.getJmsProperties()), ConnectionFactory.class, stm.getConnFactoryJNDIName());
            }
            catch (NamingException e) {
                log.error((Object)("Error looking up connection factory : " + stm.getConnFactoryJNDIName() + "using JNDI properties : " + jmsProperties), (Throwable)e);
            }
            connection = JMSUtils.createConnection(jmsConFactory, jmsProperties.get("transport.jms.UserName"), jmsProperties.get("transport.jms.Password"), stm.isJmsSpec11(), stm.isQueue(), stm.isSubscriptionDurable(), stm.getDurableSubscriberClientId());
        }
        catch (JMSException e) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    log.warn((Object)"Error while closing test connection.", (Throwable)e);
                }
            }
        }
        return connection != null;
    }

    public void stopListener() {
        JMSTaskManager stm = this.jmsTaskManager;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping listening on destination : " + stm.getDestinationJNDIName() + " for listener : " + this.listenerName));
        }
        stm.stop();
        log.info((Object)("Stopped listening for JMS messages to listener : " + this.listenerName));
    }

    @Override
    public void run() {
        this.start();
    }

    public void startListener() {
        new Thread(this).start();
    }
}

