/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.templates.services;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.SynapseXMLConfigurationFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.TemplateFactory;
import org.apache.synapse.config.xml.endpoints.TemplateSerializer;
import org.apache.synapse.endpoints.Template;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.mediation.templates.common.EndpointTemplateInfo;
import org.wso2.carbon.mediation.templates.common.factory.TemplateInfoFactory;
import org.wso2.carbon.mediation.templates.services.TemplateEditorAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class EndpointTemplateEditorAdmin
extends AbstractServiceBusAdmin {
    private static final Log log = LogFactory.getLog(TemplateEditorAdmin.class);
    public static final String WSO2_ENDPOINT_TEMPLATE_MEDIA_TYPE = "application/vnd.wso2.template.endpoint";

    public int getEndpointTemplatesCount() throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            int n = this.getSynapseConfiguration().getEndpointTemplates().values().size();
            return n;
        }
        catch (Exception e) {
            this.handleException("Couldn't get the Synapse Configuration to get Sequence count", e);
        }
        finally {
            lock.unlock();
        }
        return 0;
    }

    public int getDynamicEndpointTemplatesCount() throws AxisFault {
        try {
            String[] govList = this.getGovernanceRegistry() != null ? this.getMimeTypeResult(this.getGovernanceRegistry()) : new String[]{};
            String[] confList = this.getConfigSystemRegistry() != null ? this.getMimeTypeResult(this.getConfigSystemRegistry()) : new String[]{};
            return confList.length + govList.length;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String[] getMimeTypeResult(Registry targetRegistry) throws Exception {
        String sql = "SELECT REG_PATH_ID, REG_NAME FROM REG_RESOURCE WHERE REG_MEDIA_TYPE = ?";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("query", sql);
        parameters.put("1", WSO2_ENDPOINT_TEMPLATE_MEDIA_TYPE);
        org.wso2.carbon.registry.core.Collection result = targetRegistry.executeQuery(null, parameters);
        return (String[])result.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointTemplateInfo[] getEndpointTemplates(int pageNumber, int endpointTemplatesPerPage) throws AxisFault {
        Lock lock = this.getLock();
        Collection templates = null;
        try {
            lock.lock();
            templates = this.getSynapseConfiguration().getEndpointTemplates().values();
            EndpointTemplateInfo[] info = TemplateInfoFactory.getSortedTemplateInfoArrayByTemplate(templates);
            if (info != null && info.length > 0) {
                for (EndpointTemplateInfo tempplateInfo : info) {
                    Template template = (Template)this.getSynapseConfiguration().getEndpointTemplates().get(tempplateInfo.getTemplateName());
                    if (template.getArtifactContainerName() != null) {
                        tempplateInfo.setArtifactContainerName(template.getArtifactContainerName());
                    }
                    if (!template.isEdited()) continue;
                    tempplateInfo.setIsEdited(true);
                }
            }
            EndpointTemplateInfo[] ret = info.length >= endpointTemplatesPerPage * pageNumber + endpointTemplatesPerPage ? new EndpointTemplateInfo[endpointTemplatesPerPage] : new EndpointTemplateInfo[info.length - endpointTemplatesPerPage * pageNumber];
            for (int i = 0; i < endpointTemplatesPerPage; ++i) {
                if (ret.length <= i) continue;
                ret[i] = info[endpointTemplatesPerPage * pageNumber + i];
            }
            EndpointTemplateInfo[] endpointTemplateInfoArray = ret;
            return endpointTemplateInfoArray;
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the available templates", fault);
        }
        finally {
            lock.unlock();
        }
        return new EndpointTemplateInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointTemplateInfo[] getDynamicEndpointTemplates(int pageNumber, int endpointTemplatesPerPage) throws AxisFault {
        EndpointTemplateInfo[] ret;
        Lock lock = this.getLock();
        try {
            lock.lock();
            String[] configInfo = this.getConfigSystemRegistry() != null ? this.getMimeTypeResult(this.getConfigSystemRegistry()) : new String[]{};
            String[] govInfo = this.getGovernanceRegistry() != null ? this.getMimeTypeResult(this.getGovernanceRegistry()) : new String[]{};
            Object[] info = new String[configInfo.length + govInfo.length];
            int ptr = 0;
            for (String aConfigInfo : configInfo) {
                info[ptr] = "conf:" + aConfigInfo;
                ++ptr;
            }
            for (String aGovInfo : govInfo) {
                info[ptr] = "gov:" + aGovInfo;
                ++ptr;
            }
            Arrays.sort(info);
            ret = info.length >= endpointTemplatesPerPage * pageNumber + endpointTemplatesPerPage ? new EndpointTemplateInfo[endpointTemplatesPerPage] : new EndpointTemplateInfo[info.length - endpointTemplatesPerPage * pageNumber];
            for (int i = 0; i < endpointTemplatesPerPage; ++i) {
                if (ret.length <= i) continue;
                EndpointTemplateInfo seq = new EndpointTemplateInfo();
                seq.setTemplateName((String)info[endpointTemplatesPerPage * pageNumber + i]);
                ret[i] = seq;
            }
        }
        catch (Exception e) {
            this.handleException("Unable to get Dynamic Template Info", e);
            EndpointTemplateInfo[] endpointTemplateInfoArray = null;
            return endpointTemplateInfoArray;
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMElement getTemplate(String templateName) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            Template template = synapseConfiguration.getEndpointTemplate(templateName);
            if (template != null) {
                OMElement parentElement = null;
                OMElement oMElement = new TemplateSerializer().serializeEndpointTemplate(template, parentElement);
                return oMElement;
            }
            this.handleException("Template with the name " + templateName + " does not exist");
        }
        catch (SynapseException syne) {
            this.handleException("Unable to get the endpoint template : " + templateName, syne);
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to get the Endpoint Template", fault);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEndpointTemplate(String templateName) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synCfg = this.getSynapseConfiguration();
            Template sequence = (Template)synCfg.getEndpointTemplates().get(templateName);
            if (sequence != null) {
                synCfg.removeEndpointTemplate(templateName);
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    MediationPersistenceManager pm = this.getMediationPersistenceManager();
                    pm.deleteItem(templateName, sequence.getFileName(), 12);
                }
            } else {
                this.handleException("No defined endpoint template with name " + templateName + " found to delete in the Synapse configuration");
            }
        }
        catch (Exception fault) {
            this.handleException("Couldn't get the Synapse Configuration to delete the sequence", fault);
        }
        finally {
            lock.unlock();
        }
    }

    public void deleteDynamicEndpointTemplate(String key) throws AxisFault {
        SynapseConfiguration synConfig = this.getSynapseConfiguration();
        org.apache.synapse.registry.Registry registry = synConfig.getRegistry();
        if (registry != null) {
            if (registry.getRegistryEntry(key).getType() == null) {
                this.handleException("The key '" + key + "' cannot be found within the configuration");
            } else {
                registry.delete(key);
            }
        } else {
            this.handleException("Unable to access the registry instance for the ESB");
        }
    }

    public void saveEndpointTemplate(String templateConfig) throws AxisFault {
        try {
            this.saveEndpointTemplate(AXIOMUtil.stringToOM((String)templateConfig));
        }
        catch (XMLStreamException e) {
            this.handleException("unable to save Endpoint template ...invalid configuration element", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEndpointTemplate(OMElement templateElement) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            if (templateElement != null && templateElement.getLocalName().equals(XMLConfigConstants.TEMPLATE_ELT.getLocalPart())) {
                String templateName = templateElement.getAttributeValue(new QName("name"));
                SynapseConfiguration config = this.getSynapseConfiguration();
                log.debug((Object)("Saving template : " + templateName));
                Template preSeq = (Template)config.getEndpointTemplates().get(templateName);
                if (preSeq == null) {
                    this.handleException("Unable to save template " + templateName + ". Does not exist");
                } else {
                    Template endpointTemplate = new TemplateFactory().createEndpointTemplate(templateElement, this.getSynapseConfiguration().getProperties());
                    config.removeEndpointTemplate(templateName);
                    if (endpointTemplate instanceof Template) {
                        endpointTemplate.setFileName(preSeq.getFileName());
                        config.addEndpointTemplate(templateName, endpointTemplate);
                    }
                    log.debug((Object)("Saved template : " + templateName + " to the configuration"));
                    Template templ = (Template)config.getEndpointTemplates().get(templateName);
                    if (templ != null) {
                        if (preSeq.getArtifactContainerName() != null) {
                            templ.setArtifactContainerName(preSeq.getArtifactContainerName());
                            templ.setIsEdited(true);
                        } else {
                            this.persistTemplate(templ);
                        }
                    }
                }
            } else {
                this.handleException("Unable to save template. Invalid definition");
            }
        }
        catch (Exception fault) {
            this.handleException("Unable to save the Template : " + fault.getMessage(), fault);
        }
        finally {
            lock.unlock();
        }
    }

    public void saveDynamicEndpointTemplate(String key, String sequenceConfig) throws AxisFault {
        try {
            this.saveDynamicEndpointTemplate(key, AXIOMUtil.stringToOM((String)sequenceConfig));
        }
        catch (XMLStreamException e) {
            this.handleException("unable to save dynamic template Endpoint...invalid configuration element", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDynamicEndpointTemplate(String key, OMElement endpointTempalteEl) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration synConfig = this.getSynapseConfiguration();
            org.apache.synapse.registry.Registry registry = synConfig.getRegistry();
            if (registry != null) {
                if (registry.getRegistryEntry(key).getType() == null) {
                    this.handleException("Unable to save the template. No resource is available by the key '" + key + "'");
                }
                registry.updateResource(key, (Object)endpointTempalteEl);
            } else {
                this.handleException("Unable to access the registry instance for the ESB");
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void addEndpointTemplate(String templateElementConfig) throws AxisFault {
        try {
            this.addEndpointTemplate(AXIOMUtil.stringToOM((String)templateElementConfig));
        }
        catch (XMLStreamException e) {
            this.handleException("unable to save template Endpoint...invalid configuration element", e);
        }
    }

    private void addEndpointTemplate(OMElement templateElement) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            if (templateElement.getLocalName().equals(XMLConfigConstants.TEMPLATE_ELT.getLocalPart())) {
                String templateName = templateElement.getAttributeValue(new QName("name"));
                SynapseConfiguration config = this.getSynapseConfiguration();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding template : " + templateName + " to the configuration"));
                }
                if (config.getLocalRegistry().get(templateName) != null) {
                    this.handleException("The name '" + templateName + "' is already used within the configuration");
                } else {
                    SynapseXMLConfigurationFactory.defineEndpointTemplate((SynapseConfiguration)config, (OMElement)templateElement, (Properties)this.getSynapseConfiguration().getProperties());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Added template : " + templateName + " to the configuration"));
                    }
                    Template templ = (Template)config.getEndpointTemplates().get(templateName);
                    templ.setFileName(ServiceBusUtils.generateFileName((String)templateName));
                    this.persistTemplate(templ);
                }
            } else {
                this.handleException("Invalid template definition");
            }
        }
        catch (Exception fault) {
            this.handleException("Error adding template : " + fault.getMessage(), fault);
        }
        catch (Error error) {
            throw new AxisFault("Unexpected error occured while adding the template : " + error.getMessage(), (Throwable)error);
        }
        finally {
            lock.unlock();
        }
    }

    public void addDynamicEndpointTemplate(String key, String sequenceConfig) throws AxisFault {
        try {
            this.addDynamicEndpointTemplate(key, AXIOMUtil.stringToOM((String)sequenceConfig));
        }
        catch (XMLStreamException e) {
            this.handleException("unable to save template Endpoint...invalid configuration element", e);
        }
    }

    private void addDynamicEndpointTemplate(String key, OMElement endpointTemplateEl) throws AxisFault {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.reset();
        try {
            XMLPrettyPrinter.prettify((OMElement)endpointTemplateEl, (OutputStream)stream);
        }
        catch (Exception e) {
            this.handleException("Unable to pretty print configuration", e);
        }
        try {
            Registry registry;
            if (key.startsWith("conf:")) {
                registry = this.getConfigSystemRegistry();
                key = key.replace("conf:", "");
            } else {
                registry = this.getGovernanceRegistry();
                key = key.replace("gov:", "");
            }
            if (registry.resourceExists(key)) {
                this.handleException("Resource is already exists");
            }
            Resource resource = registry.newResource();
            resource.setMediaType(WSO2_ENDPOINT_TEMPLATE_MEDIA_TYPE);
            resource.setContent((Object)new String(stream.toByteArray()).trim());
            registry.put(key, resource);
        }
        catch (RegistryException e) {
            this.handleException("WSO2 Registry Exception", e);
        }
    }

    private void persistTemplate(Template template) throws AxisFault {
        if (template instanceof Template && !Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            MediationPersistenceManager pm = this.getMediationPersistenceManager();
            pm.saveItem(template.getName(), 12);
        }
    }

    private void handleException(String message, Throwable cause) throws AxisFault {
        log.error((Object)message, cause);
        throw new AxisFault(message, cause);
    }

    private void handleException(String message) throws AxisFault {
        log.error((Object)message);
        throw new AxisFault(message);
    }

    public boolean hasDuplicateTempleteEndpoint(String templateElementConfig) throws AxisFault {
        OMElement templateElement = null;
        try {
            templateElement = AXIOMUtil.stringToOM((String)templateElementConfig);
        }
        catch (XMLStreamException e) {
            this.handleException("unable to Checking template Endpoint...invalid configuration element", e);
        }
        if (templateElement != null) {
            Lock lock = this.getLock();
            try {
                lock.lock();
                if (templateElement.getLocalName().equals(XMLConfigConstants.TEMPLATE_ELT.getLocalPart())) {
                    String templateName = templateElement.getAttributeValue(new QName("name"));
                    SynapseConfiguration config = this.getSynapseConfiguration();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Checking template : " + templateName + " with existing configuration"));
                    }
                    if (config.getLocalRegistry().get(templateName) != null) {
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            catch (Exception fault) {
                this.handleException("Error Checking template : " + fault.getMessage(), fault);
            }
            catch (Error error) {
                throw new AxisFault("Unexpected error occured while Checking the template : " + error.getMessage(), (Throwable)error);
            }
            finally {
                lock.unlock();
            }
        }
        return false;
    }
}

