/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.templates;

import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.synapse.deployers.SequenceDeployer;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;

public class TemplateDeploymentInterceptor
extends SequenceDeployer {
    MediationPersistenceManager mpm;

    public void init(ConfigurationContext configCtx) {
        super.init(configCtx);
        this.mpm = ServiceBusUtils.getMediationPersistenceManager((AxisConfiguration)configCtx.getAxisConfiguration());
    }

    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        String seqName = super.deploySynapseArtifact(artifactConfig, fileName, properties);
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            this.mpm.saveItemToRegistry(seqName, 1);
        }
        return seqName;
    }

    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        String seqName = super.updateSynapseArtifact(artifactConfig, fileName, existingArtifactName, properties);
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            this.mpm.saveItemToRegistry(seqName, 1);
        }
        return seqName;
    }

    public void undeploySynapseArtifact(String artifactName) {
        super.undeploySynapseArtifact(artifactName);
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            this.mpm.deleteItemFromRegistry(artifactName, 1);
        }
    }

    public void restoreSynapseArtifact(String artifactName) {
        super.restoreSynapseArtifact(artifactName);
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
            this.mpm.saveItemToRegistry(artifactName, 1);
        }
    }
}

