/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.jms.internal.util;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterRuntimeException;
import org.wso2.carbon.event.input.adapter.jms.internal.util.JMSConnectionFactory;
import org.wso2.carbon.event.input.adapter.jms.internal.util.JMSTaskManager;

public class JMSTaskManagerFactory {
    private JMSTaskManagerFactory() {
    }

    public static JMSTaskManager createTaskManagerForService(JMSConnectionFactory jcf, String name, WorkerPool workerPool, Map<String, String> svc) {
        Double dValue;
        Hashtable<String, String> cf = jcf.getParameters();
        JMSTaskManager stm = new JMSTaskManager();
        stm.setEventAdapterName(name);
        stm.addJmsProperties(cf);
        stm.addJmsProperties(svc);
        stm.setConnFactoryJNDIName(JMSTaskManagerFactory.getRqdStringProperty("transport.jms.ConnectionFactoryJNDIName", svc, cf));
        String destName = JMSTaskManagerFactory.getOptionalStringProperty("transport.jms.Destination", svc, cf);
        if (destName == null) {
            destName = name;
        }
        stm.setDestinationJNDIName(destName);
        stm.setDestinationType(JMSTaskManagerFactory.getDestinationType(svc, cf));
        if (JMSTaskManagerFactory.getOptionalBooleanProperty("transport.jms.SubscriptionDurable", svc, cf) != null && JMSTaskManagerFactory.getOptionalBooleanProperty("transport.jms.SubscriptionDurable", svc, cf).booleanValue()) {
            stm.setDurableSubscriberClientId(JMSTaskManagerFactory.getRqdStringProperty("transport.jms.DurableSubscriberClientID", svc, cf));
        }
        stm.setJmsSpec11(JMSTaskManagerFactory.getJMSSpecVersion(svc, cf));
        stm.setTransactionality(JMSTaskManagerFactory.getTransactionality(svc, cf));
        stm.setCacheUserTransaction(JMSTaskManagerFactory.getOptionalBooleanProperty("transport.CacheUserTxn", svc, cf));
        stm.setUserTransactionJNDIName(JMSTaskManagerFactory.getOptionalStringProperty("transport.UserTxnJNDIName", svc, cf));
        stm.setSessionTransacted(JMSTaskManagerFactory.getOptionalBooleanProperty("transport.jms.SessionTransacted", svc, cf));
        stm.setSessionAckMode(JMSTaskManagerFactory.getSessionAck(svc, cf));
        stm.setMessageSelector(JMSTaskManagerFactory.getOptionalStringProperty("transport.jms.MessageSelector", svc, cf));
        stm.setSubscriptionDurable(JMSTaskManagerFactory.getOptionalBooleanProperty("transport.jms.SubscriptionDurable", svc, cf));
        stm.setDurableSubscriberName(JMSTaskManagerFactory.getOptionalStringProperty("transport.jms.DurableSubscriberName", svc, cf));
        stm.setCacheLevel(JMSTaskManagerFactory.getCacheLevel(svc, cf));
        stm.setPubSubNoLocal(JMSTaskManagerFactory.getOptionalBooleanProperty("transport.jms.PubSubNoLocal", svc, cf));
        Integer value = JMSTaskManagerFactory.getOptionalIntProperty("transport.jms.ReceiveTimeout", svc, cf);
        if (value != null) {
            stm.setReceiveTimeout(value);
        }
        if ((value = JMSTaskManagerFactory.getOptionalIntProperty("transport.jms.ConcurrentConsumers", svc, cf)) != null) {
            stm.setConcurrentConsumers(value);
        }
        if ((value = JMSTaskManagerFactory.getOptionalIntProperty("transport.jms.MaxConcurrentConsumers", svc, cf)) != null) {
            stm.setMaxConcurrentConsumers(value);
        }
        if ((value = JMSTaskManagerFactory.getOptionalIntProperty("transport.jms.IdleTaskLimit", svc, cf)) != null) {
            stm.setIdleTaskExecutionLimit(value);
        }
        if ((value = JMSTaskManagerFactory.getOptionalIntProperty("transport.jms.MaxMessagesPerTask", svc, cf)) != null) {
            stm.setMaxMessagesPerTask(value);
        }
        if ((value = JMSTaskManagerFactory.getOptionalIntProperty("transport.jms.InitialReconnectDuration", svc, cf)) != null) {
            stm.setInitialReconnectDuration(value);
        }
        if ((value = JMSTaskManagerFactory.getOptionalIntProperty("transport.jms.MaxReconnectDuration", svc, cf)) != null) {
            stm.setMaxReconnectDuration(value.intValue());
        }
        if ((dValue = JMSTaskManagerFactory.getOptionalDoubleProperty("transport.jms.ReconnectProgressFactor", svc, cf)) != null) {
            stm.setReconnectionProgressionFactor(dValue);
        }
        stm.setWorkerPool(workerPool);
        stm.removeJmsProperties("transport.jms.ConnectionFactoryJNDIName");
        stm.removeJmsProperties("transport.jms.Destination");
        stm.removeJmsProperties("transport.jms.JMSSpecVersion");
        stm.removeJmsProperties("transport.Transactionality");
        stm.removeJmsProperties("transport.CacheUserTxn");
        stm.removeJmsProperties("transport.UserTxnJNDIName");
        stm.removeJmsProperties("transport.jms.SessionTransacted");
        stm.removeJmsProperties("transport.jms.MessageSelector");
        stm.removeJmsProperties("transport.jms.SubscriptionDurable");
        stm.removeJmsProperties("transport.jms.DurableSubscriberName");
        stm.removeJmsProperties("transport.jms.CacheLevel");
        stm.removeJmsProperties("transport.jms.PubSubNoLocal");
        stm.removeJmsProperties("transport.jms.ReceiveTimeout");
        stm.removeJmsProperties("transport.jms.ConcurrentConsumers");
        stm.removeJmsProperties("transport.jms.MaxConcurrentConsumers");
        stm.removeJmsProperties("transport.jms.IdleTaskLimit");
        stm.removeJmsProperties("transport.jms.MaxMessagesPerTask");
        stm.removeJmsProperties("transport.jms.InitialReconnectDuration");
        stm.removeJmsProperties("transport.jms.MaxReconnectDuration");
        stm.removeJmsProperties("transport.jms.ReconnectProgressFactor");
        stm.removeJmsProperties("transport.jms.DurableSubscriberClientID");
        return stm;
    }

    private static Map<String, String> getServiceStringParameters(List<Parameter> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter p : list) {
            if (!(p.getValue() instanceof String)) continue;
            map.put(p.getName(), (String)p.getValue());
        }
        return map;
    }

    private static String getRqdStringProperty(String key, Map<String, String> svcMap, Map<String, String> cfMap) {
        String value = svcMap.get(key);
        if (value == null) {
            value = cfMap.get(key);
        }
        if (value == null) {
            throw new InputEventAdapterRuntimeException("Service/connection factory property : " + key);
        }
        return value;
    }

    private static String getOptionalStringProperty(String key, Map<String, String> svcMap, Map<String, String> cfMap) {
        String value = svcMap.get(key);
        if (value == null) {
            value = cfMap.get(key);
        }
        return value;
    }

    private static Boolean getOptionalBooleanProperty(String key, Map<String, String> svcMap, Map<String, String> cfMap) {
        String value = svcMap.get(key);
        if (value == null) {
            value = cfMap.get(key);
        }
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    private static Integer getOptionalIntProperty(String key, Map<String, String> svcMap, Map<String, String> cfMap) {
        String value = svcMap.get(key);
        if (value == null) {
            value = cfMap.get(key);
        }
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new InputEventAdapterRuntimeException("Invalid value : " + value + " for " + key);
            }
        }
        return null;
    }

    private static Double getOptionalDoubleProperty(String key, Map<String, String> svcMap, Map<String, String> cfMap) {
        String value = svcMap.get(key);
        if (value == null) {
            value = cfMap.get(key);
        }
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new InputEventAdapterRuntimeException("Invalid value : " + value + " for " + key);
            }
        }
        return null;
    }

    private static int getTransactionality(Map<String, String> svcMap, Map<String, String> cfMap) {
        String key = "transport.Transactionality";
        String val = svcMap.get(key);
        if (val == null) {
            val = cfMap.get(key);
        }
        if (val == null) {
            return 0;
        }
        if ("jta".equalsIgnoreCase(val)) {
            return 2;
        }
        if ("local".equalsIgnoreCase(val)) {
            return 1;
        }
        throw new InputEventAdapterRuntimeException("Invalid option : " + val + " for parameter : " + "jta");
    }

    private static int getDestinationType(Map<String, String> svcMap, Map<String, String> cfMap) {
        String key = "transport.jms.DestinationType";
        String val = svcMap.get(key);
        if (val == null) {
            val = cfMap.get(key);
        }
        if ("topic".equalsIgnoreCase(val)) {
            return 2;
        }
        return 1;
    }

    private static int getSessionAck(Map<String, String> svcMap, Map<String, String> cfMap) {
        String key = "transport.jms.SessionAcknowledgement";
        String val = svcMap.get(key);
        if (val == null) {
            val = cfMap.get(key);
        }
        if (val == null || "AUTO_ACKNOWLEDGE".equalsIgnoreCase(val)) {
            return 1;
        }
        if ("CLIENT_ACKNOWLEDGE".equalsIgnoreCase(val)) {
            return 2;
        }
        if ("DUPS_OK_ACKNOWLEDGE".equals(val)) {
            return 3;
        }
        if ("SESSION_TRANSACTED".equals(val)) {
            return 0;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException ignore) {
            throw new InputEventAdapterRuntimeException("Invalid session acknowledgement mode : " + val);
        }
    }

    private static int getCacheLevel(Map<String, String> svcMap, Map<String, String> cfMap) {
        String key = "transport.jms.CacheLevel";
        String val = svcMap.get(key);
        if (val == null) {
            val = cfMap.get(key);
        }
        if ("none".equalsIgnoreCase(val)) {
            return 0;
        }
        if ("connection".equalsIgnoreCase(val)) {
            return 1;
        }
        if ("session".equals(val)) {
            return 2;
        }
        if ("consumer".equals(val)) {
            return 3;
        }
        if (val != null) {
            throw new InputEventAdapterRuntimeException("Invalid cache level : " + val);
        }
        return 5;
    }

    private static boolean getJMSSpecVersion(Map<String, String> svcMap, Map<String, String> cfMap) {
        String key = "transport.jms.JMSSpecVersion";
        String val = svcMap.get(key);
        if (val == null) {
            val = cfMap.get(key);
        }
        return val == null || "1.1".equals(val);
    }
}

