/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.jms.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterRuntimeException;
import org.wso2.carbon.event.input.adapter.jms.internal.util.JMSMessageListener;
import org.wso2.carbon.event.input.adapter.jms.internal.util.JMSUtils;

public class JMSTaskManager {
    private static final Log log = LogFactory.getLog(JMSTaskManager.class);
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_PAUSED = 2;
    private static final int STATE_SHUTTING_DOWN = 3;
    private static final int STATE_FAILURE = 4;
    private String eventAdapterName;
    private String connFactoryJNDIName;
    private String destinationJNDIName;
    private String userTransactionJNDIName = "java:comp/UserTransaction";
    private int destinationType = 0;
    private String messageSelector = null;
    private int transactionality = 0;
    private boolean sessionTransacted = true;
    private int sessionAckMode = 1;
    private boolean subscriptionDurable = false;
    private String durableSubscriberName = null;
    private boolean pubSubNoLocal = false;
    private int concurrentConsumers = 1;
    private int maxConcurrentConsumers = 1;
    private int idleTaskExecutionLimit = 10;
    private int maxMessagesPerTask = -1;
    private int receiveTimeout = 1000;
    private int cacheLevel = 5;
    private boolean cacheUserTransaction = true;
    private UserTransaction sharedUserTransaction = null;
    private boolean jmsSpec11 = false;
    private int initialReconnectDuration = 10000;
    private double reconnectionProgressionFactor = 2.0;
    private long maxReconnectDuration = 3600000L;
    private Hashtable<String, String> jmsProperties = new Hashtable();
    private Context context = null;
    private ConnectionFactory conFactory = null;
    private Destination destination = null;
    private final List<MessageListenerTask> pollingTasks = Collections.synchronizedList(new ArrayList());
    private JMSMessageListener jmsMessageListener = null;
    private volatile int JMSTaskManagerState = 0;
    private volatile int activeTaskCount = 0;
    private final AtomicInteger consumerCount = new AtomicInteger();
    private WorkerPool workerPool = null;
    private Connection sharedConnection = null;
    private String durableSubscriberClientId = null;
    private volatile boolean isOnExceptionError = false;

    public void setDurableSubscriberClientId(String durableSubscriberClientId) {
        this.durableSubscriberClientId = durableSubscriberClientId;
    }

    public synchronized void start() {
        if (this.JMSTaskManagerState == 2) {
            log.info((Object)"Attempt to re-start paused TaskManager is ignored. Please use resume instead");
            return;
        }
        if (!this.pollingTasks.isEmpty()) {
            this.stop();
        }
        if (this.cacheLevel == 5) {
            this.cacheLevel = this.transactionality == 0 ? 3 : 0;
        }
        switch (this.cacheLevel) {
            case 0: {
                log.debug((Object)("No JMS resources will be cached/shared between poller worker tasks of event adapter : " + this.eventAdapterName));
                break;
            }
            case 1: {
                log.debug((Object)"Only the JMS Connection will be cached and shared between *all* poller task invocations");
                break;
            }
            case 2: {
                log.debug((Object)"The JMS Connection and Session will be cached and shared between successive poller task invocations");
                break;
            }
            case 3: {
                log.debug((Object)"The JMS Connection, Session and MessageConsumer will be cached and shared between successive poller task invocations");
                break;
            }
            default: {
                this.handleException("Invalid cache level : " + this.cacheLevel + " for event adapter : " + this.eventAdapterName);
            }
        }
        for (int i = 0; i < this.concurrentConsumers; ++i) {
            this.workerPool.execute((Runnable)new MessageListenerTask());
        }
        this.JMSTaskManagerState = 1;
        log.info((Object)("Task manager for event adapter : " + this.eventAdapterName + " [re-]initialized"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping JMSTaskManager for event adapter : " + this.eventAdapterName));
        }
        if (this.JMSTaskManagerState != 4) {
            this.JMSTaskManagerState = 3;
        }
        List<MessageListenerTask> list = this.pollingTasks;
        synchronized (list) {
            for (MessageListenerTask lstTask : this.pollingTasks) {
                lstTask.requestShutdown();
            }
        }
        for (int i = 0; i < 5 && this.activeTaskCount != 0; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.sharedConnection != null) {
            try {
                this.sharedConnection.close();
            }
            catch (JMSException e) {
                this.logError("Error closing shared Connection", (Exception)((Object)e));
            }
            finally {
                this.sharedConnection = null;
            }
        }
        if (this.activeTaskCount > 0) {
            log.warn((Object)("Unable to shutdown all polling tasks of event adapter : " + this.eventAdapterName));
        }
        if (this.JMSTaskManagerState != 4) {
            this.JMSTaskManagerState = 0;
        }
        log.info((Object)("Task manager for event adapter : " + this.receiveTimeout + " shutdown"));
    }

    public synchronized void pause() {
        for (MessageListenerTask lstTask : this.pollingTasks) {
            lstTask.pause();
        }
        if (this.sharedConnection != null) {
            try {
                this.sharedConnection.stop();
            }
            catch (JMSException e) {
                this.logError("Error pausing shared Connection", (Exception)((Object)e));
            }
        }
    }

    public synchronized void resume() {
        for (MessageListenerTask lstTask : this.pollingTasks) {
            lstTask.resume();
        }
        if (this.sharedConnection != null) {
            try {
                this.sharedConnection.start();
            }
            catch (JMSException e) {
                this.logError("Error resuming shared Connection", (Exception)((Object)e));
            }
        }
    }

    private void scheduleNewTaskIfAppropriate() {
        if (this.JMSTaskManagerState == 1 && this.pollingTasks.size() < this.getMaxConcurrentConsumers() && this.getIdleTaskCount() == 0) {
            this.workerPool.execute((Runnable)new MessageListenerTask());
        }
    }

    private int getIdleTaskCount() {
        int count = 0;
        for (MessageListenerTask lstTask : this.pollingTasks) {
            if (!lstTask.isTaskIdle()) continue;
            ++count;
        }
        return count;
    }

    private int getConnectedTaskCount() {
        int count = 0;
        for (MessageListenerTask lstTask : this.pollingTasks) {
            if (!lstTask.isConnected()) continue;
            ++count;
        }
        return count;
    }

    private Context getInitialContext() throws NamingException {
        if (this.context == null) {
            this.context = new InitialContext(this.jmsProperties);
        }
        return this.context;
    }

    private Destination getDestination(Session session) {
        if (this.destination == null) {
            try {
                this.context = this.getInitialContext();
                this.destination = JMSUtils.lookupDestination(this.context, this.getDestinationJNDIName(), JMSUtils.getDestinationTypeAsString(this.destinationType));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JMS Destination with JNDI name : " + this.getDestinationJNDIName() + " found for event adapter " + this.eventAdapterName));
                }
            }
            catch (NamingException e) {
                try {
                    switch (this.destinationType) {
                        case 1: {
                            this.destination = session.createQueue(this.getDestinationJNDIName());
                            break;
                        }
                        case 2: {
                            this.destination = session.createTopic(this.getDestinationJNDIName());
                            break;
                        }
                        default: {
                            this.handleException("Error looking up JMS destination : " + this.getDestinationJNDIName() + " using JNDI properties : " + this.jmsProperties, e);
                            break;
                        }
                    }
                }
                catch (JMSException j) {
                    this.handleException("Error looking up JMS destination and auto creating JMS destination : " + this.getDestinationJNDIName() + " using JNDI properties : " + this.jmsProperties, e);
                }
            }
        }
        return this.destination;
    }

    private UserTransaction getUserTransaction() {
        if (!this.cacheUserTransaction) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Acquiring a new UserTransaction for event adapter : " + this.eventAdapterName));
            }
            try {
                this.context = this.getInitialContext();
                return JMSUtils.lookup(this.context, UserTransaction.class, this.getUserTransactionJNDIName());
            }
            catch (NamingException e) {
                this.handleException("Error looking up UserTransaction : " + this.getUserTransactionJNDIName() + " using JNDI properties : " + this.jmsProperties, e);
            }
        }
        if (this.sharedUserTransaction == null) {
            try {
                this.context = this.getInitialContext();
                this.sharedUserTransaction = JMSUtils.lookup(this.context, UserTransaction.class, this.getUserTransactionJNDIName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Acquired shared UserTransaction for event adator : " + this.eventAdapterName));
                }
            }
            catch (NamingException e) {
                this.handleException("Error looking up UserTransaction : " + this.getUserTransactionJNDIName() + " using JNDI properties : " + this.jmsProperties, e);
            }
        }
        return this.sharedUserTransaction;
    }

    private boolean isSTMActive() {
        return this.JMSTaskManagerState == 1;
    }

    public Boolean isQueue() {
        if (this.destinationType == 0) {
            return null;
        }
        return this.destinationType == 1;
    }

    private void logError(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new InputEventAdapterRuntimeException(msg, (Throwable)e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new InputEventAdapterRuntimeException(msg);
    }

    public String getEventAdapterName() {
        return this.eventAdapterName;
    }

    public void setEventAdapterName(String eventAdapterName) {
        this.eventAdapterName = eventAdapterName;
    }

    public String getConnFactoryJNDIName() {
        return this.connFactoryJNDIName;
    }

    public void setConnFactoryJNDIName(String connFactoryJNDIName) {
        this.connFactoryJNDIName = connFactoryJNDIName;
    }

    public String getDestinationJNDIName() {
        return this.destinationJNDIName;
    }

    public void setDestinationJNDIName(String destinationJNDIName) {
        this.destinationJNDIName = destinationJNDIName;
    }

    public int getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(int destinationType) {
        this.destinationType = destinationType;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public int getTransactionality() {
        return this.transactionality;
    }

    public void setTransactionality(int transactionality) {
        this.transactionality = transactionality;
        this.sessionTransacted = transactionality == 1;
    }

    public boolean isSessionTransacted() {
        return this.sessionTransacted;
    }

    public void setSessionTransacted(Boolean sessionTransacted) {
        if (sessionTransacted != null) {
            this.sessionTransacted = sessionTransacted;
        }
    }

    public int getSessionAckMode() {
        return this.sessionAckMode;
    }

    public void setSessionAckMode(int sessionAckMode) {
        this.sessionAckMode = sessionAckMode;
    }

    public boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setSubscriptionDurable(Boolean subscriptionDurable) {
        if (subscriptionDurable != null) {
            this.subscriptionDurable = subscriptionDurable;
        }
    }

    public String getDurableSubscriberName() {
        return this.durableSubscriberName;
    }

    public void setDurableSubscriberName(String durableSubscriberName) {
        this.durableSubscriberName = durableSubscriberName;
    }

    public String getDurableSubscriberClientId() {
        return this.durableSubscriberClientId;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setPubSubNoLocal(Boolean pubSubNoLocal) {
        if (pubSubNoLocal != null) {
            this.pubSubNoLocal = pubSubNoLocal;
        }
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public int getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public int getIdleTaskExecutionLimit() {
        return this.idleTaskExecutionLimit;
    }

    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        this.idleTaskExecutionLimit = idleTaskExecutionLimit;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public int getInitialReconnectDuration() {
        return this.initialReconnectDuration;
    }

    public void setInitialReconnectDuration(int initialReconnectDuration) {
        this.initialReconnectDuration = initialReconnectDuration;
    }

    public double getReconnectionProgressionFactor() {
        return this.reconnectionProgressionFactor;
    }

    public void setReconnectionProgressionFactor(double reconnectionProgressionFactor) {
        this.reconnectionProgressionFactor = reconnectionProgressionFactor;
    }

    public long getMaxReconnectDuration() {
        return this.maxReconnectDuration;
    }

    public void setMaxReconnectDuration(long maxReconnectDuration) {
        this.maxReconnectDuration = maxReconnectDuration;
    }

    public int getMaxMessagesPerTask() {
        return this.maxMessagesPerTask;
    }

    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public String getUserTransactionJNDIName() {
        return this.userTransactionJNDIName;
    }

    public void setUserTransactionJNDIName(String userTransactionJNDIName) {
        if (userTransactionJNDIName != null) {
            this.userTransactionJNDIName = userTransactionJNDIName;
        }
    }

    public boolean isCacheUserTransaction() {
        return this.cacheUserTransaction;
    }

    public void setCacheUserTransaction(Boolean cacheUserTransaction) {
        if (cacheUserTransaction != null) {
            this.cacheUserTransaction = cacheUserTransaction;
        }
    }

    public boolean isJmsSpec11() {
        return this.jmsSpec11;
    }

    public void setJmsSpec11(boolean jmsSpec11) {
        this.jmsSpec11 = jmsSpec11;
    }

    public Hashtable<String, String> getJmsProperties() {
        return this.jmsProperties;
    }

    public void addJmsProperties(Map<String, String> jmsProperties) {
        this.jmsProperties.putAll(jmsProperties);
    }

    public void removeJmsProperties(String key) {
        this.jmsProperties.remove(key);
    }

    public Context getContext() {
        return this.context;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.conFactory;
    }

    public List<MessageListenerTask> getPollingTasks() {
        return this.pollingTasks;
    }

    public void setJmsMessageListener(JMSMessageListener jmsMessageListener) {
        this.jmsMessageListener = jmsMessageListener;
    }

    public void setWorkerPool(WorkerPool workerPool) {
        this.workerPool = workerPool;
    }

    public int getActiveTaskCount() {
        return this.activeTaskCount;
    }

    public int getConsumerCount() {
        return this.consumerCount.get();
    }

    public void setJMSTaskManagerState(int JMSTaskManagerState) {
        this.JMSTaskManagerState = JMSTaskManagerState;
    }

    private class MessageListenerTask
    implements Runnable,
    ExceptionListener {
        private Connection connection = null;
        private Session session = null;
        private MessageConsumer consumer = null;
        private volatile int workerState = 0;
        private int idleExecutionCount = 0;
        private volatile boolean idle = false;
        private volatile boolean connected = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MessageListenerTask() {
            List list = JMSTaskManager.this.pollingTasks;
            synchronized (list) {
                JMSTaskManager.this.pollingTasks.add(this);
            }
        }

        public void pause() {
            if (this.isActive()) {
                if (this.connection != null && JMSTaskManager.this.cacheLevel < 1) {
                    try {
                        this.connection.stop();
                    }
                    catch (JMSException e) {
                        log.warn((Object)("Error pausing Message Listener task for event adapter : " + JMSTaskManager.this.eventAdapterName));
                    }
                }
                this.workerState = 2;
            }
        }

        public void resume() {
            if (this.connection != null && JMSTaskManager.this.cacheLevel < 1) {
                try {
                    this.connection.start();
                }
                catch (JMSException e) {
                    log.warn((Object)("Error resuming Message Listener task for event adapter : " + JMSTaskManager.this.eventAdapterName));
                }
            }
            this.workerState = 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.workerState = 1;
            JMSTaskManager.this.activeTaskCount++;
            int messageCount = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)("New poll task starting : thread id = " + Thread.currentThread().getId()));
            }
            try {
                while (!(!this.isActive() || JMSTaskManager.this.getMaxMessagesPerTask() >= 0 && messageCount >= JMSTaskManager.this.getMaxMessagesPerTask() || JMSTaskManager.this.getConcurrentConsumers() != 1 && this.idleExecutionCount >= JMSTaskManager.this.getIdleTaskExecutionLimit())) {
                    UserTransaction ut = null;
                    try {
                        if (JMSTaskManager.this.transactionality == 2 && (ut = JMSTaskManager.this.getUserTransaction()).getStatus() == 6) {
                            ut.begin();
                        }
                    }
                    catch (NotSupportedException e) {
                        JMSTaskManager.this.handleException("Listener Task is already associated with a transaction", (Exception)((Object)e));
                    }
                    catch (SystemException e) {
                        JMSTaskManager.this.handleException("Error starting a JTA transaction", (Exception)((Object)e));
                    }
                    Message message = this.receiveMessage();
                    if (log.isTraceEnabled()) {
                        if (message != null) {
                            try {
                                log.trace((Object)("<<<<<<< READ message with Message ID : " + message.getJMSMessageID() + " from : " + JMSTaskManager.this.destination + " by Thread ID : " + Thread.currentThread().getId()));
                            }
                            catch (JMSException jMSException) {}
                        } else {
                            log.trace((Object)("No message received by Thread ID : " + Thread.currentThread().getId() + " for destination : " + JMSTaskManager.this.destination));
                        }
                    }
                    if (message != null) {
                        this.idle = false;
                        this.idleExecutionCount = 0;
                        ++messageCount;
                        JMSTaskManager.this.scheduleNewTaskIfAppropriate();
                        this.handleMessage(message, ut);
                        continue;
                    }
                    this.idle = true;
                    ++this.idleExecutionCount;
                }
            }
            finally {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Listener task with Thread ID : " + Thread.currentThread().getId() + " is stopping after processing : " + messageCount + " messages ::  isActive : " + this.isActive() + " maxMessagesPerTask : " + JMSTaskManager.this.getMaxMessagesPerTask() + " concurrentConsumers : " + JMSTaskManager.this.getConcurrentConsumers() + " idleExecutionCount : " + this.idleExecutionCount + " idleTaskExecutionLimit : " + JMSTaskManager.this.getIdleTaskExecutionLimit()));
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Listener task with Thread ID : " + Thread.currentThread().getId() + " is stopping after processing : " + messageCount + " messages"));
                }
                this.closeConsumer(true);
                this.closeSession(true);
                this.closeConnection();
                this.workerState = 0;
                JMSTaskManager.this.activeTaskCount--;
                List list = JMSTaskManager.this.pollingTasks;
                synchronized (list) {
                    JMSTaskManager.this.pollingTasks.remove(this);
                }
                if (!JMSTaskManager.this.isOnExceptionError) {
                    JMSTaskManager.this.scheduleNewTaskIfAppropriate();
                }
            }
        }

        private Message receiveMessage() {
            if (this.consumer == null) {
                this.connection = this.getConnection();
                this.session = this.getSession();
                this.consumer = this.getMessageConsumer();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Preparing a Connection, Session and Consumer to read messages");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Waiting for a message for event adapter : " + JMSTaskManager.this.eventAdapterName + " - duration : " + (JMSTaskManager.this.getReceiveTimeout() < 0 ? "unlimited" : JMSTaskManager.this.getReceiveTimeout() + "ms")));
            }
            try {
                if (JMSTaskManager.this.getReceiveTimeout() < 0) {
                    return this.consumer.receive();
                }
                return this.consumer.receive((long)JMSTaskManager.this.getReceiveTimeout());
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (JMSException e) {
                JMSTaskManager.this.logError("Error receiving message for event adapter : " + JMSTaskManager.this.eventAdapterName, (Exception)((Object)e));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMessage(Message message, UserTransaction ut) {
            boolean commitOrAck;
            String messageId;
            block39: {
                messageId = null;
                try {
                    messageId = message.getJMSMessageID();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                commitOrAck = true;
                try {
                    JMSTaskManager.this.jmsMessageListener.onMessage(message);
                    if (!commitOrAck || JMSTaskManager.this.getSessionAckMode() != 2) break block39;
                }
                catch (Throwable throwable) {
                    if (commitOrAck && JMSTaskManager.this.getSessionAckMode() == 2) {
                        try {
                            message.acknowledge();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Message : " + messageId + " acknowledged"));
                            }
                        }
                        catch (JMSException e) {
                            JMSTaskManager.this.logError("Error acknowledging message : " + messageId, (Exception)((Object)e));
                        }
                    }
                    try {
                        if (this.session.getTransacted()) {
                            if (commitOrAck) {
                                this.session.commit();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Session for message : " + messageId + " committed"));
                                }
                            } else {
                                this.session.rollback();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Session for message : " + messageId + " rolled back"));
                                }
                            }
                        }
                    }
                    catch (JMSException e) {
                        JMSTaskManager.this.logError("Error " + (commitOrAck ? "committing" : "rolling back") + " local session txn for message : " + messageId, (Exception)((Object)e));
                    }
                    try {
                        if (ut != null) {
                            if (commitOrAck) {
                                ut.commit();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("JTA txn for message : " + messageId + " committed"));
                                }
                            } else {
                                ut.rollback();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("JTA txn for message : " + messageId + " rolled back"));
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        JMSTaskManager.this.logError("Error " + (commitOrAck ? "committing" : "rolling back") + " JTA txn for message : " + messageId + " from the session", e);
                    }
                    this.closeConsumer(false);
                    this.closeSession(false);
                    this.closeConnection();
                    throw throwable;
                }
                try {
                    message.acknowledge();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Message : " + messageId + " acknowledged"));
                    }
                }
                catch (JMSException e) {
                    JMSTaskManager.this.logError("Error acknowledging message : " + messageId, (Exception)((Object)e));
                }
            }
            try {
                if (this.session.getTransacted()) {
                    if (commitOrAck) {
                        this.session.commit();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Session for message : " + messageId + " committed"));
                        }
                    } else {
                        this.session.rollback();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Session for message : " + messageId + " rolled back"));
                        }
                    }
                }
            }
            catch (JMSException e) {
                JMSTaskManager.this.logError("Error " + (commitOrAck ? "committing" : "rolling back") + " local session txn for message : " + messageId, (Exception)((Object)e));
            }
            try {
                if (ut != null) {
                    if (commitOrAck) {
                        ut.commit();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("JTA txn for message : " + messageId + " committed"));
                        }
                    } else {
                        ut.rollback();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("JTA txn for message : " + messageId + " rolled back"));
                        }
                    }
                }
            }
            catch (Exception e) {
                JMSTaskManager.this.logError("Error " + (commitOrAck ? "committing" : "rolling back") + " JTA txn for message : " + messageId + " from the session", e);
            }
            this.closeConsumer(false);
            this.closeSession(false);
            this.closeConnection();
        }

        public void onException(JMSException j) {
            JMSTaskManager.this.isOnExceptionError = true;
            if (!JMSTaskManager.this.isSTMActive()) {
                this.requestShutdown();
                return;
            }
            this.setConnected(false);
            if (JMSTaskManager.this.cacheLevel < 1) {
                log.warn((Object)("JMS Connection failure : " + j.getMessage()));
                this.requestShutdown();
                return;
            }
            JMSTaskManager.this.setJMSTaskManagerState(4);
            log.error((Object)("JMS Connection failed : " + j.getMessage() + " - shutting down worker tasks"));
            int r = 1;
            long retryDuration = JMSTaskManager.this.initialReconnectDuration;
            do {
                try {
                    log.info((Object)("Reconnection attempt : " + r + " for event adapter : " + JMSTaskManager.this.eventAdapterName));
                    JMSTaskManager.this.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean connected = false;
                for (int i = 0; i < 5; ++i) {
                    if (JMSTaskManager.this.getConnectedTaskCount() == JMSTaskManager.this.concurrentConsumers) {
                        connected = true;
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!connected) {
                    retryDuration = (long)((double)retryDuration * JMSTaskManager.this.reconnectionProgressionFactor);
                    log.error((Object)("Reconnection attempt : " + r++ + " for event adapter : " + JMSTaskManager.this.eventAdapterName + " failed. Next retry in " + retryDuration / 1000L + " seconds"));
                    if (retryDuration > JMSTaskManager.this.maxReconnectDuration) {
                        retryDuration = JMSTaskManager.this.maxReconnectDuration;
                    }
                    try {
                        Thread.sleep(retryDuration);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                JMSTaskManager.this.isOnExceptionError = false;
                log.info((Object)("Reconnection attempt: " + r + " for event adapter: " + JMSTaskManager.this.eventAdapterName + " was successful!"));
            } while (!JMSTaskManager.this.isSTMActive() || JMSTaskManager.this.getConnectedTaskCount() < JMSTaskManager.this.concurrentConsumers);
        }

        protected void requestShutdown() {
            this.workerState = 3;
        }

        private boolean isActive() {
            return this.workerState == 1;
        }

        protected boolean isTaskIdle() {
            return this.idle;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public void setConnected(boolean connected) {
            this.connected = connected;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Connection getConnection() {
            if (JMSTaskManager.this.cacheLevel < 1) {
                if (this.connection == null) {
                    this.connection = this.createConnection();
                    this.setConnected(true);
                }
            } else if (this.connection == null) {
                JMSTaskManager jMSTaskManager = JMSTaskManager.this;
                synchronized (jMSTaskManager) {
                    if (JMSTaskManager.this.sharedConnection == null) {
                        JMSTaskManager.this.sharedConnection = this.createConnection();
                    }
                }
                this.connection = JMSTaskManager.this.sharedConnection;
                this.setConnected(true);
            }
            return this.connection;
        }

        private Session getSession() {
            if (this.session == null || JMSTaskManager.this.cacheLevel < 2) {
                this.session = this.createSession();
            }
            return this.session;
        }

        private MessageConsumer getMessageConsumer() {
            if (this.consumer == null || JMSTaskManager.this.cacheLevel < 3) {
                this.consumer = this.createConsumer();
            }
            return this.consumer;
        }

        private void closeConnection() {
            if (this.connection != null && JMSTaskManager.this.cacheLevel < 1) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Closing non-shared JMS connection for event adapter : " + JMSTaskManager.this.eventAdapterName));
                    }
                    this.connection.close();
                }
                catch (JMSException e) {
                    JMSTaskManager.this.logError("Error closing JMS connection", (Exception)((Object)e));
                }
                finally {
                    this.connection = null;
                }
            }
        }

        private void closeSession(boolean forced) {
            if (this.session != null && (JMSTaskManager.this.cacheLevel < 2 || forced)) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Closing non-shared JMS session for event adapter : " + JMSTaskManager.this.eventAdapterName));
                    }
                    this.session.close();
                }
                catch (JMSException e) {
                    JMSTaskManager.this.logError("Error closing JMS session", (Exception)((Object)e));
                }
                finally {
                    this.session = null;
                }
            }
        }

        private void closeConsumer(boolean forced) {
            if (this.consumer != null && (JMSTaskManager.this.cacheLevel < 3 || forced)) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Closing non-shared JMS consumer for event adapter : " + JMSTaskManager.this.eventAdapterName));
                    }
                    JMSTaskManager.this.consumerCount.decrementAndGet();
                    this.consumer.close();
                }
                catch (JMSException e) {
                    JMSTaskManager.this.logError("Error closing JMS consumer", (Exception)((Object)e));
                }
                finally {
                    this.consumer = null;
                }
            }
        }

        private Connection createConnection() {
            try {
                JMSTaskManager.this.conFactory = JMSUtils.lookup(JMSTaskManager.this.getInitialContext(), ConnectionFactory.class, JMSTaskManager.this.getConnFactoryJNDIName());
                log.debug((Object)("Connected to the JMS connection factory : " + JMSTaskManager.this.getConnFactoryJNDIName()));
            }
            catch (NamingException e) {
                JMSTaskManager.this.handleException("Error looking up connection factory : " + JMSTaskManager.this.getConnFactoryJNDIName() + " using JNDI properties : " + JMSTaskManager.this.jmsProperties, e);
            }
            Connection connection = null;
            try {
                connection = JMSUtils.createConnection(JMSTaskManager.this.conFactory, (String)JMSTaskManager.this.jmsProperties.get("transport.jms.UserName"), (String)JMSTaskManager.this.jmsProperties.get("transport.jms.Password"), JMSTaskManager.this.isJmsSpec11(), JMSTaskManager.this.isQueue(), JMSTaskManager.this.isSubscriptionDurable(), JMSTaskManager.this.durableSubscriberClientId);
                connection.setExceptionListener((ExceptionListener)this);
                connection.start();
                log.debug((Object)("JMS Connection for event adapter : " + JMSTaskManager.this.eventAdapterName + " created and started"));
            }
            catch (JMSException e) {
                if (connection != null) {
                    log.warn((Object)("Closing connection due to error:" + e.getMessage()));
                    try {
                        connection.close();
                    }
                    catch (JMSException ex) {
                        log.error((Object)("Error when cleaning up connection:" + ex.getMessage()), (Throwable)e);
                    }
                }
                JMSTaskManager.this.handleException("Error acquiring a JMS connection to : " + JMSTaskManager.this.getConnFactoryJNDIName() + " using JNDI properties : " + JMSTaskManager.this.jmsProperties, (Exception)((Object)e));
            }
            return connection;
        }

        private Session createSession() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating a new JMS Session for event adapter : " + JMSTaskManager.this.eventAdapterName));
                }
                return JMSUtils.createSession(this.connection, JMSTaskManager.this.isSessionTransacted(), JMSTaskManager.this.getSessionAckMode(), JMSTaskManager.this.isJmsSpec11(), JMSTaskManager.this.isQueue());
            }
            catch (JMSException e) {
                JMSTaskManager.this.handleException("Error creating JMS session for event adapter : " + JMSTaskManager.this.eventAdapterName, (Exception)((Object)e));
                return null;
            }
        }

        private MessageConsumer createConsumer() {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating a new JMS MessageConsumer for event adapter : " + JMSTaskManager.this.eventAdapterName));
                }
                MessageConsumer consumer = JMSUtils.createConsumer(this.session, JMSTaskManager.this.getDestination(this.session), JMSTaskManager.this.isQueue(), JMSTaskManager.this.isSubscriptionDurable() && JMSTaskManager.this.getDurableSubscriberName() != null ? JMSTaskManager.this.getDurableSubscriberName() : JMSTaskManager.this.eventAdapterName, JMSTaskManager.this.getMessageSelector(), JMSTaskManager.this.isPubSubNoLocal(), JMSTaskManager.this.isSubscriptionDurable(), JMSTaskManager.this.isJmsSpec11());
                JMSTaskManager.this.consumerCount.incrementAndGet();
                return consumer;
            }
            catch (JMSException e) {
                JMSTaskManager.this.handleException("Error creating JMS consumer for event adapter : " + JMSTaskManager.this.eventAdapterName, (Exception)((Object)e));
                return null;
            }
        }
    }
}

