/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.owasp.encoder.Encode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.ui.NDataSourceAdminServiceClient;
import org.wso2.carbon.ndatasource.ui.config.DSXMLConfiguration;
import org.wso2.carbon.ndatasource.ui.config.RDBMSDSXMLConfiguration;
import org.wso2.carbon.ndatasource.ui.stub.NDataSourceAdminDataSourceException;
import org.wso2.carbon.ndatasource.ui.stub.core.services.xsd.WSDataSourceInfo;
import org.wso2.carbon.ndatasource.ui.stub.core.services.xsd.WSDataSourceMetaInfo;
import org.wso2.carbon.ndatasource.ui.stub.core.services.xsd.WSDataSourceMetaInfo_WSDataSourceDefinition;
import org.wso2.carbon.ndatasource.ui.stub.core.xsd.JNDIConfig;
import org.wso2.carbon.ndatasource.ui.stub.core.xsd.JNDIConfig_EnvEntry;
import org.wso2.carbon.utils.xml.XMLPrettyPrinter;

public class NDataSourceHelper {
    private static final Log log = LogFactory.getLog(NDataSourceHelper.class);
    private static ResourceBundle bundle;

    public static WSDataSourceMetaInfo createWSDataSourceMetaInfo(HttpServletRequest request, NDataSourceAdminServiceClient client) throws RemoteException, DataSourceException, NDataSourceAdminDataSourceException {
        WSDataSourceMetaInfo_WSDataSourceDefinition dataSourceDefinition = null;
        String datasourceType = NDataSourceHelper.sanitizeInput(request.getParameter("dsType"));
        String datasourceCustomType = NDataSourceHelper.sanitizeInput(request.getParameter("customDsType"));
        boolean configView = Boolean.parseBoolean(request.getParameter("configView"));
        bundle = ResourceBundle.getBundle("org.wso2.carbon.ndatasource.ui.i18n.Resources", request.getLocale());
        String name = NDataSourceHelper.sanitizeInput(request.getParameter("dsName"));
        if ((name == null || "".equals(name)) && ((name = request.getParameter("name_hidden")) == null || "".equals(name))) {
            NDataSourceHelper.handleException(bundle.getString("ds.name.cannotfound.msg"));
        }
        if (configView && (datasourceCustomType == null || "".equals(datasourceCustomType))) {
            NDataSourceHelper.handleException(bundle.getString("custom.ds.type.name.cannotfound.msg"));
        }
        String description = NDataSourceHelper.sanitizeInput(request.getParameter("description"));
        WSDataSourceMetaInfo dataSourceMetaInfo = new WSDataSourceMetaInfo();
        dataSourceMetaInfo.setName(name);
        dataSourceMetaInfo.setSystem(Boolean.parseBoolean(request.getParameter("isSystem")));
        if (description != null && !"".equals(description)) {
            dataSourceMetaInfo.setDescription(description);
        }
        if (configView) {
            dataSourceDefinition = NDataSourceHelper.createCustomDS(request.getParameter("configContent"), datasourceCustomType);
        } else if (datasourceType.equals("RDBMS")) {
            if (request.getParameter("jndiname") != null && !request.getParameter("jndiname").equals("")) {
                dataSourceMetaInfo.setJndiConfig(NDataSourceHelper.createJNDIConfig(request));
            } else if (request.getParameter("useDataSourceFactory") != null || request.getParameter("jndiProperties") != null && !request.getParameter("jndiProperties").equals("")) {
                NDataSourceHelper.handleException(bundle.getString("jndi.name.cannotfound.msg"));
            }
            DSXMLConfiguration dsXMLConfig = NDataSourceHelper.createDSXMLConfiguration(datasourceType, request, client);
            dataSourceDefinition = NDataSourceHelper.createWSDataSourceDefinition(dsXMLConfig, datasourceType);
        } else {
            throw new IllegalArgumentException("Provided Data Source type not supported");
        }
        dataSourceMetaInfo.setDefinition(dataSourceDefinition);
        return dataSourceMetaInfo;
    }

    private static WSDataSourceMetaInfo_WSDataSourceDefinition createCustomDS(String configuration, String datasourceType) {
        WSDataSourceMetaInfo_WSDataSourceDefinition wSDataSourceDefinition = new WSDataSourceMetaInfo_WSDataSourceDefinition();
        wSDataSourceDefinition.setDsXMLConfiguration(configuration);
        wSDataSourceDefinition.setType(datasourceType);
        return wSDataSourceDefinition;
    }

    private static DSXMLConfiguration createDSXMLConfiguration(String type, HttpServletRequest request, NDataSourceAdminServiceClient client) throws RemoteException, DataSourceException, NDataSourceAdminDataSourceException {
        if (type.equals("RDBMS")) {
            RDBMSDSXMLConfiguration rdbmsDSXMLConfig = null;
            try {
                rdbmsDSXMLConfig = new RDBMSDSXMLConfiguration();
            }
            catch (NDataSourceAdminDataSourceException e) {
                NDataSourceHelper.handleException(e.getMessage());
            }
            String dsProvider = NDataSourceHelper.sanitizeInput(request.getParameter("dsProviderType"));
            if ("External Datasource".equals(dsProvider)) {
                String dsproviderProperties;
                String dsclassname = NDataSourceHelper.sanitizeInput(request.getParameter("dsclassname"));
                if (dsclassname == null || "".equals(dsclassname)) {
                    NDataSourceHelper.handleException(bundle.getString("ds.dsclassname.cannotfound.msg"));
                }
                if ((dsproviderProperties = NDataSourceHelper.sanitizeInput(request.getParameter("dsproviderProperties"))) == null || "".equals(dsproviderProperties)) {
                    NDataSourceHelper.handleException(bundle.getString("ds.external.datasource.property.cannotfound.msg"));
                }
                String[] propsList = dsproviderProperties.split("::");
                String[] property = null;
                ArrayList<RDBMSDSXMLConfiguration.DataSourceProperty> dataSourceProps = new ArrayList<RDBMSDSXMLConfiguration.DataSourceProperty>();
                for (int i = 0; i < propsList.length; ++i) {
                    RDBMSDSXMLConfiguration.DataSourceProperty dataSourceProperty = new RDBMSDSXMLConfiguration.DataSourceProperty();
                    property = propsList[i].split(",");
                    dataSourceProperty.setName(property[0]);
                    dataSourceProperty.setValue(property[1]);
                    dataSourceProps.add(dataSourceProperty);
                }
                rdbmsDSXMLConfig.setDataSourceClassName(dsclassname);
                rdbmsDSXMLConfig.setDataSourceProps(dataSourceProps);
            } else if ("default".equals(dsProvider)) {
                String url;
                String driver = Encode.forHtmlContent((String)request.getParameter("driver"));
                if (driver == null || "".equals(driver)) {
                    NDataSourceHelper.handleException(bundle.getString("ds.driver.cannotfound.msg"));
                }
                if ((url = NDataSourceHelper.sanitizeInput(request.getParameter("url"))) == null || "".equals(url)) {
                    NDataSourceHelper.handleException(bundle.getString("ds.url.cannotfound.msg"));
                }
                String username = NDataSourceHelper.sanitizeInput(request.getParameter("username"));
                String password = null;
                boolean isEditMode = Boolean.parseBoolean(request.getParameter("editMode"));
                if (isEditMode) {
                    String changePassword = request.getParameter("changePassword");
                    String string = changePassword = changePassword == null || changePassword.equals("false") ? "false" : "true";
                    if (Boolean.parseBoolean(changePassword)) {
                        password = request.getParameter("newPassword");
                    } else {
                        WSDataSourceInfo dataSourceInfo = client.getDataSource(request.getParameter("dsName"));
                        WSDataSourceMetaInfo_WSDataSourceDefinition dataSourceDefinition = dataSourceInfo.getDsMetaInfo().getDefinition();
                        String configuration = dataSourceDefinition.getDsXMLConfiguration();
                        RDBMSDSXMLConfiguration rdbmsCon = (RDBMSDSXMLConfiguration)NDataSourceHelper.unMarshal(type, configuration);
                        password = rdbmsCon.getPassword().getValue();
                    }
                } else {
                    password = request.getParameter("password");
                }
                rdbmsDSXMLConfig.setUrl(url);
                rdbmsDSXMLConfig.setDriverClassName(driver);
                rdbmsDSXMLConfig.setUsername(username);
                RDBMSDSXMLConfiguration.Password passwordOb = new RDBMSDSXMLConfiguration.Password();
                passwordOb.setValue(password);
                rdbmsDSXMLConfig.setPassword(passwordOb);
            } else {
                throw new IllegalArgumentException("Unknown data source provider type");
            }
            NDataSourceHelper.setDatasourceProperties(rdbmsDSXMLConfig, request);
            return rdbmsDSXMLConfig;
        }
        throw new IllegalArgumentException("Provided Data Source type not supported");
    }

    private static JNDIConfig createJNDIConfig(HttpServletRequest request) {
        String name = request.getParameter("jndiname");
        JNDIConfig jndiConfig = new JNDIConfig();
        jndiConfig.setName(name);
        String useDataSourceFactory = request.getParameter("useDataSourceFactory");
        useDataSourceFactory = useDataSourceFactory == null ? "false" : "true";
        jndiConfig.setUseDataSourceFactory(Boolean.parseBoolean(useDataSourceFactory));
        String jndiProperties = request.getParameter("jndiProperties");
        if (jndiProperties != null && !"".equals(jndiProperties)) {
            String[] propsList = jndiProperties.split("::");
            String[] property = null;
            JNDIConfig_EnvEntry[] jndiEnvyList = new JNDIConfig_EnvEntry[propsList.length];
            for (int i = 0; i < propsList.length; ++i) {
                JNDIConfig_EnvEntry jndiEnvy = new JNDIConfig_EnvEntry();
                property = propsList[i].split(",");
                jndiEnvy.setName(property[0]);
                jndiEnvy.setValue(property[1]);
                jndiEnvyList[i] = jndiEnvy;
            }
            if (propsList.length > 0) {
                jndiConfig.setEnvironment(jndiEnvyList);
            }
        }
        return jndiConfig;
    }

    private static WSDataSourceMetaInfo_WSDataSourceDefinition createWSDataSourceDefinition(DSXMLConfiguration dsXMLConfig, String datasourceType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            dsXMLConfig.getDSMarshaller().marshal((Object)dsXMLConfig, (OutputStream)out);
        }
        catch (JAXBException e) {
            NDataSourceHelper.handleException("Error in marshelling Data Source Configuration info");
        }
        WSDataSourceMetaInfo_WSDataSourceDefinition wSDataSourceDefinition = new WSDataSourceMetaInfo_WSDataSourceDefinition();
        wSDataSourceDefinition.setDsXMLConfiguration(out.toString());
        wSDataSourceDefinition.setType(datasourceType);
        return wSDataSourceDefinition;
    }

    public static Map<String, String> getAllDataSources(WSDataSourceInfo[] allDataSourcesInfo) {
        HashMap<String, String> allDataSources = new HashMap<String, String>();
        if (allDataSourcesInfo != null) {
            for (WSDataSourceInfo dataSourceInfo : allDataSourcesInfo) {
                WSDataSourceMetaInfo dataSourceMetaInfo = dataSourceInfo.getDsMetaInfo();
                if ("ERROR".toString().equals(dataSourceInfo.getDsStatus().getMode())) {
                    allDataSources.put(dataSourceMetaInfo.getName(), "ERROR: " + dataSourceInfo.getDsStatus().getDetails());
                    continue;
                }
                allDataSources.put(dataSourceMetaInfo.getName(), dataSourceInfo.getDsStatus().getMode());
            }
        }
        return allDataSources;
    }

    public static DSXMLConfiguration unMarshal(String datasourceType, String configuration) throws NDataSourceAdminDataSourceException {
        if (datasourceType.equals("RDBMS")) {
            JAXBContext ctx = null;
            RDBMSDSXMLConfiguration rdbmsConfiguration = null;
            try {
                ctx = JAXBContext.newInstance((Class[])new Class[]{RDBMSDSXMLConfiguration.class});
                rdbmsConfiguration = (RDBMSDSXMLConfiguration)ctx.createUnmarshaller().unmarshal((Node)NDataSourceHelper.stringToElement(configuration));
            }
            catch (JAXBException e) {
                throw new NDataSourceAdminDataSourceException("Error creating rdbms data source configuration info unmarshaller: " + e.getMessage(), (Throwable)e);
            }
            return rdbmsConfiguration;
        }
        throw new IllegalArgumentException("Provided Dta Source type not supported");
    }

    public static Element stringToElement(String xml) {
        if (xml == null || xml.trim().length() == 0) {
            return null;
        }
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(false);
            docFactory.setXIncludeAware(false);
            docFactory.setExpandEntityReferences(false);
            docFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            docFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SecurityManager securityManager = new SecurityManager();
            securityManager.setEntityExpansionLimit(0);
            docFactory.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
            DocumentBuilder db = docFactory.newDocumentBuilder();
            return db.parse(new ByteArrayInputStream(xml.getBytes())).getDocumentElement();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void setDatasourceProperties(RDBMSDSXMLConfiguration rdbmsDSXMLConfig, HttpServletRequest request) {
        String validationQueryTimeout;
        Boolean alternateUsernameAllowed;
        String suspectTimeout;
        String maxAge;
        Boolean useEquals;
        String abandonWhenPercentageFull;
        Boolean fairQueue;
        Boolean jmxEnabled;
        String validationInterval;
        String jdbcInterceptors;
        String initSQL;
        String connectionProperties;
        Boolean logAbandoned;
        String removeAbandonedTimeout;
        Boolean removeAbandoned;
        Boolean accessToUnderlyingConnectionAllowed;
        String minEvictableIdleTimeMillis;
        String numTestsPerEvictionRun;
        String timeBetweenEvictionRunsMillis;
        String validatorClassName;
        String validationQuery;
        Boolean testWhileIdle;
        Boolean testOnReturn;
        Boolean testOnBorrow;
        String maxWait;
        String initialSize;
        String minIdle;
        String maxIdle;
        String maxActive;
        String defaultCatalog;
        String defaultTransactionIsolation;
        Boolean defaultReadOnly;
        Boolean defaultAutoCommit = Boolean.parseBoolean(request.getParameter("defaultAutoCommit"));
        if (defaultAutoCommit.booleanValue()) {
            rdbmsDSXMLConfig.setDefaultAutoCommit(defaultAutoCommit);
        }
        if ((defaultReadOnly = Boolean.valueOf(Boolean.parseBoolean(request.getParameter("defaultReadOnly")))).booleanValue()) {
            rdbmsDSXMLConfig.setDefaultReadOnly(defaultReadOnly);
        }
        if ((defaultTransactionIsolation = request.getParameter("defaultTransactionIsolation")) != null && !"NONE".equals(defaultTransactionIsolation)) {
            rdbmsDSXMLConfig.setDefaultTransactionIsolation(defaultTransactionIsolation.trim());
        }
        if ((defaultCatalog = request.getParameter("defaultCatalog")) != null && !"".equals(defaultCatalog)) {
            rdbmsDSXMLConfig.setDefaultCatalog(defaultCatalog.trim());
        }
        if ((maxActive = request.getParameter("maxActive")) != null && !maxActive.contains("int") && !maxActive.equals("")) {
            try {
                rdbmsDSXMLConfig.setMaxActive(Integer.parseInt(maxActive.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.maxActive"));
            }
        }
        if ((maxIdle = request.getParameter("maxIdle")) != null && !maxIdle.contains("int") && !maxIdle.equals("")) {
            try {
                rdbmsDSXMLConfig.setMaxIdle(Integer.parseInt(maxIdle.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.maxidle"));
            }
        }
        if ((minIdle = request.getParameter("minIdle")) != null && !minIdle.contains("int") && !minIdle.equals("")) {
            try {
                rdbmsDSXMLConfig.setMinIdle(Integer.parseInt(minIdle.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.MinIdle"));
            }
        }
        if ((initialSize = request.getParameter("initialSize")) != null && !initialSize.contains("int") && !initialSize.equals("")) {
            try {
                rdbmsDSXMLConfig.setInitialSize(Integer.parseInt(initialSize.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.Initialsize"));
            }
        }
        if ((maxWait = request.getParameter("maxWait")) != null && !maxWait.contains("int") && !maxWait.equals("")) {
            try {
                rdbmsDSXMLConfig.setMaxWait(Integer.parseInt(maxWait.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.maxWait"));
            }
        }
        if ((testOnBorrow = Boolean.valueOf(Boolean.parseBoolean(request.getParameter("testOnBorrow")))).booleanValue()) {
            rdbmsDSXMLConfig.setTestOnBorrow(testOnBorrow);
        }
        if ((testOnReturn = Boolean.valueOf(Boolean.parseBoolean(request.getParameter("testOnReturn")))).booleanValue()) {
            rdbmsDSXMLConfig.setTestOnReturn(testOnReturn);
        }
        if ((testWhileIdle = Boolean.valueOf(Boolean.parseBoolean(request.getParameter("testWhileIdle")))).booleanValue()) {
            rdbmsDSXMLConfig.setTestWhileIdle(testWhileIdle);
        }
        if ((validationQuery = request.getParameter("validationquery")) != null && !"".equals(validationQuery)) {
            rdbmsDSXMLConfig.setValidationQuery(validationQuery.trim());
        }
        if ((validatorClassName = request.getParameter("validatorClassName")) != null && !"".equals(validatorClassName)) {
            rdbmsDSXMLConfig.setValidatorClassName(validatorClassName.trim());
        }
        if ((timeBetweenEvictionRunsMillis = request.getParameter("timeBetweenEvictionRunsMillis")) != null && !timeBetweenEvictionRunsMillis.contains("int") && !timeBetweenEvictionRunsMillis.equals("")) {
            try {
                rdbmsDSXMLConfig.setTimeBetweenEvictionRunsMillis(Integer.parseInt(timeBetweenEvictionRunsMillis.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.timeBetweenEvictionRunsMillis"));
            }
        }
        if ((numTestsPerEvictionRun = request.getParameter("numTestsPerEvictionRun")) != null && !numTestsPerEvictionRun.contains("int") && !numTestsPerEvictionRun.equals("")) {
            try {
                rdbmsDSXMLConfig.setNumTestsPerEvictionRun(Integer.parseInt(numTestsPerEvictionRun.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.numTestsPerEvictionRun"));
            }
        }
        if ((minEvictableIdleTimeMillis = request.getParameter("minEvictableIdleTimeMillis")) != null && !minEvictableIdleTimeMillis.contains("int") && !minEvictableIdleTimeMillis.equals("")) {
            try {
                rdbmsDSXMLConfig.setMinEvictableIdleTimeMillis(Integer.parseInt(minEvictableIdleTimeMillis.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.minEvictableIdleTimeMillis"));
            }
        }
        if ((accessToUnderlyingConnectionAllowed = Boolean.valueOf(Boolean.parseBoolean(request.getParameter("accessToUnderlyingConnectionAllowed")))).booleanValue()) {
            rdbmsDSXMLConfig.setAccessToUnderlyingConnectionAllowed(accessToUnderlyingConnectionAllowed);
        }
        if ((removeAbandoned = Boolean.valueOf(Boolean.parseBoolean(request.getParameter("removeAbandoned")))).booleanValue()) {
            rdbmsDSXMLConfig.setRemoveAbandoned(removeAbandoned);
        }
        if ((removeAbandonedTimeout = request.getParameter("removeAbandonedTimeout")) != null && !removeAbandonedTimeout.contains("int") && !removeAbandonedTimeout.equals("")) {
            try {
                rdbmsDSXMLConfig.setRemoveAbandonedTimeout(Integer.parseInt(removeAbandonedTimeout.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.removeAbandonedTimeout"));
            }
        }
        if ((logAbandoned = Boolean.valueOf(Boolean.parseBoolean(request.getParameter("logAbandoned")))).booleanValue()) {
            rdbmsDSXMLConfig.setLogAbandoned(logAbandoned);
        }
        if ((connectionProperties = request.getParameter("connectionProperties")) != null && !"".equals(connectionProperties)) {
            rdbmsDSXMLConfig.setConnectionProperties(connectionProperties.trim());
        }
        if ((initSQL = request.getParameter("initSQL")) != null && !"".equals(initSQL)) {
            rdbmsDSXMLConfig.setInitSQL(initSQL.trim());
        }
        if ((jdbcInterceptors = request.getParameter("jdbcInterceptors")) != null && !"".equals(jdbcInterceptors)) {
            rdbmsDSXMLConfig.setJdbcInterceptors(jdbcInterceptors.trim());
        }
        if ((validationInterval = request.getParameter("validationInterval")) != null && !validationInterval.contains("long") && !validationInterval.equals("")) {
            try {
                rdbmsDSXMLConfig.setValidationInterval(Long.parseLong(validationInterval.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.validationInterval"));
            }
        }
        if ((jmxEnabled = Boolean.valueOf(Boolean.parseBoolean(request.getParameter("jmxEnabled")))).booleanValue()) {
            rdbmsDSXMLConfig.setJmxEnabled(jmxEnabled);
        }
        if ((fairQueue = Boolean.valueOf(Boolean.parseBoolean(request.getParameter("fairQueue")))).booleanValue()) {
            rdbmsDSXMLConfig.setFairQueue(fairQueue);
        }
        if ((abandonWhenPercentageFull = request.getParameter("abandonWhenPercentageFull")) != null && !abandonWhenPercentageFull.contains("int") && !abandonWhenPercentageFull.equals("")) {
            try {
                rdbmsDSXMLConfig.setAbandonWhenPercentageFull(Integer.parseInt(abandonWhenPercentageFull.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.abandonWhenPercentageFull"));
            }
        }
        if ((useEquals = Boolean.valueOf(Boolean.parseBoolean(request.getParameter("useEquals")))).booleanValue()) {
            rdbmsDSXMLConfig.setUseEquals(useEquals);
        }
        if ((maxAge = request.getParameter("maxAge")) != null && !maxAge.contains("long") && !maxAge.equals("")) {
            try {
                rdbmsDSXMLConfig.setMaxAge(Long.parseLong(maxAge.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.maxAge"));
            }
        }
        if ((suspectTimeout = request.getParameter("suspectTimeout")) != null && !suspectTimeout.contains("int") && !suspectTimeout.equals("")) {
            try {
                rdbmsDSXMLConfig.setSuspectTimeout(Integer.parseInt(suspectTimeout.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.suspectTimeout"));
            }
        }
        if ((alternateUsernameAllowed = Boolean.valueOf(Boolean.parseBoolean(request.getParameter("alternateUsernameAllowed")))).booleanValue()) {
            rdbmsDSXMLConfig.setAlternateUsernameAllowed(alternateUsernameAllowed);
        }
        if ((validationQueryTimeout = request.getParameter("validationQueryTimeout")) != null && !validationQueryTimeout.contains("int") && !validationQueryTimeout.equals("")) {
            try {
                rdbmsDSXMLConfig.setValidationQueryTimeout(Integer.parseInt(validationQueryTimeout.trim()));
            }
            catch (NumberFormatException e) {
                NDataSourceHelper.handleException(bundle.getString("invalid.validationQueryTimeout"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String elementToString(Element element) {
        try (StringWriter buff = new StringWriter();){
            if (element == null) {
                String string2 = "";
                return string2;
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(element), new StreamResult(buff));
            String string = buff.toString();
            return string;
        }
        catch (TransformerException e) {
            log.error((Object)("Error while converting element to string: " + e.getMessage()), (Throwable)e);
            return "";
        }
        catch (IOException e) {
            log.error((Object)("Error while closing StringWriter " + e.getMessage()), (Throwable)e);
            return "";
        }
    }

    private static List<Element> getChildElements(Element element) {
        ArrayList<Element> childEls = new ArrayList<Element>();
        for (Node tmpNode : NDataSourceHelper.getNodesAsList(element)) {
            if (tmpNode.getNodeType() != 1) continue;
            childEls.add((Element)tmpNode);
        }
        return childEls;
    }

    private static List<Node> getNodesAsList(Element element) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        int count = nodeList.getLength();
        for (int i = 0; i < count; ++i) {
            nodes.add(nodeList.item(i));
        }
        return nodes;
    }

    private static List<Node> getWhitespaceNodes(Element element) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : NDataSourceHelper.getNodesAsList(element)) {
            if (node.getNodeType() != 3) continue;
            node.setNodeValue(node.getNodeValue().trim());
            if (node.getNodeValue().length() != 0) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private static void removeWhitespaceInMixedContentElements(Element element) {
        List<Element> childEls = NDataSourceHelper.getChildElements(element);
        if (childEls.size() > 0) {
            for (Node node : NDataSourceHelper.getWhitespaceNodes(element)) {
                element.removeChild(node);
            }
            for (Element childEl : childEls) {
                NDataSourceHelper.removeWhitespaceInMixedContentElements(childEl);
            }
        }
    }

    public static String prettifyXML(String xmlContent) {
        Element element = NDataSourceHelper.stringToElement(xmlContent);
        if (element == null) {
            return "";
        }
        NDataSourceHelper.removeWhitespaceInMixedContentElements(element);
        xmlContent = NDataSourceHelper.elementToString(element);
        ByteArrayInputStream byteIn = new ByteArrayInputStream(xmlContent.getBytes());
        XMLPrettyPrinter prettyPrinter = new XMLPrettyPrinter((InputStream)byteIn);
        return prettyPrinter.xmlFormat().trim();
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new IllegalArgumentException(msg);
    }

    public static String getRDBMSEngine(String jdbcUrl) {
        Pattern p = Pattern.compile("jdbc:[a-zA-Z0-9]+");
        Matcher m = p.matcher(jdbcUrl);
        while (m.find()) {
            if ("jdbc:mysql".equals(m.group())) {
                return "mysql";
            }
            if ("jdbc:derby".equals(m.group())) {
                return "derby";
            }
            if ("jdbc:sqlserver".equals(m.group())) {
                return "mssqlserver";
            }
            if ("jdbc:oracle".equals(m.group())) {
                return "oracle";
            }
            if ("jdbc:db2".equals(m.group())) {
                return "db2";
            }
            if ("jdbc:hsqldb".equals(m.group())) {
                return "hsqldb";
            }
            if ("jdbc:postgresql".equals(m.group())) {
                return "postgresql";
            }
            if ("jdbc:sybase".equals(m.group())) {
                return "sybase";
            }
            if ("jdbc:h2".equals(m.group())) {
                return "h2";
            }
            if (!"jdbc:informix-sqli".equals(m.group())) continue;
            return "informix-sqli";
        }
        return "Generic";
    }

    private static String sanitizeInput(String input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        return input.replaceAll("(?i)<script.*?>.*?</script.*?>", "").replaceAll("(?i)<script.*?>", "").replaceAll("(?i)<script.*?/>", "").replaceAll("(?i)<iframe.*?>.*?</iframe.*?>", "").replaceAll("(?i)<iframe.*?>", "").replaceAll("(?i)<iframe.*?/>", "").replaceAll("(?i)<object.*?>.*?</object.*?>", "").replaceAll("(?i)<object.*?>", "").replaceAll("(?i)<object.*?/>", "").replaceAll("(?i)<.*?javascript:.*?>.*?</.*?>", "").replaceAll("(?i)<.*?javascript:.*?>", "").replaceAll("(?i)<.*?javascript:.*?/>", "").replaceAll("(?i)<.*?onload=.*?>.*?</.*?>", "").replaceAll("(?i)<.*?onload=.*?>", "").replaceAll("(?i)<.*?onload=.*?/>", "").replaceAll("(?i)<.*?expression.*?>.*?</.*?>", "").replaceAll("(?i)<.*?expression.*?>", "").replaceAll("(?i)<.*?expression.*?/>", "").replaceAll("(?i)<.*?\\\\s+on.*?>.*?</.*?>", "").replaceAll("(?i)<.*?\\\\s+on.*?>", "").replaceAll("(?i)<.*?\\\\s+on.*?/>", "");
    }
}

