/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.context.rewrite.valve;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.context.rewrite.bean.RewriteContext;
import org.wso2.carbon.identity.context.rewrite.internal.ContextRewriteValveServiceComponentHolder;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class TenantContextRewriteValve
extends ValveBase {
    private static final String TENANT_DOMAIN = "tenantDomain";
    private static List<RewriteContext> contextsToRewrite;
    private static List<String> contextListToOverwriteDispatch;
    private boolean isTenantQualifiedUrlsEnabled;
    private TenantManager tenantManager;
    private static final Log log;

    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        contextsToRewrite = this.getContextsToRewrite();
        contextListToOverwriteDispatch = this.getContextListToOverwriteDispatchLocation();
        this.isTenantQualifiedUrlsEnabled = this.isTenantQualifiedUrlsEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        String requestURI = request.getRequestURI();
        String contextToForward = null;
        boolean isContextRewrite = false;
        boolean isWebApp = false;
        for (RewriteContext context : contextsToRewrite) {
            Pattern patternTenant = context.getTenantContextPattern();
            Pattern patternSuperTenant = context.getBaseContextPattern();
            if (patternTenant.matcher(requestURI).find() || patternTenant.matcher(requestURI + "/").find()) {
                isContextRewrite = true;
                isWebApp = context.isWebApp();
                contextToForward = context.getContext();
                break;
            }
            if (!this.isTenantQualifiedUrlsEnabled || !patternSuperTenant.matcher(requestURI).find() && !patternSuperTenant.matcher(requestURI + "/").find()) continue;
            ((Map)IdentityUtil.threadLocalProperties.get()).put("TenantNameFromContext", "carbon.super");
            break;
        }
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            MDC.put((String)TENANT_DOMAIN, (String)tenantDomain);
            if (!isContextRewrite) {
                this.getNext().invoke(request, response);
                return;
            }
            this.tenantManager = ContextRewriteValveServiceComponentHolder.getInstance().getRealmService().getTenantManager();
            if (tenantDomain != null && !this.tenantManager.isTenantActive(IdentityTenantUtil.getTenantId((String)tenantDomain))) {
                this.handleInvalidTenantDomainErrorResponse(response, 404, tenantDomain);
            } else if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled() && "carbon.super".equals(tenantDomain)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Tenant qualified URL feature is enabled. Hence restricting the access to super tenant domain via /t/carbon.super context. Super tenant should be invoked without the tenant in context path using the server base path.");
                }
                this.handleRestrictedTenantDomainErrorResponse(response);
            } else {
                ((Map)IdentityUtil.threadLocalProperties.get()).put("TenantNameFromContext", tenantDomain);
                if (isWebApp) {
                    String dispatchLocation = contextListToOverwriteDispatch.contains(contextToForward) ? "" : requestURI.replace("/t/" + tenantDomain + contextToForward, "");
                    request.getContext().setCrossContext(true);
                    request.getServletContext().getContext(contextToForward).getRequestDispatcher("/" + dispatchLocation).forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    String carbonWebContext = ServerConfiguration.getInstance().getFirstProperty("WebContextRoot");
                    if (requestURI.contains(carbonWebContext)) {
                        requestURI = requestURI.replace(carbonWebContext + "/", "");
                    }
                    requestURI = requestURI.replace("/t/" + tenantDomain, "");
                    request.getRequestDispatcher(requestURI).forward((ServletRequest)request, (ServletResponse)response);
                }
            }
        }
        catch (UserStoreException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while validating tenant domain.", (Throwable)ex);
            }
            this.handleInvalidTenantDomainErrorResponse(response, 404, tenantDomain);
        }
        catch (IdentityRuntimeException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while validating tenant domain.", (Throwable)e);
            }
            String INVALID_TENANT_DOMAIN = "Invalid tenant domain";
            if (!StringUtils.isBlank((String)e.getMessage()) && e.getMessage().contains(INVALID_TENANT_DOMAIN)) {
                this.handleInvalidTenantDomainErrorResponse(response, 404, tenantDomain);
            } else {
                this.handleRuntimeErrorResponse(response, 500, tenantDomain);
            }
        }
        finally {
            ((Map)IdentityUtil.threadLocalProperties.get()).remove("TenantNameFromContext");
            MDC.remove((String)TENANT_DOMAIN);
        }
    }

    private boolean isTenantQualifiedUrlsEnabled() {
        Map configuration = IdentityConfigParser.getInstance().getConfiguration();
        String enableTenantQualifiedUrls = (String)configuration.get("EnableTenantQualifiedUrls");
        return Boolean.parseBoolean(enableTenantQualifiedUrls);
    }

    private List<RewriteContext> getContextsToRewrite() {
        Object servletContexts;
        ArrayList<RewriteContext> rewriteContexts = new ArrayList<RewriteContext>();
        Map configuration = IdentityConfigParser.getInstance().getConfiguration();
        Object webAppContexts = configuration.get("TenantContextsToRewrite.WebApp.Context");
        if (webAppContexts != null) {
            if (webAppContexts instanceof ArrayList) {
                for (String context : (ArrayList)webAppContexts) {
                    rewriteContexts.add(new RewriteContext(true, context));
                }
            } else {
                rewriteContexts.add(new RewriteContext(true, webAppContexts.toString()));
            }
        }
        if ((servletContexts = configuration.get("TenantContextsToRewrite.Servlet.Context")) != null) {
            if (servletContexts instanceof ArrayList) {
                for (String context : (ArrayList)servletContexts) {
                    rewriteContexts.add(new RewriteContext(false, context));
                }
            } else {
                rewriteContexts.add(new RewriteContext(false, servletContexts.toString()));
            }
        }
        return rewriteContexts;
    }

    private List<String> getContextListToOverwriteDispatchLocation() {
        Map configuration = IdentityConfigParser.getInstance().getConfiguration();
        Object contexts = configuration.get("TenantContextsToRewrite.OverwriteDispatch.Context");
        if (contexts != null) {
            ArrayList<String> overridingContexts = new ArrayList<String>();
            if (contexts instanceof List) {
                overridingContexts.addAll((List)contexts);
            } else {
                overridingContexts.add(contexts.toString());
            }
            return overridingContexts;
        }
        return Collections.emptyList();
    }

    private void handleRuntimeErrorResponse(Response response, int error, String tenantDomain) throws IOException, ServletException {
        response.setContentType("application/json");
        response.setStatus(error);
        response.setCharacterEncoding("UTF-8");
        JsonObject errorResponse = new JsonObject();
        String errorMsg = "Error occurred while validating tenant domain: " + tenantDomain;
        errorResponse.addProperty("code", (Number)error);
        errorResponse.addProperty("message", errorMsg);
        errorResponse.addProperty("description", errorMsg);
        response.getWriter().print(errorResponse.toString());
    }

    private void handleInvalidTenantDomainErrorResponse(Response response, int error, String tenantDomain) throws IOException, ServletException {
        response.setContentType("application/json");
        response.setStatus(error);
        response.setCharacterEncoding("UTF-8");
        JsonObject errorResponse = new JsonObject();
        String errorMsg = "invalid tenant domain : " + tenantDomain;
        errorResponse.addProperty("code", (Number)error);
        errorResponse.addProperty("message", errorMsg);
        errorResponse.addProperty("description", errorMsg);
        response.getWriter().print(errorResponse.toString());
    }

    private void handleRestrictedTenantDomainErrorResponse(Response response) throws IOException, ServletException {
        response.setContentType("application/json");
        response.setStatus(403);
        response.setCharacterEncoding("UTF-8");
        JsonObject errorResponse = new JsonObject();
        String errorMsg = "Access to super tenant domain over tenanted URL format (/t/carbon.super) is restricted. Please use the server base path instead.";
        errorResponse.addProperty("code", (Number)403);
        errorResponse.addProperty("message", errorMsg);
        errorResponse.addProperty("description", errorMsg);
        response.getWriter().print(errorResponse.toString());
    }

    static {
        log = LogFactory.getLog(TenantContextRewriteValve.class);
    }
}

