/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.context.rewrite.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.context.rewrite.internal.ContextRewriteValveServiceComponentHolder;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="identity.context.rewrite.valve.component", immediate=true)
public class ContextRewriteValveServiceComponent {
    private static final Log log = LogFactory.getLog(ContextRewriteValveServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ContextRewriteValveServiceComponent is activated.");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ContextRewriteValveServiceComponent is deactivated.");
        }
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service.");
        }
        ContextRewriteValveServiceComponentHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Realm Service.");
        }
        ContextRewriteValveServiceComponentHolder.getInstance().setRealmService(null);
    }
}

