/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.email.mgt.ui;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Util {
    private static Map<String, String> localeCodeMap = new HashMap<String, String>();

    public static String getLocaleCode(Locale locale) {
        String languageCode = locale.getLanguage();
        String countryCode = locale.getCountry();
        String string = countryCode = StringUtils.isBlank((String)countryCode) ? languageCode : countryCode;
        if (StringUtils.isNotBlank((String)languageCode) && StringUtils.isNotBlank((String)countryCode)) {
            return languageCode + "_" + countryCode;
        }
        return null;
    }

    public static String getLocaleDisplayName(String localeCode) {
        if (StringUtils.isBlank((String)localeCode)) {
            return null;
        }
        String localeDisplayName = localeCodeMap.get(localeCode.toLowerCase());
        return StringUtils.isBlank((String)localeDisplayName) ? localeCode : localeDisplayName;
    }

    static {
        for (Locale aLocale : Locale.getAvailableLocales()) {
            String localeCode = Util.getLocaleCode(aLocale);
            if (!StringUtils.isNotBlank((String)localeCode)) continue;
            localeCodeMap.put(localeCode.toLowerCase(), aLocale.getDisplayName());
        }
    }
}

