/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.email.mgt.ui;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.email.mgt.model.xsd.EmailTemplate;
import org.wso2.carbon.email.mgt.stub.I18NEmailMgtConfigServiceStub;

public class I18nEmailMgtConfigServiceClient {
    private static final Log log = LogFactory.getLog(I18nEmailMgtConfigServiceClient.class);
    private I18NEmailMgtConfigServiceStub stub;

    public I18nEmailMgtConfigServiceClient(String url, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new I18NEmailMgtConfigServiceStub(configContext, url + "I18nEmailMgtConfigService");
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public I18nEmailMgtConfigServiceClient(String cookie, String url, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new I18NEmailMgtConfigServiceStub(configContext, url + "I18nEmailMgtConfigService");
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    private String[] handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public void addTemplateType(String emailTemplateType) throws AxisFault {
        try {
            this.stub.addEmailTemplateType(emailTemplateType);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public String[] getEmailTemplateTypes() throws AxisFault {
        String[] emailTemplateTypes = new String[]{};
        try {
            emailTemplateTypes = this.stub.getEmailTemplateTypes();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
        return emailTemplateTypes;
    }

    public void saveEmailTemplate(EmailTemplate emailTemplate) throws AxisFault {
        try {
            this.stub.saveEmailTemplate(emailTemplate);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void addEmailTemplate(EmailTemplate emailTemplate) throws AxisFault {
        try {
            this.stub.addEmailTemplate(emailTemplate);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public EmailTemplate[] loadEmailTemplates() throws AxisFault {
        try {
            return this.stub.getAllTemplatesForTenant();
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new EmailTemplate[0];
        }
    }

    public void deleteEmailTemplate(String templateType, String localeCode) throws AxisFault {
        try {
            this.stub.deleteEmailTemplate(templateType, localeCode);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void deleteEmailTemplateType(String templateType) throws AxisFault {
        try {
            this.stub.deleteEmailTemplateType(templateType);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }
}

