/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.util;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.rampart.handler.config.InflowConfiguration;
import org.apache.rampart.handler.config.OutflowConfiguration;
import org.apache.rampart.util.Axis2Util;

public class HandlerParameterDecoder {
    public static void processParameters(MessageContext msgCtx, boolean inflow) throws Exception {
        Parameter outFlowSecParam;
        Parameter inFlowSecParam;
        if (msgCtx.isServerSide()) {
            inFlowSecParam = msgCtx.getParameter("InflowSecurity-server");
            outFlowSecParam = msgCtx.getParameter("OutflowSecurity-server");
        } else {
            inFlowSecParam = msgCtx.getParameter("InflowSecurity-client");
            outFlowSecParam = msgCtx.getParameter("OutflowSecurity-client");
        }
        if (inFlowSecParam == null) {
            inFlowSecParam = (Parameter)msgCtx.getProperty("InflowSecurity");
        }
        if (outFlowSecParam == null) {
            outFlowSecParam = (Parameter)msgCtx.getProperty("OutflowSecurity");
        }
        if (inFlowSecParam == null) {
            inFlowSecParam = msgCtx.getParameter("InflowSecurity");
        }
        if (outFlowSecParam == null) {
            outFlowSecParam = msgCtx.getParameter("OutflowSecurity");
        }
        int repetitionCount = -1;
        if (inFlowSecParam != null && inflow) {
            OMElement inFlowParamElem = inFlowSecParam.getParameterElement();
            OMElement actionElem = inFlowParamElem.getFirstChildWithName(new QName("action"));
            if (actionElem == null) {
                throw new Exception("Inflow configuration must contain an 'action' elements the child of 'InflowSecurity' element");
            }
            Iterator childElements = actionElem.getChildElements();
            while (childElements.hasNext()) {
                OMElement element = (OMElement)childElements.next();
                msgCtx.setProperty(element.getLocalName(), (Object)element.getText().trim());
            }
        }
        if (outFlowSecParam != null && !inflow) {
            OMElement outFlowParamElem = outFlowSecParam.getParameterElement();
            Iterator childElements = outFlowParamElem.getChildElements();
            while (childElements.hasNext()) {
                OMElement element = (OMElement)childElements.next();
                if (!element.getLocalName().equals("action")) {
                    throw new Exception("Alian element '" + element.getLocalName() + "' in the 'OutFlowSecurity' element, only 'action' elements can be present");
                }
                boolean signAllHeaders = false;
                boolean signBody = false;
                boolean encryptBody = false;
                ++repetitionCount;
                Iterator paramElements = element.getChildElements();
                while (paramElements.hasNext()) {
                    OMElement elem = (OMElement)paramElements.next();
                    String localName = elem.getLocalName();
                    String text = elem.getText().trim();
                    if (localName.equals("signAllHeaders")) {
                        signAllHeaders = true;
                        continue;
                    }
                    if (localName.equals("signBody")) {
                        signBody = true;
                        continue;
                    }
                    if (localName.equals("encryptBody")) {
                        encryptBody = true;
                        continue;
                    }
                    msgCtx.setProperty(Axis2Util.getKey(localName, inflow, repetitionCount), (Object)text);
                }
                if (!signAllHeaders && !signBody && !encryptBody) continue;
                HandlerParameterDecoder.handleSignEncrParts(signAllHeaders, signBody, encryptBody, msgCtx, repetitionCount);
            }
            msgCtx.setProperty("senderRepeatCount", (Object)repetitionCount);
        }
    }

    public static OutflowConfiguration getOutflowConfiguration(Parameter outflowConfigParam) throws AxisFault {
        if (outflowConfigParam != null) {
            OMElement outflowParamElem = outflowConfigParam.getParameterElement();
            OMElement actionElem = outflowParamElem.getFirstChildWithName(new QName("action"));
            if (actionElem == null) {
                throw new AxisFault("Inflow configuration must contain an 'action' elements the child of 'InflowSecurity' element");
            }
            OutflowConfiguration outflowConfiguration = new OutflowConfiguration();
            Iterator childElements = actionElem.getChildElements();
            while (childElements.hasNext()) {
                OMElement element = (OMElement)childElements.next();
                String localName = element.getLocalName();
                String text = element.getText().trim();
                if (localName.equals("passwordCallbackClass")) {
                    outflowConfiguration.setPasswordCallbackClass(text);
                    continue;
                }
                if (localName.equals("signaturePropFile")) {
                    outflowConfiguration.setSignaturePropFile(text);
                    continue;
                }
                if (localName.equals("encryptionPropFile")) {
                    outflowConfiguration.setEncryptionPropFile(text);
                    continue;
                }
                if (localName.equals("EmbeddedKeyCallbackClass")) {
                    outflowConfiguration.setEmbeddedKeyCallbackClass(text);
                    continue;
                }
                if (localName.equals("user")) {
                    outflowConfiguration.setUser(text);
                    continue;
                }
                if (!localName.equals("encryptionUser")) continue;
                outflowConfiguration.setEncryptionUser(text);
            }
            return outflowConfiguration;
        }
        return null;
    }

    public static InflowConfiguration getInflowConfiguration(Parameter inflowConfigParam) throws AxisFault {
        if (inflowConfigParam != null) {
            OMElement inFlowParamElem = inflowConfigParam.getParameterElement();
            OMElement actionElem = inFlowParamElem.getFirstChildWithName(new QName("action"));
            if (actionElem == null) {
                throw new AxisFault("Inflow configuration must contain an 'action' elements the child of 'InflowSecurity' element");
            }
            InflowConfiguration inflowConfiguration = new InflowConfiguration();
            Iterator childElements = actionElem.getChildElements();
            while (childElements.hasNext()) {
                OMElement element = (OMElement)childElements.next();
                String localName = element.getLocalName();
                String text = element.getText().trim();
                if (localName.equals("passwordCallbackClass")) {
                    inflowConfiguration.setPasswordCallbackClass(text);
                    continue;
                }
                if (localName.equals("signaturePropFile")) {
                    inflowConfiguration.setSignaturePropFile(text);
                    continue;
                }
                if (localName.equals("decryptionPropFile")) {
                    inflowConfiguration.setDecryptionPropFile(text);
                    continue;
                }
                if (!"enableSignatureConfirmation".equals(localName) || !"false".equals(text) && !"0".equals(text)) continue;
                inflowConfiguration.setEnableSignatureConfirmation(false);
            }
            return inflowConfiguration;
        }
        return null;
    }

    private static void handleSignEncrParts(boolean signAllHeaders, boolean signBody, boolean encrBody, MessageContext msgCtx, int repetition) {
        String soapNs = msgCtx.getEnvelope().getNamespace().getNamespaceURI();
        if (signBody) {
            String sigBodySigPart = "{Element}{" + soapNs + "}Body";
            HandlerParameterDecoder.addSigPart(sigBodySigPart, msgCtx, repetition);
        }
        if (encrBody) {
            String encrBodyEncrPart = "{}{" + soapNs + "}Body";
            HandlerParameterDecoder.addEncrPart(encrBodyEncrPart, msgCtx, repetition);
        }
        if (signAllHeaders) {
            Iterator children = msgCtx.getEnvelope().getHeader().getChildElements();
            while (children.hasNext()) {
                OMElement element = (OMElement)children.next();
                String ns = element.getNamespace().getNamespaceURI();
                if (ns == null || ns.length() <= 0) continue;
                HandlerParameterDecoder.addSigPart("{Element}{" + ns + "}" + element.getLocalName(), msgCtx, repetition);
            }
        }
    }

    private static void addSigPart(String sigPart, MessageContext msgCtx, int repetition) {
        String key = Axis2Util.getKey("signatureParts", false, repetition);
        String existingSignParts = (String)msgCtx.getProperty(key);
        if (existingSignParts != null && existingSignParts.length() > 0) {
            if (existingSignParts.indexOf(sigPart) != -1) {
                msgCtx.setProperty(key, (Object)(existingSignParts + ";" + sigPart));
            }
        } else {
            msgCtx.setProperty(key, (Object)sigPart);
        }
    }

    private static void addEncrPart(String encrPart, MessageContext msgCtx, int repetition) {
        String key = Axis2Util.getKey("encryptionParts", false, repetition);
        String existingEncrParts = (String)msgCtx.getProperty(key);
        if (existingEncrParts != null && existingEncrParts.length() > 0) {
            if (existingEncrParts.indexOf(encrPart) != -1) {
                msgCtx.setProperty(key, (Object)(existingEncrParts + ";" + encrPart));
            }
        } else {
            msgCtx.setProperty(key, (Object)encrPart);
        }
    }
}

