/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.xerces.util.SecurityManager;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Axis2Util {
    private static ThreadLocal doomTacker = new ThreadLocal();
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    private static final Log logger = LogFactory.getLog(Axis2Util.class);

    public static boolean isUseDOOM() {
        Object value = doomTacker.get();
        return value != null;
    }

    public static void useDOOM(boolean isDOOMRequired) {
    }

    public static Document getDocumentFromSOAPEnvelope(SOAPEnvelope env, boolean useDoom) throws WSSecurityException {
        try {
            if (env instanceof Element) {
                return ((Element)env).getOwnerDocument();
            }
            if (useDoom) {
                SOAPFactory factory;
                env.build();
                OMElement firstElement = env.getBody().getFirstElement();
                if (firstElement != null) {
                    firstElement.build();
                }
                SOAPHeader soapHeader = env.getHeader();
                ArrayList<QName> processedHeaderQNames = new ArrayList<QName>();
                if (soapHeader != null) {
                    Iterator headerBlocs = soapHeader.getChildElements();
                    while (headerBlocs.hasNext()) {
                        SOAPHeaderBlock element = (SOAPHeaderBlock)headerBlocs.next();
                        if (!element.isProcessed()) continue;
                        processedHeaderQNames.add(element.getQName());
                    }
                }
                String nsURI = null;
                if (env.getNamespace().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    nsURI = "http://schemas.xmlsoap.org/soap/envelope/";
                    factory = DOOMAbstractFactory.getSOAP11Factory();
                } else {
                    nsURI = "http://www.w3.org/2003/05/soap-envelope";
                    factory = DOOMAbstractFactory.getSOAP12Factory();
                }
                StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(env.getXMLStreamReader(), factory, nsURI);
                SOAPEnvelope envelope = stAXSOAPModelBuilder.getSOAPEnvelope();
                ((OMNode)envelope.getParent()).build();
                SOAPHeader header = envelope.getHeader();
                for (QName name : processedHeaderQNames) {
                    Iterator omKids = header.getChildrenWithName(name);
                    if (!omKids.hasNext()) continue;
                    ((SOAPHeaderBlock)omKids.next()).setProcessed();
                }
                Element envElem = (Element)envelope;
                return envElem.getOwnerDocument();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            env.build();
            env.serialize((OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            DocumentBuilderFactory factory = Axis2Util.getSecuredDocumentBuilderFactory();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(bais);
        }
        catch (Exception e) {
            throw new WSSecurityException("Error in converting SOAP Envelope to Document", (Throwable)e);
        }
    }

    public static SOAPEnvelope getSOAPEnvelopeFromDOMDocument(Document doc, boolean useDoom) throws WSSecurityException {
        if (useDoom) {
            try {
                SOAPEnvelope env = (SOAPEnvelope)doc.getDocumentElement();
                ArrayList<QName> processedHeaderQNames = new ArrayList<QName>();
                SOAPHeader soapHeader = env.getHeader();
                if (soapHeader != null) {
                    Iterator headerBlocs = soapHeader.getChildElements();
                    while (headerBlocs.hasNext()) {
                        OMElement element = (OMElement)headerBlocs.next();
                        SOAPHeaderBlock header = null;
                        if (element instanceof SOAPHeaderBlock) {
                            header = (SOAPHeaderBlock)element;
                        } else {
                            header = soapHeader.addHeaderBlock(element.getLocalName(), element.getNamespace());
                            Iterator attrIter = element.getAllAttributes();
                            while (attrIter.hasNext()) {
                                OMAttribute attr = (OMAttribute)attrIter.next();
                                header.addAttribute(attr.getLocalName(), attr.getAttributeValue(), attr.getNamespace());
                            }
                            Iterator nsIter = element.getAllDeclaredNamespaces();
                            while (nsIter.hasNext()) {
                                OMNamespace ns = (OMNamespace)nsIter.next();
                                header.declareNamespace(ns);
                            }
                            Iterator children = element.getChildren();
                            while (children.hasNext()) {
                                OMNode child = (OMNode)children.next();
                                child.detach();
                                header.addChild(child);
                            }
                            element.detach();
                            soapHeader.build();
                            header.setProcessed();
                        }
                        if (!header.isProcessed()) continue;
                        processedHeaderQNames.add(element.getQName());
                    }
                }
                XMLStreamReader reader = ((OMElement)doc.getDocumentElement()).getXMLStreamReader();
                StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(reader, null);
                SOAPEnvelope envelope = stAXSOAPModelBuilder.getSOAPEnvelope();
                SOAPHeader header = envelope.getHeader();
                for (QName name : processedHeaderQNames) {
                    Iterator omKids = header.getChildrenWithName(name);
                    if (!omKids.hasNext()) continue;
                    ((SOAPHeaderBlock)omKids.next()).setProcessed();
                }
                envelope.build();
                return envelope;
            }
            catch (FactoryConfigurationError e) {
                throw new WSSecurityException(e.getMessage());
            }
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLUtils.outputDOM((Node)doc.getDocumentElement(), (OutputStream)os, (boolean)true);
            ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());
            StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(XMLInputFactory.newInstance().createXMLStreamReader(bais), null);
            return stAXSOAPModelBuilder.getSOAPEnvelope();
        }
        catch (Exception e) {
            throw new WSSecurityException(e.getMessage());
        }
    }

    public static String getKey(String originalKey, boolean inHandler, int repetition) {
        if (!(repetition <= 0 || inHandler || originalKey.equals("OutflowSecurity") || originalKey.equals("senderRepeatCount"))) {
            return originalKey + repetition;
        }
        return originalKey;
    }

    public static OMElement toDOOM(OMFactory factory, OMElement element) {
        StAXOMBuilder builder = new StAXOMBuilder(factory, element.getXMLStreamReader());
        OMElement elem = builder.getDocumentElement();
        elem.build();
        return elem;
    }

    public static DocumentBuilderFactory getSecuredDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }
}

