/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.discovery.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataManagementService;
import org.wso2.carbon.identity.discovery.DefaultOIDCProcessor;
import org.wso2.carbon.identity.discovery.OIDCProcessor;
import org.wso2.carbon.identity.discovery.internal.OIDCDiscoveryDataHolder;

@Component(name="identity.discovery.component", immediate=true)
public class OIDCDiscoveryServiceComponent {
    private static final Log log = LogFactory.getLog(OIDCDiscoveryServiceComponent.class);
    private static BundleContext bundleContext = null;

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    protected void activate(ComponentContext context) {
        try {
            bundleContext = context.getBundleContext();
            bundleContext.registerService(OIDCProcessor.class.getName(), (Object)DefaultOIDCProcessor.getInstance(), null);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity OIDCDiscovery bundle is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating OIDCDiscoveryServiceComponent", e);
        }
    }

    @Reference(name="claim.manager.listener.service", service=ClaimMetadataManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetClaimManagementService")
    protected void setClaimManagementService(ClaimMetadataManagementService registryService) {
        OIDCDiscoveryDataHolder.getInstance().setClaimManagementService(registryService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Identity Claim Management bundle");
        }
    }

    protected void unsetClaimManagementService(ClaimMetadataManagementService registryService) {
        OIDCDiscoveryDataHolder.getInstance().setClaimManagementService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Identity Claim Management bundle");
        }
    }
}

