/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.discovery.builders;

import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfigurationException;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ExternalClaim;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.discovery.DiscoveryUtil;
import org.wso2.carbon.identity.discovery.OIDCDiscoveryEndPointException;
import org.wso2.carbon.identity.discovery.OIDProviderConfigResponse;
import org.wso2.carbon.identity.discovery.OIDProviderRequest;
import org.wso2.carbon.identity.discovery.internal.OIDCDiscoveryDataHolder;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class ProviderConfigBuilder {
    private static final Log log = LogFactory.getLog(ProviderConfigBuilder.class);
    private static final String OIDC_CLAIM_DIALECT = "http://wso2.org/oidc/claim";

    public OIDProviderConfigResponse buildOIDProviderConfig(OIDProviderRequest request) throws OIDCDiscoveryEndPointException, ServerConfigurationException {
        OIDProviderConfigResponse providerConfig = new OIDProviderConfigResponse();
        String tenantDomain = request.getTenantDomain();
        if (DiscoveryUtil.isUseEntityIdAsIssuerInOidcDiscovery()) {
            try {
                providerConfig.setIssuer(OAuth2Util.getIdTokenIssuer((String)tenantDomain));
            }
            catch (IdentityOAuth2Exception e) {
                throw new ServerConfigurationException(String.format("Error while retrieving OIDC Id token issuer value for tenant domain: %s", tenantDomain), (Throwable)e);
            }
        } else {
            providerConfig.setIssuer(OAuth2Util.getIDTokenIssuer());
        }
        providerConfig.setAuthorizationEndpoint(OAuth2Util.OAuthURL.getOAuth2AuthzEPUrl());
        providerConfig.setTokenEndpoint(OAuth2Util.OAuthURL.getOAuth2TokenEPUrl());
        providerConfig.setUserinfoEndpoint(OAuth2Util.OAuthURL.getOAuth2UserInfoEPUrl());
        providerConfig.setRevocationEndpoint(OAuth2Util.OAuthURL.getOAuth2RevocationEPUrl());
        providerConfig.setRevocationEndpointAuthMethodsSupported(OAuth2Util.getSupportedClientAuthenticationMethods().toArray(new String[0]));
        providerConfig.setResponseModesSupported(OAuth2Util.getSupportedResponseModes().toArray(new String[0]));
        providerConfig.setIntrospectionEndpointAuthMethodsSupported(OAuth2Util.getSupportedClientAuthenticationMethods().toArray(new String[0]));
        providerConfig.setCodeChallengeMethodsSupported(OAuth2Util.getSupportedCodeChallengeMethods().toArray(new String[0]));
        try {
            providerConfig.setIntrospectionEndpoint(OAuth2Util.OAuthURL.getOAuth2IntrospectionEPUrl((String)tenantDomain));
            providerConfig.setRegistrationEndpoint(OAuth2Util.OAuthURL.getOAuth2DCREPUrl((String)tenantDomain));
            providerConfig.setJwksUri(OAuth2Util.OAuthURL.getOAuth2JWKSPageUrl((String)tenantDomain));
        }
        catch (URISyntaxException e) {
            throw new ServerConfigurationException("Error while building tenant specific url", (Throwable)e);
        }
        List scopes = OAuth2Util.getOIDCScopes((String)tenantDomain);
        providerConfig.setScopesSupported(scopes.toArray(new String[scopes.size()]));
        try {
            List claims = OIDCDiscoveryDataHolder.getInstance().getClaimManagementService().getExternalClaims(OIDC_CLAIM_DIALECT, tenantDomain);
            String[] claimArray = new String[claims.size() + 2];
            for (int i = 0; i < claims.size(); ++i) {
                claimArray[i] = ((ExternalClaim)claims.get(i)).getClaimURI();
            }
            claimArray[i++] = "iss";
            claimArray[i] = "acr";
            providerConfig.setClaimsSupported(claimArray);
        }
        catch (ClaimMetadataException e) {
            throw new ServerConfigurationException("Error while retrieving OIDC claim dialect", (Throwable)e);
        }
        try {
            providerConfig.setIdTokenSigningAlgValuesSupported(new String[]{OAuth2Util.mapSignatureAlgorithmForJWSAlgorithm((String)OAuthServerConfiguration.getInstance().getIdTokenSignatureAlgorithm()).getName()});
        }
        catch (IdentityOAuth2Exception e) {
            throw new ServerConfigurationException("Unsupported signature algorithm configured.", (Throwable)e);
        }
        Set supportedResponseTypeNames = OAuthServerConfiguration.getInstance().getSupportedResponseTypeNames();
        providerConfig.setResponseTypesSupported(supportedResponseTypeNames.toArray(new String[supportedResponseTypeNames.size()]));
        providerConfig.setSubjectTypesSupported(new String[]{"public"});
        providerConfig.setCheckSessionIframe(OAuth2Util.buildServiceUrl((String)"oidc/checksession", (String)IdentityUtil.getProperty((String)"OAuth.OIDCCheckSessionEPUrl")));
        providerConfig.setEndSessionEndpoint(OAuth2Util.buildServiceUrl((String)"oidc/logout", (String)IdentityUtil.getProperty((String)"OAuth.OIDCLogoutEPUrl")));
        try {
            providerConfig.setUserinfoSigningAlgValuesSupported(new String[]{OAuth2Util.mapSignatureAlgorithmForJWSAlgorithm((String)OAuthServerConfiguration.getInstance().getUserInfoJWTSignatureAlgorithm()).getName()});
        }
        catch (IdentityOAuth2Exception e) {
            throw new ServerConfigurationException("Unsupported signature algorithm configured.", (Throwable)e);
        }
        providerConfig.setTokenEndpointAuthMethodsSupported((String[])OAuth2Util.getSupportedClientAuthenticationMethods().stream().toArray(String[]::new));
        providerConfig.setGrantTypesSupported((String[])OAuth2Util.getSupportedGrantTypes().stream().toArray(String[]::new));
        providerConfig.setRequestParameterSupported(OAuth2Util.isRequestParameterSupported());
        providerConfig.setClaimsParameterSupported(OAuth2Util.isClaimsParameterSupported());
        providerConfig.setRequestObjectSigningAlgValuesSupported((String[])OAuth2Util.getRequestObjectSigningAlgValuesSupported().stream().toArray(String[]::new));
        providerConfig.setBackchannelLogoutSupported(Boolean.TRUE);
        providerConfig.setBackchannelLogoutSessionSupported(Boolean.TRUE);
        return providerConfig;
    }
}

