/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.discovery;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfigurationException;
import org.wso2.carbon.identity.discovery.OIDCDiscoveryEndPointException;
import org.wso2.carbon.identity.discovery.OIDCProcessor;
import org.wso2.carbon.identity.discovery.OIDProviderConfigResponse;
import org.wso2.carbon.identity.discovery.OIDProviderRequest;
import org.wso2.carbon.identity.discovery.builders.DefaultOIDCProviderRequestBuilder;
import org.wso2.carbon.identity.discovery.builders.ProviderConfigBuilder;

public class DefaultOIDCProcessor
implements OIDCProcessor {
    private static final Log log = LogFactory.getLog(DefaultOIDCProcessor.class);
    private static DefaultOIDCProcessor defaultOidcProcessor = new DefaultOIDCProcessor();

    private DefaultOIDCProcessor() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing DefaultOIDCProcessor for OpenID connect discovery processor.");
        }
    }

    public static DefaultOIDCProcessor getInstance() {
        return defaultOidcProcessor;
    }

    @Override
    public OIDProviderConfigResponse getResponse(HttpServletRequest request, String tenantDomain) throws OIDCDiscoveryEndPointException, ServerConfigurationException {
        DefaultOIDCProviderRequestBuilder requestBuilder = new DefaultOIDCProviderRequestBuilder();
        OIDProviderRequest requestObject = requestBuilder.buildRequest(request, tenantDomain);
        ProviderConfigBuilder responseBuilder = new ProviderConfigBuilder();
        return responseBuilder.buildOIDProviderConfig(requestObject);
    }

    @Override
    public int handleError(OIDCDiscoveryEndPointException error) {
        String errorCode;
        if (log.isDebugEnabled()) {
            log.debug((Object)error);
        }
        if ((errorCode = error.getErrorCode()).equals("no_configuration_found")) {
            log.error((Object)"OpenID Provider was not properly found.", (Throwable)error);
        } else if (errorCode.equals("invalid_request")) {
            log.error((Object)"Request is invalid.", (Throwable)error);
        } else if (errorCode.equals("invalid_tenant")) {
            log.error((Object)"Provided tenant is invalid.", (Throwable)error);
        } else if (errorCode.equals("json_error")) {
            log.error((Object)"Error occurred building response.", (Throwable)error);
        } else {
            log.error((Object)"Internal server error occurred.", (Throwable)error);
        }
        return 500;
    }
}

