/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.util.filter;

import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.wsdls.WsdlFilter;
import org.wso2.carbon.governance.api.wsdls.WsdlManager;
import org.wso2.carbon.governance.api.wsdls.dataobjects.Wsdl;
import org.wso2.carbon.governance.list.util.filter.FilterStrategy;
import org.wso2.carbon.registry.core.Registry;

public class FilterWSDL
extends FilterStrategy {
    public FilterWSDL(String criteria, Registry governanceRegistry, String artifactKey) {
        super(criteria, governanceRegistry, artifactKey);
    }

    @Override
    public GovernanceArtifact[] getArtifacts() throws GovernanceException {
        WsdlManager wsdlManager = new WsdlManager(this.getGovernanceRegistry());
        if (this.getCriteria() != null && !"".equals(this.getCriteria())) {
            return wsdlManager.findWsdls(new WsdlFilter(){

                public boolean matches(Wsdl wsdl) throws GovernanceException {
                    String wsdlName = wsdl.getAttribute("registry.wsdl.Name");
                    return FilterWSDL.this.getCriteria() != null && wsdlName != null && wsdlName.contains(FilterWSDL.this.getCriteria());
                }
            });
        }
        return wsdlManager.getAllWsdls();
    }
}

