/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.services.ServiceFilter;
import org.wso2.carbon.governance.api.services.dataobjects.Service;

public class ListServiceFilter
implements ServiceFilter {
    private static final Log log = LogFactory.getLog(ListServiceFilter.class);
    private Service referenceService;

    public ListServiceFilter(Service referenceService) {
        this.referenceService = referenceService;
    }

    public boolean matches(Service service) throws GovernanceException {
        String[] keys;
        if (this.referenceService == null) {
            return true;
        }
        for (String key : keys = this.referenceService.getAttributeKeys()) {
            String[] referenceValues;
            if ("operation".equals(key) || key.toLowerCase().contains("count") || (referenceValues = this.referenceService.getAttributes(key)) == null) continue;
            boolean satisfied = false;
            String[] realValues = service.getAttributes(key);
            if (realValues == null) {
                return false;
            }
            for (String referenceValue : referenceValues) {
                for (String realValue : realValues) {
                    if (realValue.contains(referenceValue)) {
                        satisfied = true;
                        break;
                    }
                    try {
                        if (!realValue.matches(referenceValue)) continue;
                        satisfied = true;
                        break;
                    }
                    catch (Exception e) {
                        String msg = "Error in performing the regular expression matches for: " + referenceValue + ".";
                        throw new GovernanceException(msg, (Throwable)e);
                    }
                }
                if (satisfied) break;
            }
            if (satisfied) continue;
            if (log.isDebugEnabled()) {
                String msg = "key: " + key + " is not satisfied by the service: " + service.getQName() + ".";
                log.debug((Object)msg);
            }
            return false;
        }
        return true;
    }
}

