/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.util;

import java.util.ArrayList;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.policies.PolicyFilter;
import org.wso2.carbon.governance.api.policies.PolicyManager;
import org.wso2.carbon.governance.api.policies.dataobjects.Policy;
import org.wso2.carbon.governance.api.schema.SchemaFilter;
import org.wso2.carbon.governance.api.schema.SchemaManager;
import org.wso2.carbon.governance.api.schema.dataobjects.Schema;
import org.wso2.carbon.governance.api.wsdls.WsdlFilter;
import org.wso2.carbon.governance.api.wsdls.WsdlManager;
import org.wso2.carbon.governance.api.wsdls.dataobjects.Wsdl;
import org.wso2.carbon.registry.core.Registry;

public class GovernanceArtifactListUtil {
    public static String[] filterWsdlByName(Registry governanceRegistry, final String refWsdlName) throws Exception {
        Wsdl[] filteredWsdls;
        ArrayList<String> wsdls = new ArrayList<String>();
        WsdlManager wsdlManager = new WsdlManager(governanceRegistry);
        for (Wsdl wsdl : filteredWsdls = wsdlManager.findWsdls(new WsdlFilter(){

            public boolean matches(Wsdl wsdl) throws GovernanceException {
                String wsdlName = wsdl.getAttribute("registry.wsdl.Name");
                return refWsdlName != null && wsdlName != null && wsdlName.contains(refWsdlName);
            }
        })) {
            String path = wsdl.getPath();
            if (path == null) continue;
            wsdls.add(path);
        }
        return wsdls.toArray(new String[wsdls.size()]);
    }

    public static String[] filterSchemaByName(Registry governanceRegistry, final String refSchemaName) throws Exception {
        Schema[] filteredSchemas;
        ArrayList<String> schemas = new ArrayList<String>();
        SchemaManager schemaManager = new SchemaManager(governanceRegistry);
        for (Schema schema : filteredSchemas = schemaManager.findSchemas(new SchemaFilter(){

            public boolean matches(Schema schema) throws GovernanceException {
                String schemaName = GovernanceArtifactListUtil.getSchemaName(schema);
                return refSchemaName != null && !"".equals(refSchemaName) && schemaName != null && schemaName.contains(refSchemaName);
            }
        })) {
            String path = schema.getPath();
            if (path == null) continue;
            schemas.add(path);
        }
        return schemas.toArray(new String[schemas.size()]);
    }

    public static String[] filterPolicyByName(Registry governanceRegistry, final String refPolicyName) throws Exception {
        Policy[] filteredPolicies;
        ArrayList<String> policies = new ArrayList<String>();
        PolicyManager policyManager = new PolicyManager(governanceRegistry);
        for (Policy policy : filteredPolicies = policyManager.findPolicies(new PolicyFilter(){

            public boolean matches(Policy policy) throws GovernanceException {
                String policyName = GovernanceArtifactListUtil.getPolicyName(policy);
                return refPolicyName != null && !"".equals(refPolicyName) && policyName != null && policyName.contains(refPolicyName);
            }
        })) {
            String path = policy.getPath();
            if (path == null) continue;
            policies.add(path);
        }
        return policies.toArray(new String[policies.size()]);
    }

    private static String getSchemaName(Schema schema) {
        String local = schema.getQName().getLocalPart();
        if (local != null && !"".equals(local)) {
            if (local.contains("\\.")) {
                return local.substring(0, local.lastIndexOf("\\."));
            }
            return local;
        }
        return local;
    }

    private static String getPolicyName(Policy policy) {
        String local = policy.getQName().getLocalPart();
        if (local != null && !"".equals(local)) {
            if (local.contains("\\.")) {
                return local.substring(0, local.lastIndexOf("\\."));
            }
            return local;
        }
        return local;
    }
}

