/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifactImpl;
import org.wso2.carbon.governance.api.exception.GovernanceException;

public class GovernanceArtifactFilter {
    private static final Log log = LogFactory.getLog(GovernanceArtifactFilter.class);
    private GovernanceArtifact referenceArtifact;

    public GovernanceArtifactFilter(GovernanceArtifact referenceArtifact) {
        this.referenceArtifact = referenceArtifact;
    }

    public boolean matches(GovernanceArtifact service) throws GovernanceException {
        if (this.referenceArtifact == null) {
            return true;
        }
        String[] keys = ((GovernanceArtifactImpl)this.referenceArtifact).getAttributeKeys();
        boolean defaultNameMatched = false;
        boolean defaultNamespaceMatched = false;
        for (String key : keys) {
            String[] referenceValues;
            if ("operation".equals(key) || key.toLowerCase().contains("count") || (referenceValues = this.referenceArtifact.getAttributes(key)) == null) continue;
            if (!defaultNameMatched && "overview_name".equals(key) && "C0E6D4A8-C446-4f01-99DB-70E212685A40".equalsIgnoreCase(this.referenceArtifact.getAttribute("overview_name"))) {
                defaultNameMatched = true;
                continue;
            }
            if (!defaultNamespaceMatched && "overview_namespace".equals(key) && ".*".equals(this.referenceArtifact.getAttribute("overview_namespace"))) {
                defaultNamespaceMatched = true;
                continue;
            }
            boolean satisfied = false;
            String[] realValues = service.getAttributes(key);
            if (realValues != null) {
                int n = 0;
                String[] stringArray = referenceValues;
                int n2 = stringArray.length;
                if (n >= n2) continue;
                String referenceValue = stringArray[n];
                for (String realValue : realValues) {
                    if (realValue.toLowerCase().contains(referenceValue.toLowerCase())) {
                        satisfied = true;
                        break;
                    }
                    try {
                        if (!realValue.matches(referenceValue)) continue;
                        satisfied = true;
                        break;
                    }
                    catch (Exception e) {
                        String msg = "Error in performing the regular expression matches for: " + referenceValue + ".";
                        throw new GovernanceException(msg, (Throwable)e);
                    }
                }
                if (satisfied) continue;
                if (log.isDebugEnabled()) {
                    String msg = "key: " + key + " is not satisfied by the service: " + service.getQName() + ".";
                    log.debug((Object)msg);
                }
                return false;
            }
            return false;
        }
        return true;
    }
}

