/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.operations;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.list.operations.AbstractOperation;
import org.wso2.carbon.governance.list.operations.util.OperationUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class UpdateOperation
extends AbstractOperation {
    private Log log = LogFactory.getLog(UpdateOperation.class);
    private boolean succeed;

    public UpdateOperation(QName name, Registry governanceSystemRegistry, String mediatype, String namespace) {
        super(name, governanceSystemRegistry, mediatype, namespace);
    }

    @Override
    public void setPayload(OMElement bodyContent) throws XMLStreamException {
        OMFactory factory = bodyContent.getOMFactory();
        OMElement returnElement = factory.createOMElement(new QName(bodyContent.getNamespace().getPrefix() + ":return"));
        returnElement.setText(String.valueOf(this.succeed));
        bodyContent.addChild((OMNode)returnElement);
    }

    @Override
    public String getRequestName() {
        return "updatedInfo";
    }

    @Override
    public String getRequestType() {
        return "xs:string";
    }

    @Override
    public String getResponseType() {
        return "xs:boolean";
    }

    @Override
    public String getResponseMaxOccurs() {
        return "1";
    }

    @Override
    public MessageContext process(MessageContext requestMessageContext) throws AxisFault {
        String msg;
        OMElement content = null;
        String artifactId = null;
        try {
            OMElement artifactIdOM;
            OMElement info = requestMessageContext.getEnvelope().getBody().getFirstElement().getFirstChildWithName(new QName(this.namespace, "updatedInfo"));
            if (info != null) {
                content = AXIOMUtil.stringToOM((String)info.getText());
            }
            if ((artifactIdOM = requestMessageContext.getEnvelope().getBody().getFirstElement().getFirstChildWithName(new QName(this.namespace, "artifactId"))) != null) {
                artifactId = artifactIdOM.getText();
            }
            if (content == null) {
                String msg2 = "Content of the resource should be in correct format";
                this.log.error((Object)msg2);
                OperationUtil.handleException(msg2);
            }
        }
        catch (XMLStreamException e) {
            msg = "Error occurred while reading the content of the SOAP message";
            this.log.error((Object)msg);
            OperationUtil.handleException(msg, e);
        }
        try {
            GenericArtifactManager artifactManager = new GenericArtifactManager(this.governanceSystemRegistry, this.rxtKey);
            GenericArtifact artifact = artifactManager.newGovernanceArtifact(content);
            if (!artifactId.isEmpty()) {
                artifact.setId(artifactId);
            }
            artifactManager.updateGenericArtifact(artifact);
        }
        catch (RegistryException e) {
            msg = e.getMessage();
            this.log.error((Object)msg);
            OperationUtil.handleException(msg, (Exception)((Object)e));
        }
        this.succeed = true;
        return this.getAbstractResponseMessageContext(requestMessageContext);
    }
}

