/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.operations;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.list.operations.AbstractOperation;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class GetDependenciesOperation
extends AbstractOperation {
    private Log log = LogFactory.getLog(GetDependenciesOperation.class);
    private List<String> dependencies = new ArrayList<String>();

    public GetDependenciesOperation(QName name, Registry governanceSystemRegistry, String mediatype, String namespace) {
        super(name, governanceSystemRegistry, mediatype, namespace);
    }

    @Override
    public void setPayload(OMElement bodyContent) throws XMLStreamException {
        OMFactory factory = bodyContent.getOMFactory();
        for (String dependency : this.dependencies) {
            OMElement returnElement = factory.createOMElement(new QName(bodyContent.getNamespace().getPrefix() + ":return"));
            returnElement.setText(dependency);
            bodyContent.addChild((OMNode)returnElement);
        }
    }

    @Override
    public String getRequestName() {
        return "artifactId";
    }

    @Override
    public String getRequestType() {
        return "xs:string";
    }

    @Override
    public String getResponseType() {
        return "xs:string";
    }

    @Override
    public String getResponseMaxOccurs() {
        return "unbounded";
    }

    @Override
    public MessageContext process(MessageContext requestMessageContext) throws AxisFault {
        String artifactId;
        try {
            String operation = requestMessageContext.getOperationContext().getAxisOperation().getName().getLocalPart();
            AXIOMXPath expression = new AXIOMXPath("//ns:" + operation + "/ns:artifactId");
            expression.addNamespace("ns", this.namespace);
            artifactId = ((OMElement)expression.selectNodes((Object)requestMessageContext.getEnvelope().getBody()).get(0)).getText().trim();
        }
        catch (JaxenException e) {
            String msg = "Error occured while reading the content of the SOAP message";
            this.log.error((Object)msg);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            String msg = "Content of the resource should be in correct format";
            this.log.error((Object)msg);
            throw new AxisFault(msg, (Throwable)e);
        }
        try {
            Association[] associations;
            String path = GovernanceUtils.getArtifactPath((Registry)this.governanceSystemRegistry, (String)artifactId);
            for (Association association : associations = this.governanceSystemRegistry.getAssociations(path, "depends")) {
                if (!association.getSourcePath().equals(path)) continue;
                String destinationPath = association.getDestinationPath();
                this.dependencies.add(this.governanceSystemRegistry.get(destinationPath).getUUID());
            }
        }
        catch (RegistryException e) {
            String msg = e.getMessage();
            this.log.error((Object)msg);
            throw new AxisFault(msg, (Throwable)e);
        }
        return this.getAbstractResponseMessageContext(requestMessageContext);
    }
}

