/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.list.operations;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.wso2.carbon.governance.list.operations.MessageProcessor;
import org.wso2.carbon.governance.list.operations.RXTMessageReceiver;
import org.wso2.carbon.registry.core.Registry;

public abstract class AbstractOperation
extends InOutAxisOperation
implements MessageProcessor {
    private Log log = LogFactory.getLog(AbstractOperation.class);
    protected String rxtKey;
    protected Registry governanceSystemRegistry;
    protected String name;
    protected String mediaType;
    protected String namespace;
    protected String singlularName;

    protected AbstractOperation(QName name, Registry governanceSystemRegistry, String mediaType, String namespace) {
        super(name);
        this.governanceSystemRegistry = governanceSystemRegistry;
        this.name = name.getLocalPart();
        this.mediaType = mediaType;
        this.namespace = namespace;
    }

    public AbstractOperation init(String rxtKey, RXTMessageReceiver receiver) {
        this.rxtKey = rxtKey;
        receiver.setMessageProcessor(this.name, this);
        this.setMessageReceiver(receiver);
        AxisMessage in = this.getMessage("In");
        in.setName(this.name + "Request");
        in.setElementQName(new QName(this.namespace, this.name));
        AxisMessage out = this.getMessage("Out");
        out.setName(this.name + "Response");
        out.setElementQName(new QName(this.namespace, this.name + "Response"));
        AxisMessage fault = new AxisMessage();
        fault.setName(this.name + "ServiceGovernanceException");
        fault.setElementQName(new QName(this.namespace, this.name + "ServiceGovernanceException"));
        this.setFaultMessages(fault);
        return this;
    }

    public XmlSchema[] getSchemas(XmlSchemaCollection collection) {
        String str = this.getCustomSchema();
        return Arrays.asList(collection.read((Source)new StreamSource(new ByteArrayInputStream(str.getBytes())), null)).toArray(new XmlSchema[1]);
    }

    public MessageContext getAbstractResponseMessageContext(MessageContext requestMessageContext) throws AxisFault {
        MessageContext outMessageCtx = MessageContextBuilder.createOutMessageContext((MessageContext)requestMessageContext);
        SOAPFactory factory = this.getSOAPFactory(requestMessageContext);
        AxisOperation operation = requestMessageContext.getOperationContext().getAxisOperation();
        AxisService service = requestMessageContext.getAxisService();
        AxisMessage outMessage = operation.getMessage("Out");
        OMElement bodyContent = factory.createOMElement(outMessage.getName(), factory.createOMNamespace(this.namespace, service.getSchemaTargetNamespacePrefix()));
        try {
            this.setPayload(bodyContent);
        }
        catch (XMLStreamException e) {
            String msg = "Error in adding the payload to the response message";
            this.log.error((Object)msg);
            throw new AxisFault(msg, (Throwable)e);
        }
        SOAPEnvelope soapEnvelope = factory.getDefaultEnvelope();
        soapEnvelope.getBody().addChild((OMNode)bodyContent);
        outMessageCtx.setEnvelope(soapEnvelope);
        return outMessageCtx;
    }

    public SOAPFactory getSOAPFactory(MessageContext msgContext) throws AxisFault {
        String nsURI = msgContext.getEnvelope().getNamespace().getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage((String)"invalidSOAPversion"));
    }

    private String getCustomSchema() {
        OMElement omElement = null;
        try {
            omElement = AXIOMUtil.stringToOM((String)"<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:ax2234=\"http://exception.api.governance.carbon.wso2.org/xsd\" attributeFormDefault=\"qualified\" elementFormDefault=\"qualified\">\n            <xs:import namespace=\"http://exception.api.governance.carbon.wso2.org/xsd\" />\n            <xs:element>\n                <xs:complexType>\n                    <xs:sequence>\n                        <xs:element minOccurs=\"0\" name=\"GovernanceException\" nillable=\"true\" type=\"ax2234:GovernanceException\" />\n                    </xs:sequence>\n                </xs:complexType>\n            </xs:element>\n            <xs:element>\n                <xs:complexType>\n                    <xs:sequence>\n                        <xs:element minOccurs=\"0\" nillable=\"true\"/>\n                    </xs:sequence>\n                </xs:complexType>\n            </xs:element>\n            <xs:element>\n                <xs:complexType>\n                    <xs:sequence>\n                        <xs:element minOccurs=\"0\" name=\"return\"/>\n                    </xs:sequence>\n                </xs:complexType>\n            </xs:element>\n        </xs:schema>");
            omElement.addAttribute("targetNamespace", this.namespace, null);
            AXIOMXPath expression = new AXIOMXPath("xs:element");
            expression.addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            List elements = expression.selectNodes((Object)omElement);
            OMElement element1 = (OMElement)elements.get(0);
            element1.addAttribute("name", this.name + "ServiceGovernanceException", null);
            OMElement element2 = (OMElement)elements.get(1);
            element2.addAttribute("name", this.name, null);
            expression = new AXIOMXPath("xs:complexType/xs:sequence/xs:element");
            expression.addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            OMElement ep2 = (OMElement)expression.selectNodes((Object)element2).get(0);
            String requestType = this.getRequestType();
            if (!requestType.equals("")) {
                ep2.addAttribute("name", this.getRequestName(), null);
                ep2.addAttribute("type", requestType, null);
            } else {
                ep2.detach();
            }
            OMElement element3 = (OMElement)elements.get(2);
            element3.addAttribute("name", this.name + "Response", null);
            expression = new AXIOMXPath("xs:complexType/xs:sequence/xs:element");
            expression.addNamespace("xs", "http://www.w3.org/2001/XMLSchema");
            OMElement ep3 = (OMElement)expression.selectNodes((Object)element3).get(0);
            ep3.addAttribute("type", this.getResponseType(), null);
            ep3.addAttribute("maxOccurs", this.getResponseMaxOccurs(), null);
        }
        catch (Exception e) {
            this.log.error((Object)"Error while creating the custom Schema");
        }
        return omElement.toString();
    }

    public abstract void setPayload(OMElement var1) throws XMLStreamException;

    public abstract String getRequestName();

    public abstract String getRequestType();

    public abstract String getResponseType();

    public abstract String getResponseMaxOccurs();
}

