/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.tuple;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringBuilder;

public class ComboList
extends AbstractList<Object> {
    Pointer[] _index;
    List[] _delegates;

    public ComboList(List[] delegates, Pointer[] index) {
        this._index = index;
        this._delegates = delegates;
    }

    @Override
    public Object get(int i) {
        Pointer ptr = this._index[i];
        return this._delegates[ptr.listIndex].get(ptr.subIndex);
    }

    @Override
    public int size() {
        return this._index.length;
    }

    private static class Pointer
    implements Serializable {
        int listIndex;
        int subIndex;

        public Pointer(int listIndex, int subIndex) {
            this.listIndex = listIndex;
            this.subIndex = subIndex;
        }
    }

    public static class Factory
    implements Serializable {
        Pointer[] index;
        int[] sizes;

        public Factory(int ... sizes) {
            this.sizes = sizes;
            int total = 0;
            for (int size : sizes) {
                total += size;
            }
            this.index = new Pointer[total];
            int i = 0;
            int j = 0;
            for (int size : sizes) {
                for (int z = 0; z < size; ++z) {
                    this.index[j] = new Pointer(i, z);
                    ++j;
                }
                ++i;
            }
        }

        public ComboList create(List[] delegates) {
            if (delegates.length != this.sizes.length) {
                throw new RuntimeException("Expected " + this.sizes.length + " lists, but instead got " + delegates.length + " lists");
            }
            for (int i = 0; i < delegates.length; ++i) {
                List l = delegates[i];
                if (l != null && l.size() == this.sizes[i]) continue;
                throw new RuntimeException("Got unexpected delegates to ComboList: " + ToStringBuilder.reflectionToString(delegates));
            }
            return new ComboList(delegates, this.index);
        }
    }
}

