/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.topology;

import backtype.storm.generated.GlobalStreamId;
import backtype.storm.generated.Grouping;
import backtype.storm.generated.StormTopology;
import backtype.storm.grouping.CustomStreamGrouping;
import backtype.storm.grouping.PartialKeyGrouping;
import backtype.storm.topology.BaseConfigurationDeclarer;
import backtype.storm.topology.BoltDeclarer;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.InputDeclarer;
import backtype.storm.topology.SpoutDeclarer;
import backtype.storm.topology.TopologyBuilder;
import backtype.storm.tuple.Fields;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringStyle;
import storm.trident.spout.BatchSpoutExecutor;
import storm.trident.spout.IBatchSpout;
import storm.trident.spout.ICommitterTridentSpout;
import storm.trident.spout.ITridentSpout;
import storm.trident.spout.RichSpoutBatchTriggerer;
import storm.trident.spout.TridentSpoutCoordinator;
import storm.trident.spout.TridentSpoutExecutor;
import storm.trident.topology.ITridentBatchBolt;
import storm.trident.topology.MasterBatchCoordinator;
import storm.trident.topology.TridentBoltExecutor;

public class TridentTopologyBuilder {
    Map<GlobalStreamId, String> _batchIds = new HashMap<GlobalStreamId, String>();
    Map<String, TransactionalSpoutComponent> _spouts = new HashMap<String, TransactionalSpoutComponent>();
    Map<String, SpoutComponent> _batchPerTupleSpouts = new HashMap<String, SpoutComponent>();
    Map<String, Component> _bolts = new HashMap<String, Component>();
    static final String SPOUT_COORD_PREFIX = "$spoutcoord-";

    public SpoutDeclarer setBatchPerTupleSpout(String id, String streamName, IRichSpout spout2, Integer parallelism, String batchGroup) {
        HashMap<String, String> batchGroups = new HashMap<String, String>();
        batchGroups.put(streamName, batchGroup);
        this.markBatchGroups(id, batchGroups);
        SpoutComponent c = new SpoutComponent(spout2, streamName, parallelism, batchGroup);
        this._batchPerTupleSpouts.put(id, c);
        return new SpoutDeclarerImpl(c);
    }

    public SpoutDeclarer setSpout(String id, String streamName, String txStateId, IBatchSpout spout2, Integer parallelism, String batchGroup) {
        return this.setSpout(id, streamName, txStateId, new BatchSpoutExecutor(spout2), parallelism, batchGroup);
    }

    public SpoutDeclarer setSpout(String id, String streamName, String txStateId, ITridentSpout spout2, Integer parallelism, String batchGroup) {
        HashMap<String, String> batchGroups = new HashMap<String, String>();
        batchGroups.put(streamName, batchGroup);
        this.markBatchGroups(id, batchGroups);
        TransactionalSpoutComponent c = new TransactionalSpoutComponent(spout2, streamName, parallelism, txStateId, batchGroup);
        this._spouts.put(id, c);
        return new SpoutDeclarerImpl(c);
    }

    public BoltDeclarer setBolt(String id, ITridentBatchBolt bolt2, Integer parallelism, Set<String> committerBatches, Map<String, String> batchGroups) {
        this.markBatchGroups(id, batchGroups);
        Component c = new Component(bolt2, parallelism, committerBatches);
        this._bolts.put(id, c);
        return new BoltDeclarerImpl(c);
    }

    String masterCoordinator(String batchGroup) {
        return "$mastercoord-" + batchGroup;
    }

    public static String spoutCoordinator(String spoutId) {
        return SPOUT_COORD_PREFIX + spoutId;
    }

    public static String spoutIdFromCoordinatorId(String coordId) {
        return coordId.substring(SPOUT_COORD_PREFIX.length());
    }

    Map<GlobalStreamId, String> fleshOutStreamBatchIds(boolean includeCommitStream) {
        HashMap<GlobalStreamId, String> ret = new HashMap<GlobalStreamId, String>(this._batchIds);
        HashSet<String> allBatches = new HashSet<String>(this._batchIds.values());
        for (String b : allBatches) {
            ret.put(new GlobalStreamId(this.masterCoordinator(b), "$batch"), b);
            if (!includeCommitStream) continue;
            ret.put(new GlobalStreamId(this.masterCoordinator(b), "$commit"), b);
        }
        for (String id : this._spouts.keySet()) {
            TransactionalSpoutComponent c = this._spouts.get(id);
            if (c.batchGroupId == null) continue;
            ret.put(new GlobalStreamId(TridentTopologyBuilder.spoutCoordinator(id), "$batch"), c.batchGroupId);
        }
        for (GlobalStreamId s : this._batchIds.keySet()) {
            String b = this._batchIds.get(s);
            ret.put(new GlobalStreamId(s.get_componentId(), TridentBoltExecutor.COORD_STREAM(b)), b);
        }
        return ret;
    }

    public StormTopology buildTopology() {
        Object c;
        TopologyBuilder builder = new TopologyBuilder();
        Map<GlobalStreamId, String> batchIdsForSpouts = this.fleshOutStreamBatchIds(false);
        Map<GlobalStreamId, String> batchIdsForBolts = this.fleshOutStreamBatchIds(true);
        HashMap batchesToCommitIds = new HashMap();
        HashMap batchesToSpouts = new HashMap();
        for (String id : this._spouts.keySet()) {
            c = this._spouts.get(id);
            if (((TransactionalSpoutComponent)c).spout instanceof IRichSpout) {
                builder.setSpout(id, (IRichSpout)((TransactionalSpoutComponent)c).spout, ((TransactionalSpoutComponent)c).parallelism);
                continue;
            }
            String batchGroup = ((TransactionalSpoutComponent)c).batchGroupId;
            if (!batchesToCommitIds.containsKey(batchGroup)) {
                batchesToCommitIds.put(batchGroup, new ArrayList());
            }
            ((List)batchesToCommitIds.get(batchGroup)).add(((TransactionalSpoutComponent)c).commitStateId);
            if (!batchesToSpouts.containsKey(batchGroup)) {
                batchesToSpouts.put(batchGroup, new ArrayList());
            }
            ((List)batchesToSpouts.get(batchGroup)).add((ITridentSpout)((TransactionalSpoutComponent)c).spout);
            BoltDeclarer scd = (BoltDeclarer)((BoltDeclarer)builder.setBolt(TridentTopologyBuilder.spoutCoordinator(id), new TridentSpoutCoordinator(((TransactionalSpoutComponent)c).commitStateId, (ITridentSpout)((TransactionalSpoutComponent)c).spout)).globalGrouping(this.masterCoordinator(((TransactionalSpoutComponent)c).batchGroupId), "$batch")).globalGrouping(this.masterCoordinator(((TransactionalSpoutComponent)c).batchGroupId), "$success");
            for (Map m : ((TransactionalSpoutComponent)c).componentConfs) {
                scd.addConfigurations(m);
            }
            HashMap<String, TridentBoltExecutor.CoordSpec> hashMap = new HashMap<String, TridentBoltExecutor.CoordSpec>();
            hashMap.put(((TransactionalSpoutComponent)c).batchGroupId, new TridentBoltExecutor.CoordSpec());
            BoltDeclarer bd = builder.setBolt(id, new TridentBoltExecutor(new TridentSpoutExecutor(((TransactionalSpoutComponent)c).commitStateId, ((TransactionalSpoutComponent)c).streamName, (ITridentSpout)((TransactionalSpoutComponent)c).spout), batchIdsForSpouts, hashMap), (Number)((TransactionalSpoutComponent)c).parallelism);
            bd.allGrouping(TridentTopologyBuilder.spoutCoordinator(id), "$batch");
            bd.allGrouping(this.masterCoordinator(batchGroup), "$success");
            if (((TransactionalSpoutComponent)c).spout instanceof ICommitterTridentSpout) {
                bd.allGrouping(this.masterCoordinator(batchGroup), "$commit");
            }
            for (Map m : ((TransactionalSpoutComponent)c).componentConfs) {
                bd.addConfigurations(m);
            }
        }
        for (String id : this._batchPerTupleSpouts.keySet()) {
            c = this._batchPerTupleSpouts.get(id);
            SpoutDeclarer d = builder.setSpout(id, new RichSpoutBatchTriggerer((IRichSpout)((SpoutComponent)c).spout, ((SpoutComponent)c).streamName, ((SpoutComponent)c).batchGroupId), ((SpoutComponent)c).parallelism);
            for (Map map : ((SpoutComponent)c).componentConfs) {
                d.addConfigurations(map);
            }
        }
        for (String batch : batchesToCommitIds.keySet()) {
            List commitIds = (List)batchesToCommitIds.get(batch);
            builder.setSpout(this.masterCoordinator(batch), new MasterBatchCoordinator(commitIds, (List)batchesToSpouts.get(batch)));
        }
        for (String id : this._bolts.keySet()) {
            c = this._bolts.get(id);
            HashMap<String, TridentBoltExecutor.CoordSpec> specs = new HashMap<String, TridentBoltExecutor.CoordSpec>();
            for (GlobalStreamId globalStreamId : this.getBoltSubscriptionStreams(id)) {
                String batch = batchIdsForBolts.get(globalStreamId);
                if (!specs.containsKey(batch)) {
                    specs.put(batch, new TridentBoltExecutor.CoordSpec());
                }
                TridentBoltExecutor.CoordSpec spec = (TridentBoltExecutor.CoordSpec)specs.get(batch);
                TridentBoltExecutor.CoordType ct = this._batchPerTupleSpouts.containsKey(globalStreamId.get_componentId()) ? TridentBoltExecutor.CoordType.single() : TridentBoltExecutor.CoordType.all();
                spec.coords.put(globalStreamId.get_componentId(), ct);
            }
            for (String string : ((Component)c).committerBatches) {
                ((TridentBoltExecutor.CoordSpec)specs.get((Object)string)).commitStream = new GlobalStreamId(this.masterCoordinator(string), "$commit");
            }
            BoltDeclarer d = builder.setBolt(id, new TridentBoltExecutor(((Component)c).bolt, batchIdsForBolts, specs), (Number)((Component)c).parallelism);
            for (Map conf : ((Component)c).componentConfs) {
                d.addConfigurations(conf);
            }
            for (InputDeclaration inputDecl : ((Component)c).declarations) {
                inputDecl.declare(d);
            }
            Map<String, Set<String>> map = this.getBoltBatchToComponentSubscriptions(id);
            for (String b3 : map.keySet()) {
                for (String comp : map.get(b3)) {
                    d.directGrouping(comp, TridentBoltExecutor.COORD_STREAM(b3));
                }
            }
            for (String b : ((Component)c).committerBatches) {
                d.allGrouping(this.masterCoordinator(b), "$commit");
            }
        }
        return builder.createTopology();
    }

    private void markBatchGroups(String component, Map<String, String> batchGroups) {
        for (String stream : batchGroups.keySet()) {
            this._batchIds.put(new GlobalStreamId(component, stream), batchGroups.get(stream));
        }
    }

    Map<String, Set<String>> getBoltBatchToComponentSubscriptions(String id) {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        for (GlobalStreamId s : this.getBoltSubscriptionStreams(id)) {
            String b = this._batchIds.get(s);
            if (!ret.containsKey(b)) {
                ret.put(b, new HashSet());
            }
            ((Set)ret.get(b)).add(s.get_componentId());
        }
        return ret;
    }

    List<GlobalStreamId> getBoltSubscriptionStreams(String id) {
        ArrayList<GlobalStreamId> ret = new ArrayList<GlobalStreamId>();
        Component c = this._bolts.get(id);
        for (InputDeclaration d : c.declarations) {
            ret.add(new GlobalStreamId(d.getComponent(), d.getStream()));
        }
        return ret;
    }

    private class BoltDeclarerImpl
    extends BaseConfigurationDeclarer<BoltDeclarer>
    implements BoltDeclarer {
        Component _component;

        public BoltDeclarerImpl(Component component) {
            this._component = component;
        }

        @Override
        public BoltDeclarer fieldsGrouping(final String component, final Fields fields2) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.fieldsGrouping(component, fields2);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer fieldsGrouping(final String component, final String streamId, final Fields fields2) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.fieldsGrouping(component, streamId, fields2);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer globalGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.globalGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer globalGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.globalGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer shuffleGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.shuffleGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer shuffleGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.shuffleGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer localOrShuffleGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.localOrShuffleGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer localOrShuffleGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.localOrShuffleGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer noneGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.noneGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer noneGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.noneGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer allGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.allGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer allGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.allGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer directGrouping(final String component) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.directGrouping(component);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer directGrouping(final String component, final String streamId) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.directGrouping(component, streamId);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer partialKeyGrouping(String componentId, Fields fields2) {
            return this.customGrouping(componentId, new PartialKeyGrouping(fields2));
        }

        @Override
        public BoltDeclarer partialKeyGrouping(String componentId, String streamId, Fields fields2) {
            return this.customGrouping(componentId, streamId, new PartialKeyGrouping(fields2));
        }

        @Override
        public BoltDeclarer customGrouping(final String component, final CustomStreamGrouping grouping) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.customGrouping(component, grouping);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return null;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer customGrouping(final String component, final String streamId, final CustomStreamGrouping grouping) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.customGrouping(component, streamId, grouping);
                }

                @Override
                public String getComponent() {
                    return component;
                }

                @Override
                public String getStream() {
                    return streamId;
                }
            });
            return this;
        }

        @Override
        public BoltDeclarer grouping(final GlobalStreamId stream, final Grouping grouping) {
            this.addDeclaration(new InputDeclaration(){

                @Override
                public void declare(InputDeclarer declarer) {
                    declarer.grouping(stream, grouping);
                }

                @Override
                public String getComponent() {
                    return stream.get_componentId();
                }

                @Override
                public String getStream() {
                    return stream.get_streamId();
                }
            });
            return this;
        }

        private void addDeclaration(InputDeclaration declaration) {
            this._component.declarations.add(declaration);
        }

        @Override
        public BoltDeclarer addConfigurations(Map conf) {
            this._component.componentConfs.add(conf);
            return this;
        }
    }

    private class SpoutDeclarerImpl
    extends BaseConfigurationDeclarer<SpoutDeclarer>
    implements SpoutDeclarer {
        SpoutComponent _component;

        public SpoutDeclarerImpl(SpoutComponent component) {
            this._component = component;
        }

        @Override
        public SpoutDeclarer addConfigurations(Map conf) {
            this._component.componentConfs.add(conf);
            return this;
        }
    }

    private static interface InputDeclaration {
        public void declare(InputDeclarer var1);

        public String getComponent();

        public String getStream();
    }

    private static class Component {
        public ITridentBatchBolt bolt;
        public Integer parallelism;
        public List<InputDeclaration> declarations = new ArrayList<InputDeclaration>();
        public List<Map> componentConfs = new ArrayList<Map>();
        public Set<String> committerBatches;

        public Component(ITridentBatchBolt bolt2, Integer parallelism, Set<String> committerBatches) {
            this.bolt = bolt2;
            this.parallelism = parallelism;
            this.committerBatches = committerBatches;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
        }
    }

    private static class TransactionalSpoutComponent
    extends SpoutComponent {
        public String commitStateId;

        public TransactionalSpoutComponent(Object spout2, String streamName, Integer parallelism, String commitStateId, String batchGroupId) {
            super(spout2, streamName, parallelism, batchGroupId);
            this.commitStateId = commitStateId;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
        }
    }

    private static class SpoutComponent {
        public Object spout;
        public Integer parallelism;
        public List<Map> componentConfs = new ArrayList<Map>();
        String batchGroupId;
        String streamName;

        public SpoutComponent(Object spout2, String streamName, Integer parallelism, String batchGroupId) {
            this.spout = spout2;
            this.streamName = streamName;
            this.parallelism = parallelism;
            this.batchGroupId = batchGroupId;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }
    }
}

