/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.topology;

import backtype.storm.coordination.BatchOutputCollector;
import backtype.storm.coordination.BatchOutputCollectorImpl;
import backtype.storm.generated.GlobalStreamId;
import backtype.storm.task.IOutputCollector;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.FailedException;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.ReportedFailedException;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import backtype.storm.utils.RotatingMap;
import backtype.storm.utils.TupleUtils;
import backtype.storm.utils.Utils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.storm.shade.org.apache.commons.lang.builder.ToStringBuilder;
import storm.trident.spout.IBatchID;
import storm.trident.topology.BatchInfo;
import storm.trident.topology.ITridentBatchBolt;

public class TridentBoltExecutor
implements IRichBolt {
    public static String COORD_STREAM_PREFIX = "$coord-";
    Map<GlobalStreamId, String> _batchGroupIds;
    Map<String, CoordSpec> _coordSpecs;
    Map<String, CoordCondition> _coordConditions;
    ITridentBatchBolt _bolt;
    long _messageTimeoutMs;
    long _lastRotate;
    RotatingMap _batches;
    OutputCollector _collector;
    CoordinatedOutputCollector _coordCollector;
    BatchOutputCollector _coordOutputCollector;
    TopologyContext _context;

    public static String COORD_STREAM(String batch) {
        return COORD_STREAM_PREFIX + batch;
    }

    public TridentBoltExecutor(ITridentBatchBolt bolt2, Map<GlobalStreamId, String> batchGroupIds, Map<String, CoordSpec> coordinationSpecs) {
        this._batchGroupIds = batchGroupIds;
        this._coordSpecs = coordinationSpecs;
        this._bolt = bolt2;
    }

    @Override
    public void prepare(Map conf, TopologyContext context2, OutputCollector collector) {
        this._messageTimeoutMs = (long)context2.maxTopologyMessageTimeout() * 1000L;
        this._lastRotate = System.currentTimeMillis();
        this._batches = new RotatingMap(2);
        this._context = context2;
        this._collector = collector;
        this._coordCollector = new CoordinatedOutputCollector(collector);
        this._coordOutputCollector = new BatchOutputCollectorImpl(new OutputCollector(this._coordCollector));
        this._coordConditions = (Map)context2.getExecutorData("__coordConditions");
        if (this._coordConditions == null) {
            this._coordConditions = new HashMap<String, CoordCondition>();
            for (String batchGroup : this._coordSpecs.keySet()) {
                CoordSpec spec = this._coordSpecs.get(batchGroup);
                CoordCondition cond = new CoordCondition();
                cond.commitStream = spec.commitStream;
                cond.expectedTaskReports = 0;
                for (String comp : spec.coords.keySet()) {
                    CoordType ct = spec.coords.get(comp);
                    if (ct.equals(CoordType.single())) {
                        ++cond.expectedTaskReports;
                        continue;
                    }
                    cond.expectedTaskReports += context2.getComponentTasks(comp).size();
                }
                cond.targetTasks = new HashSet<Integer>();
                for (String component : ((Map)Utils.get(context2.getThisTargets(), TridentBoltExecutor.COORD_STREAM(batchGroup), new HashMap())).keySet()) {
                    cond.targetTasks.addAll(context2.getComponentTasks(component));
                }
                this._coordConditions.put(batchGroup, cond);
            }
            context2.setExecutorData("_coordConditions", this._coordConditions);
        }
        this._bolt.prepare(conf, context2, this._coordOutputCollector);
    }

    private void failBatch(TrackedBatch tracked, FailedException e) {
        if (e != null && e instanceof ReportedFailedException) {
            this._collector.reportError(e);
        }
        tracked.failed = true;
        if (tracked.delayedAck != null) {
            this._collector.fail(tracked.delayedAck);
            tracked.delayedAck = null;
        }
    }

    private void failBatch(TrackedBatch tracked) {
        this.failBatch(tracked, null);
    }

    private boolean finishBatch(TrackedBatch tracked, Tuple finishTuple) {
        boolean success = true;
        try {
            this._bolt.finishBatch(tracked.info);
            String stream = TridentBoltExecutor.COORD_STREAM(tracked.info.batchGroup);
            for (Integer task2 : tracked.condition.targetTasks) {
                this._collector.emitDirect((int)task2, stream, finishTuple, (List<Object>)new Values(tracked.info.batchId, Utils.get(tracked.taskEmittedTuples, task2, 0)));
            }
            if (tracked.delayedAck != null) {
                this._collector.ack(tracked.delayedAck);
                tracked.delayedAck = null;
            }
        }
        catch (FailedException e) {
            this.failBatch(tracked, e);
            success = false;
        }
        this._batches.remove(tracked.info.batchId.getId());
        return success;
    }

    private void checkFinish(TrackedBatch tracked, Tuple tuple2, TupleType type) {
        boolean delayed;
        if (tracked.failed) {
            this.failBatch(tracked);
            this._collector.fail(tuple2);
            return;
        }
        CoordCondition cond = tracked.condition;
        boolean bl = delayed = tracked.delayedAck == null && (cond.commitStream != null && type == TupleType.COMMIT || cond.commitStream == null);
        if (delayed) {
            tracked.delayedAck = tuple2;
        }
        boolean failed = false;
        if (tracked.receivedCommit && tracked.reportedTasks == cond.expectedTaskReports) {
            if (tracked.receivedTuples == tracked.expectedTupleCount) {
                this.finishBatch(tracked, tuple2);
            } else {
                this.failBatch(tracked);
                this._collector.fail(tuple2);
                failed = true;
            }
        }
        if (!delayed && !failed) {
            this._collector.ack(tuple2);
        }
    }

    @Override
    public void execute(Tuple tuple2) {
        if (TupleUtils.isTick(tuple2)) {
            long now2 = System.currentTimeMillis();
            if (now2 - this._lastRotate > this._messageTimeoutMs) {
                this._batches.rotate();
                this._lastRotate = now2;
            }
            return;
        }
        String batchGroup = this._batchGroupIds.get(tuple2.getSourceGlobalStreamid());
        if (batchGroup == null) {
            this._coordCollector.setCurrBatch(null);
            this._bolt.execute(null, tuple2);
            this._collector.ack(tuple2);
            return;
        }
        IBatchID id = (IBatchID)tuple2.getValue(0);
        TrackedBatch tracked = (TrackedBatch)this._batches.get(id.getId());
        if (tracked != null) {
            if (id.getAttemptId() > tracked.attemptId) {
                this._batches.remove(id.getId());
                tracked = null;
            } else if (id.getAttemptId() < tracked.attemptId) {
                return;
            }
        }
        if (tracked == null) {
            tracked = new TrackedBatch(new BatchInfo(batchGroup, id, this._bolt.initBatchState(batchGroup, id)), this._coordConditions.get(batchGroup), id.getAttemptId());
            this._batches.put(id.getId(), tracked);
        }
        this._coordCollector.setCurrBatch(tracked);
        TupleType t = this.getTupleType(tuple2, tracked);
        if (t == TupleType.COMMIT) {
            tracked.receivedCommit = true;
            this.checkFinish(tracked, tuple2, t);
        } else if (t == TupleType.COORD) {
            int count = tuple2.getInteger(1);
            ++tracked.reportedTasks;
            tracked.expectedTupleCount += count;
            this.checkFinish(tracked, tuple2, t);
        } else {
            ++tracked.receivedTuples;
            boolean success = true;
            try {
                this._bolt.execute(tracked.info, tuple2);
                if (tracked.condition.expectedTaskReports == 0) {
                    success = this.finishBatch(tracked, tuple2);
                }
            }
            catch (FailedException e) {
                this.failBatch(tracked, e);
            }
            if (success) {
                this._collector.ack(tuple2);
            } else {
                this._collector.fail(tuple2);
            }
        }
        this._coordCollector.setCurrBatch(null);
    }

    @Override
    public void cleanup() {
        this._bolt.cleanup();
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this._bolt.declareOutputFields(declarer);
        for (String batchGroup : this._coordSpecs.keySet()) {
            declarer.declareStream(TridentBoltExecutor.COORD_STREAM(batchGroup), true, new Fields("id", "count"));
        }
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        Map<String, Object> ret = this._bolt.getComponentConfiguration();
        if (ret == null) {
            ret = new HashMap<String, Object>();
        }
        ret.put("topology.tick.tuple.freq.secs", 5);
        return ret;
    }

    private TupleType getTupleType(Tuple tuple2, TrackedBatch batch) {
        CoordCondition cond = batch.condition;
        if (cond.commitStream != null && tuple2.getSourceGlobalStreamid().equals(cond.commitStream)) {
            return TupleType.COMMIT;
        }
        if (cond.expectedTaskReports > 0 && tuple2.getSourceStreamId().startsWith(COORD_STREAM_PREFIX)) {
            return TupleType.COORD;
        }
        return TupleType.REGULAR;
    }

    static enum TupleType {
        REGULAR,
        COMMIT,
        COORD;

    }

    public class CoordinatedOutputCollector
    implements IOutputCollector {
        IOutputCollector _delegate;
        TrackedBatch _currBatch = null;

        public void setCurrBatch(TrackedBatch batch) {
            this._currBatch = batch;
        }

        public CoordinatedOutputCollector(IOutputCollector delegate) {
            this._delegate = delegate;
        }

        @Override
        public List<Integer> emit(String stream, Collection<Tuple> anchors, List<Object> tuple2) {
            List<Integer> tasks = this._delegate.emit(stream, anchors, tuple2);
            this.updateTaskCounts(tasks);
            return tasks;
        }

        @Override
        public void emitDirect(int task2, String stream, Collection<Tuple> anchors, List<Object> tuple2) {
            this.updateTaskCounts(Arrays.asList(task2));
            this._delegate.emitDirect(task2, stream, anchors, tuple2);
        }

        @Override
        public void ack(Tuple tuple2) {
            throw new IllegalStateException("Method should never be called");
        }

        @Override
        public void fail(Tuple tuple2) {
            throw new IllegalStateException("Method should never be called");
        }

        @Override
        public void reportError(Throwable error2) {
            this._delegate.reportError(error2);
        }

        private void updateTaskCounts(List<Integer> tasks) {
            if (this._currBatch != null) {
                Map<Integer, Integer> taskEmittedTuples = this._currBatch.taskEmittedTuples;
                for (Integer task2 : tasks) {
                    int newCount = Utils.get(taskEmittedTuples, task2, 0) + 1;
                    taskEmittedTuples.put(task2, newCount);
                }
            }
        }
    }

    public static class TrackedBatch {
        int attemptId;
        BatchInfo info;
        CoordCondition condition;
        int reportedTasks = 0;
        int expectedTupleCount = 0;
        int receivedTuples = 0;
        Map<Integer, Integer> taskEmittedTuples = new HashMap<Integer, Integer>();
        boolean failed = false;
        boolean receivedCommit;
        Tuple delayedAck = null;

        public TrackedBatch(BatchInfo info2, CoordCondition condition, int attemptId) {
            this.info = info2;
            this.condition = condition;
            this.attemptId = attemptId;
            this.receivedCommit = condition.commitStream == null;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }
    }

    public static class CoordCondition
    implements Serializable {
        public GlobalStreamId commitStream;
        public int expectedTaskReports;
        Set<Integer> targetTasks;

        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }
    }

    public static class CoordSpec
    implements Serializable {
        public GlobalStreamId commitStream = null;
        public Map<String, CoordType> coords = new HashMap<String, CoordType>();
    }

    public static class CoordType
    implements Serializable {
        public boolean singleCount;

        protected CoordType(boolean singleCount) {
            this.singleCount = singleCount;
        }

        public static CoordType single() {
            return new CoordType(true);
        }

        public static CoordType all() {
            return new CoordType(false);
        }

        public boolean equals(Object o) {
            return this.singleCount == ((CoordType)o).singleCount;
        }

        public String toString() {
            return "<Single: " + this.singleCount + ">";
        }
    }
}

