/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.state.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import storm.trident.state.map.IBackingMap;

public class CachedBatchReadsMap<T> {
    Map<List<Object>, T> _cached = new HashMap<List<Object>, T>();
    public IBackingMap<T> _delegate;

    public CachedBatchReadsMap(IBackingMap<T> delegate) {
        this._delegate = delegate;
    }

    public void reset() {
        this._cached.clear();
    }

    public List<RetVal<T>> multiGet(List<List<Object>> keys) {
        List<T> vals = this._delegate.multiGet(keys);
        ArrayList<RetVal<T>> ret = new ArrayList<RetVal<T>>(vals.size());
        for (int i = 0; i < keys.size(); ++i) {
            List<Object> key = keys.get(i);
            if (this._cached.containsKey(key)) {
                ret.add(new RetVal<T>(this._cached.get(key), true));
                continue;
            }
            ret.add(new RetVal<T>(vals.get(i), false));
        }
        return ret;
    }

    public void multiPut(List<List<Object>> keys, List<T> vals) {
        this._delegate.multiPut(keys, vals);
        this.cache(keys, vals);
    }

    private void cache(List<List<Object>> keys, List<T> vals) {
        for (int i = 0; i < keys.size(); ++i) {
            List<Object> key = keys.get(i);
            T val = vals.get(i);
            this._cached.put(key, val);
        }
    }

    public static class RetVal<T> {
        public boolean cached;
        public T val;

        public RetVal(T v, boolean c) {
            this.val = v;
            this.cached = c;
        }
    }
}

